/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm;

import com.zebra.sdk.comm.ConnectionA;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.internal.ConnectionInfo;
import com.zebra.sdk.comm.internal.DriverConnectionReestablisher;
import com.zebra.sdk.comm.internal.NotMyConnectionDataException;
import com.zebra.sdk.comm.internal.ZDriverAdapter;
import com.zebra.sdk.printer.discovery.DiscoveredPrinterDriver;
import com.zebra.sdk.printer.discovery.UsbDiscoverer;
import com.zebra.sdk.util.internal.RegexUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

public class DriverPrinterConnection
extends ConnectionA {
    private String printerName;
    private ByteArrayOutputStream bOut;

    protected DriverPrinterConnection(ConnectionInfo connectionInfo) throws NotMyConnectionDataException {
        String string = System.getProperty("os.name").toLowerCase();
        if (!string.contains("windows")) {
            throw new NotMyConnectionDataException("Invalid OS");
        }
        String string2 = "^\\s*((?i)USB:)?([^:]+)\\s*$";
        String string3 = connectionInfo.getMyData();
        List<String> list = RegexUtil.getMatches(string2, string3);
        if (list.isEmpty()) {
            throw new NotMyConnectionDataException("USB Connection doesn't understand " + string3);
        }
        this.printerName = list.get(2);
        this.maxTimeoutForRead = 15000;
        this.timeToWaitForMoreData = 1500;
        new ByteArrayInputStream(new byte[0]);
        this.bOut = new ByteArrayOutputStream();
    }

    public DriverPrinterConnection(String string) throws ConnectionException {
        this(string, 15000, 1500);
    }

    public DriverPrinterConnection(String string, int n, int n2) throws ConnectionException {
        String string2 = System.getProperty("os.name").toLowerCase();
        if (!string2.contains("windows")) {
            throw new ConnectionException("Invalid OS");
        }
        this.maxTimeoutForRead = n;
        this.timeToWaitForMoreData = n2;
        this.printerName = string;
        new ByteArrayInputStream(new byte[0]);
        this.bOut = new ByteArrayOutputStream();
    }

    private String getConnectionBuilderPrefix() {
        return "USB";
    }

    public String getPrinterName() {
        return this.printerName;
    }

    @Override
    public void open() throws ConnectionException {
        DiscoveredPrinterDriver[] discoveredPrinterDriverArray;
        if (!ZDriverAdapter.isDriverLoaded) {
            throw new ConnectionException("The native code dll is not loaded.");
        }
        if (this.isConnected) {
            return;
        }
        boolean bl = false;
        for (DiscoveredPrinterDriver discoveredPrinterDriver : discoveredPrinterDriverArray = UsbDiscoverer.getZebraDriverPrinters()) {
            if (!discoveredPrinterDriver.printerName.equalsIgnoreCase(this.printerName)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new ConnectionException("No installed printer named " + this.printerName);
        }
        if (!ZDriverAdapter.OpenPrinter(this.printerName)) {
            throw new ConnectionException("Failed to open printer " + this.printerName);
        }
        this.isConnected = true;
    }

    @Override
    public void close() throws ConnectionException {
        if (!ZDriverAdapter.isDriverLoaded) {
            throw new ConnectionException("The native code dll is not loaded.");
        }
        if (this.isConnected) {
            if (!ZDriverAdapter.ClosePrinter(this.printerName)) {
                throw new ConnectionException("Failed to close printer " + this.printerName);
            }
            this.isConnected = false;
        }
    }

    @Override
    public byte[] read() throws ConnectionException {
        if (this.isConnected) {
            byte[] byArray = this.bOut.size() > 0 ? this.bOut.toByteArray() : new byte[]{};
            byte[] byArray2 = this.readFromPrinter();
            byte[] byArray3 = new byte[byArray2.length + byArray.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            this.bOut = new ByteArrayOutputStream();
            return byArray3;
        }
        return null;
    }

    @Override
    public int readChar() throws ConnectionException {
        if (this.isConnected) {
            byte[] byArray = this.bOut.size() == 0 ? this.readFromPrinter() : this.bOut.toByteArray();
            this.bOut = new ByteArrayOutputStream();
            this.bOut.write(byArray, 1, byArray.length - 1);
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws ConnectionException {
        if (!ZDriverAdapter.isDriverLoaded) {
            throw new ConnectionException("The native code dll is not loaded.");
        }
        if (!this.isConnected()) {
            throw new ConnectionException("The connection is not open");
        }
        File file = null;
        try {
            file = File.createTempFile("_zsdk_", "_zsdk_");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray, n, n2);
            fileOutputStream.flush();
            fileOutputStream.close();
            if (!ZDriverAdapter.SendFileToPrinter(this.printerName, file.getAbsolutePath())) {
                throw new ConnectionException("Error writing to connection: " + this.printerName);
            }
            this.writeToLogStream(byArray, n, n2);
            file.delete();
        }
        catch (IOException iOException) {
            throw new ConnectionException("Error preparing data for writing to connection");
        }
        finally {
            if (file != null && file.exists()) {
                file.delete();
            }
        }
    }

    @Override
    public int bytesAvailable() throws ConnectionException {
        int n = 0;
        if (this.isConnected && this.bOut.size() == 0) {
            byte[] byArray = this.readFromPrinter();
            if (byArray.length < 0) {
                throw new ConnectionException("Failed to read from the USB port: " + this.printerName);
            }
            if (byArray.length > 0) {
                try {
                    this.bOut.write(byArray);
                }
                catch (IOException iOException) {
                    throw new ConnectionException("Failed to read from the USB port: " + this.printerName);
                }
                n += byArray.length;
            }
        } else {
            n = this.bOut.size();
        }
        return n;
    }

    protected byte[] readFromPrinter() {
        byte[] byArray = null;
        if (ZDriverAdapter.isDriverLoaded) {
            byArray = ZDriverAdapter.GetBinaryDataFromPrinter(this.printerName);
        }
        return byArray;
    }

    @Override
    public String toString() {
        return this.getConnectionBuilderPrefix() + ":" + this.getPrinterName();
    }

    @Override
    public String getSimpleConnectionName() {
        return this.getPrinterName();
    }

    @Override
    public ConnectionReestablisher getConnectionReestablisher(long l) throws ConnectionException {
        return new DriverConnectionReestablisher(this, l);
    }
}

