/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.MultichannelConnection;
import com.zebra.sdk.comm.TcpConnection;
import com.zebra.sdk.comm.TcpStatusConnection;
import com.zebra.sdk.comm.internal.ConnectionInfo;
import com.zebra.sdk.comm.internal.MultichannelTcpConnectionReestablisher;
import com.zebra.sdk.comm.internal.NotMyConnectionDataException;
import com.zebra.sdk.printer.discovery.DiscoveredPrinter;
import com.zebra.sdk.util.internal.IPv6Util;
import com.zebra.sdk.util.internal.StringUtilities;
import java.util.Map;

public class MultichannelTcpConnection
extends MultichannelConnection {
    public static final int DEFAULT_MULTICHANNEL_PRINTING_PORT = 9100;
    public static final int DEFAULT_MULTICHANNEL_STATUS_PORT = 9200;

    protected String getConnectionBuilderPrefix() {
        return "TCP_MULTI";
    }

    protected MultichannelTcpConnection(ConnectionInfo connectionInfo) throws NotMyConnectionDataException {
        try {
            String string = connectionInfo.getMyData();
            IPv6Util.ParsedMultiChannelConnection parsedMultiChannelConnection = IPv6Util.parseMultiChannelConnectionInfo(string, 9100, 9200, this.getConnectionBuilderPrefix());
            this.init(parsedMultiChannelConnection.address, parsedMultiChannelConnection.printPort, parsedMultiChannelConnection.statusPort, 15000, 1500, 15000, 1500);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new NotMyConnectionDataException(illegalArgumentException.getMessage());
        }
    }

    public MultichannelTcpConnection(DiscoveredPrinter discoveredPrinter) {
        this(discoveredPrinter, 15000, 1500);
    }

    public MultichannelTcpConnection(DiscoveredPrinter discoveredPrinter, int n, int n2) {
        this(discoveredPrinter, n, n2, n, n2);
    }

    public MultichannelTcpConnection(DiscoveredPrinter discoveredPrinter, int n, int n2, int n3, int n4) {
        Map<String, String> map = discoveredPrinter.getDiscoveryDataMap();
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("The DiscoveredPrinter argument does not appear to be a Link-OS printer");
        }
        try {
            String string = StringUtilities.getStringValueForKey(map, "ADDRESS");
            int n5 = StringUtilities.getIntValueForKey(map, "PORT_NUMBER");
            int n6 = StringUtilities.getIntValueForKey(map, "JSON_PORT_NUMBER");
            this.init(string, n5, n6, n, n2, n3, n4);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException("The DiscoveredPrinter argument does not appear to be a Link-OS printer");
        }
    }

    public MultichannelTcpConnection(String string, int n, int n2) {
        this(string, n, n2, 15000, 1500);
    }

    public MultichannelTcpConnection(String string, int n, int n2, int n3, int n4) {
        this(string, n, n2, n3, n4, n3, n4);
    }

    public MultichannelTcpConnection(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        this.init(string, n, n2, n3, n4, n5, n6);
    }

    protected void init(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        this.raw = new TcpConnection(string, n, n3, n4);
        this.settings = new TcpStatusConnection(string, n2, n5, n6);
    }

    @Override
    public ConnectionReestablisher getConnectionReestablisher(long l) throws ConnectionException {
        return new MultichannelTcpConnectionReestablisher(this, l);
    }

    @Override
    public String toString() {
        String string = ((TcpConnection)this.raw).getAddress();
        if (string.contains(":") && !string.startsWith("[")) {
            string = "[" + string + "]";
        }
        return this.getConnectionBuilderPrefix() + ":" + string + ":" + ((TcpConnection)this.raw).getPortNumber() + ":" + ((TcpStatusConnection)this.settings).getPortNumber();
    }

    @Override
    public String getSimpleConnectionName() {
        return ((TcpConnection)this.raw).getSimpleConnectionName();
    }
}

