/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.MultichannelConnection;
import com.zebra.sdk.comm.TlsConfig;
import com.zebra.sdk.comm.TlsConnection;
import com.zebra.sdk.comm.TlsStatusConnection;
import com.zebra.sdk.comm.internal.ConnectionInfo;
import com.zebra.sdk.comm.internal.MultichannelTlsConnectionReestablisher;
import com.zebra.sdk.comm.internal.NotMyConnectionDataException;
import com.zebra.sdk.util.internal.IPv6Util;

public class MultichannelTlsConnection
extends MultichannelConnection {
    public static final int DEFAULT_MULTICHANNEL_PRINTING_PORT = 9143;
    public static final int DEFAULT_MULTICHANNEL_STATUS_PORT = 9243;

    protected String getConnectionBuilderPrefix() {
        return "TLS_MULTI";
    }

    protected MultichannelTlsConnection(ConnectionInfo connectionInfo) throws NotMyConnectionDataException {
        try {
            String string = connectionInfo.getMyData();
            IPv6Util.ParsedMultiChannelConnection parsedMultiChannelConnection = IPv6Util.parseMultiChannelConnectionInfo(string, 9143, 9243, this.getConnectionBuilderPrefix());
            this.init(parsedMultiChannelConnection.address, parsedMultiChannelConnection.printPort, parsedMultiChannelConnection.statusPort, TlsConfig.trustAll(), 15000, 1500, 15000, 1500);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new NotMyConnectionDataException(illegalArgumentException.getMessage());
        }
    }

    public MultichannelTlsConnection(String string, int n, int n2, TlsConfig tlsConfig) {
        this(string, n, n2, tlsConfig, 15000, 1500);
    }

    public MultichannelTlsConnection(String string, int n, int n2, TlsConfig tlsConfig, int n3, int n4) {
        this(string, n, n2, tlsConfig, n3, n4, n3, n4);
    }

    public MultichannelTlsConnection(String string, int n, int n2, TlsConfig tlsConfig, int n3, int n4, int n5, int n6) {
        this.init(string, n, n2, tlsConfig, n3, n4, n5, n6);
    }

    protected void init(String string, int n, int n2, TlsConfig tlsConfig, int n3, int n4, int n5, int n6) {
        this.raw = new TlsConnection(string, n, tlsConfig, n3, n4);
        this.settings = new TlsStatusConnection(string, n2, tlsConfig, n5, n6);
    }

    @Override
    public ConnectionReestablisher getConnectionReestablisher(long l) throws ConnectionException {
        return new MultichannelTlsConnectionReestablisher(this, l);
    }

    @Override
    public String toString() {
        String string = ((TlsConnection)this.raw).getAddress();
        if (string.contains(":") && !string.startsWith("[")) {
            string = "[" + string + "]";
        }
        return this.getConnectionBuilderPrefix() + ":" + string + ":" + ((TlsConnection)this.raw).getPortNumber() + ":" + ((TlsStatusConnection)this.settings).getPortNumber();
    }

    @Override
    public String getSimpleConnectionName() {
        return ((TlsConnection)this.raw).getSimpleConnectionName();
    }
}

