/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm;

import com.zebra.sdk.comm.ConnectionA;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.IpAddressable;
import com.zebra.sdk.comm.TcpZebraConnectorImpl;
import com.zebra.sdk.comm.internal.ConnectionI;
import com.zebra.sdk.comm.internal.ConnectionInfo;
import com.zebra.sdk.comm.internal.NotMyConnectionDataException;
import com.zebra.sdk.comm.internal.TcpConnectionReestablisher;
import com.zebra.sdk.comm.internal.ZebraConnector;
import com.zebra.sdk.util.internal.IPv6Util;
import com.zebra.sdk.util.internal.ReflectionUtil;

public class TcpConnection
extends ConnectionA
implements IpAddressable,
ConnectionI {
    public static final int DEFAULT_ZPL_TCP_PORT = 9100;
    public static final int DEFAULT_CPCL_TCP_PORT = 6101;
    public boolean isCardPrinter = false;
    public String serialNumber = "";

    protected TcpConnection(ConnectionInfo connectionInfo) throws NotMyConnectionDataException {
        String string = connectionInfo.getMyData();
        IPv6Util.ParsedConnection parsedConnection = IPv6Util.parseConnectionInfo(string, this.getDefaultPort(), this.getConnectionBuilderPrefix());
        this.zebraConnector = new TcpZebraConnectorImpl(parsedConnection.address, parsedConnection.port);
        this.maxTimeoutForRead = 15000;
        this.timeToWaitForMoreData = 1500;
    }

    protected int getDefaultPort() {
        return 9100;
    }

    protected String getConnectionBuilderPrefix() {
        return "TCP";
    }

    public TcpConnection(String string, int n) {
        this(string, n, 15000, 1500);
    }

    public TcpConnection(String string, int n, int n2, int n3) {
        this(new TcpZebraConnectorImpl(string, n), n2, n3);
    }

    private TcpConnection(ZebraConnector zebraConnector, int n, int n2) {
        this.zebraConnector = zebraConnector;
        this.maxTimeoutForRead = n;
        this.timeToWaitForMoreData = n2;
    }

    @Override
    public String toString() {
        String string = this.getAddress();
        if (string.contains(":") && !string.startsWith("[")) {
            string = "[" + string + "]";
        }
        return this.getConnectionBuilderPrefix() + ":" + string + ":" + this.getPortNumber();
    }

    @Override
    public String getSimpleConnectionName() {
        return this.getAddress();
    }

    @Override
    public String getAddress() {
        return ((TcpZebraConnectorImpl)this.zebraConnector).getAddress();
    }

    @Override
    public String getPortNumber() {
        return String.valueOf(((TcpZebraConnectorImpl)this.zebraConnector).getPort());
    }

    @Override
    public ConnectionReestablisher getConnectionReestablisher(long l) throws ConnectionException {
        if (this.isCardPrinter) {
            return ReflectionUtil.loadTcpCardConnectionReestablisher(this, l);
        }
        return new TcpConnectionReestablisher(this, l);
    }
}

