/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.TlsMode;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class TlsConfig {
    public final TlsMode mode;
    public final InputStream caCertificateStream;
    public final TrustManager[] trustManagers;

    private TlsConfig(TlsMode tlsMode, InputStream inputStream, TrustManager[] trustManagerArray) {
        this.mode = tlsMode;
        this.caCertificateStream = inputStream;
        this.trustManagers = trustManagerArray;
    }

    public static TlsConfig trustAll() {
        return new TlsConfig(TlsMode.TRUST_ALL, null, null);
    }

    public static TlsConfig trustJavaKeyStore() throws ConnectionException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            return new TlsConfig(TlsMode.VALIDATE_WITH_TRUST_MANAGER, null, trustManagerFactory.getTrustManagers());
        }
        catch (Exception exception) {
            throw new ConnectionException(exception.getMessage());
        }
    }

    public static TlsConfig fromCertificateFile(String string) throws ConnectionException {
        try {
            if (string == null || string.trim().isEmpty()) {
                throw new ConnectionException("Certificate file path cannot be empty");
            }
            FileInputStream fileInputStream = new FileInputStream(string);
            return new TlsConfig(TlsMode.VALIDATE_WITH_CERT_FILE, fileInputStream, null);
        }
        catch (Exception exception) {
            throw new ConnectionException(exception.getMessage());
        }
    }
}

