/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm;

import com.zebra.sdk.comm.ConnectionA;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.IpAddressable;
import com.zebra.sdk.comm.TlsConfig;
import com.zebra.sdk.comm.TlsZebraConnectorImpl;
import com.zebra.sdk.comm.internal.ConnectionI;
import com.zebra.sdk.comm.internal.ConnectionInfo;
import com.zebra.sdk.comm.internal.NotMyConnectionDataException;
import com.zebra.sdk.comm.internal.TlsConnectionReestablisher;
import com.zebra.sdk.comm.internal.ZebraConnector;
import com.zebra.sdk.util.internal.IPv6Util;

public class TlsConnection
extends ConnectionA
implements IpAddressable,
ConnectionI {
    public static final int DEFAULT_TLS_PORT = 9143;
    private final TlsConfig tlsConfig;

    public TlsConnection(String string, int n, TlsConfig tlsConfig) {
        this(string, n, tlsConfig, 15000, 1500);
    }

    public TlsConnection(String string, int n, TlsConfig tlsConfig, int n2, int n3) {
        if (tlsConfig == null) {
            throw new IllegalArgumentException("TlsConfig cannot be null");
        }
        this.tlsConfig = tlsConfig;
        this.isTLS = true;
        this.zebraConnector = new TlsZebraConnectorImpl(string, n, this.tlsConfig);
        this.maxTimeoutForRead = n2;
        this.timeToWaitForMoreData = n3;
    }

    protected TlsConnection(ConnectionInfo connectionInfo) throws NotMyConnectionDataException {
        this.tlsConfig = TlsConfig.trustAll();
        this.isTLS = true;
        String string = connectionInfo.getMyData();
        IPv6Util.ParsedConnection parsedConnection = IPv6Util.parseConnectionInfo(string, 9143, this.getConnectionBuilderPrefix());
        this.zebraConnector = new TlsZebraConnectorImpl(parsedConnection.address, parsedConnection.port, this.tlsConfig);
        this.maxTimeoutForRead = 15000;
        this.timeToWaitForMoreData = 1500;
    }

    protected int getDefaultPort() {
        return 9143;
    }

    protected String getConnectionBuilderPrefix() {
        return "TLS";
    }

    private TlsConnection(ZebraConnector zebraConnector, TlsConfig tlsConfig, int n, int n2) {
        this.isTLS = true;
        this.tlsConfig = tlsConfig;
        this.zebraConnector = zebraConnector;
        this.maxTimeoutForRead = n;
        this.timeToWaitForMoreData = n2;
    }

    @Override
    public String toString() {
        String string = this.getAddress();
        if (string.contains(":") && !string.startsWith("[")) {
            string = "[" + string + "]";
        }
        return this.getConnectionBuilderPrefix() + ":" + string + ":" + this.getPortNumber();
    }

    @Override
    public String getSimpleConnectionName() {
        return this.getAddress();
    }

    @Override
    public String getAddress() {
        return ((TlsZebraConnectorImpl)this.zebraConnector).getAddress();
    }

    @Override
    public String getPortNumber() {
        return String.valueOf(((TlsZebraConnectorImpl)this.zebraConnector).getPort());
    }

    public TlsConfig getTlsConfig() {
        return this.tlsConfig;
    }

    @Override
    public ConnectionReestablisher getConnectionReestablisher(long l) throws ConnectionException {
        return new TlsConnectionReestablisher(this, l);
    }
}

