/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.internal.ConnectionInfo;
import com.zebra.sdk.printer.internal.VerbosePrinter;
import com.zebra.sdk.util.internal.Sleeper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ConnectionBuilderInternal {
    private static final String MULTICHANNEL_BLUETOOTH_CONNECTION = "com.zebra.sdk.comm.MultichannelBluetoothConnection";
    private static final String BLUETOOTH_CONNECTION_INSECURE = "com.zebra.sdk.comm.BluetoothConnectionInsecure";
    private static final String BLUETOOTH_CONNECTION = "com.zebra.sdk.comm.BluetoothConnection";
    private static final String BLUETOOTH_STATUS_CONNECTION_INSECURE = "com.zebra.sdk.comm.BluetoothStatusConnectionInsecure";
    private static final String BLUETOOTH_STATUS_CONNECTION = "com.zebra.sdk.comm.BluetoothStatusConnection";
    public static Set<Class<?>> implementingClasses = null;
    private static boolean isConnBuilderVerbose = false;

    public static void setConnBuilderVerbosity(boolean bl) {
        isConnBuilderVerbose = bl;
    }

    public static boolean isConnBuilderVerbose() {
        return isConnBuilderVerbose;
    }

    public static Connection build(String string) throws ConnectionException {
        if (implementingClasses == null) {
            throw new RuntimeException("Builder not correctly implemented");
        }
        string = ConnectionBuilderInternal.formatConnection(string);
        VerbosePrinter verbosePrinter = new VerbosePrinter(isConnBuilderVerbose);
        verbosePrinter.println("Building connection for the string \"" + string + "\"");
        ConnectionInfo connectionInfo = new ConnectionInfo(string);
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        Connection connection = null;
        for (Class<?> clazz : implementingClasses) {
            try {
                connection = ConnectionBuilderInternal.reflectivelyInstatiateConnection(connectionInfo, clazz);
                arrayList.add(connection);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ConnectionException(clazz.getName() + " does not implement a constructor that takes a ConnectionInfo object");
            }
            catch (Exception exception) {
                throw new ConnectionException(exception.getMessage());
            }
        }
        if (arrayList.isEmpty()) {
            verbosePrinter.println("Could not determine connection type of the value \"" + string + "\"");
            throw new ConnectionException("Invalid connection type");
        }
        if (arrayList.size() == 1) {
            verbosePrinter.println("Determined connection string \"" + string + "\" is of type " + ((Connection)arrayList.get(0)).getClass().getSimpleName());
            return (Connection)arrayList.get(0);
        }
        Connection connection2 = ConnectionBuilderInternal.determineConnectionToTry(arrayList, verbosePrinter);
        if (connection2 == null) {
            throw new ConnectionException("Could not open connection string \"" + string + "\"");
        }
        verbosePrinter.println("Success!" + System.getProperty("line.separator"));
        return connection2;
    }

    /*
     * WARNING - void declaration
     */
    public static String formatConnection(String string) throws ConnectionException {
        void var7_13;
        boolean bl;
        Object object;
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return string2;
        }
        String string3 = string2.toLowerCase();
        if (string3.startsWith("usb") || string3.startsWith("remote")) {
            return string;
        }
        if (!(string2.matches("(?i)^(tcp|tls|tcp_multi|tls_multi|tcp_status|tls_status).*") || string2.matches(".*\\d+\\.\\d+\\.\\d+\\.\\d+.*") || string2.contains(":") || string2.matches("\\[.*\\]"))) {
            return string2;
        }
        String[] stringArray = new String[]{"tcp_multi:", "tls_multi:", "tcp_status:", "tls_status:", "tcp:", "tls:"};
        String string4 = "";
        String string5 = string2;
        String string6 = string2.toLowerCase();
        for (String string7 : stringArray) {
            if (!string6.startsWith(string7)) continue;
            string4 = string7.toUpperCase().replace(":", "");
            string5 = string2.substring(string7.length()).trim();
            break;
        }
        String string8 = "";
        String string9 = "";
        if (string5.startsWith("[")) {
            int n = string5.indexOf(93);
            if (n == -1) {
                throw new ConnectionException("Invalid IPv6 bracketed host: missing ']'");
            }
            String string10 = string5.substring(0, n + 1);
            String string11 = string5.substring(n + 1);
            if (!string11.isEmpty()) {
                if (!string11.startsWith(":")) {
                    throw new ConnectionException("Invalid host/port separator after IPv6 bracket");
                }
                object = string11.substring(1).split(":");
                if (((String[])object).length > 2) {
                    throw new ConnectionException("Too many port components: " + string2);
                }
                if (((String[])object).length >= 1 && !object[0].isEmpty()) {
                    ConnectionBuilderInternal.validatePort(object[0]);
                    string8 = object[0];
                }
                if (((String[])object).length == 2) {
                    ConnectionBuilderInternal.validatePort(object[1]);
                    string9 = object[1];
                }
            }
        } else {
            String[] stringArray2 = string5.split(":");
            boolean bl2 = string5.contains(".");
            if (bl2) {
                if (stringArray2.length == 2 && ConnectionBuilderInternal.isNumeric(stringArray2[1])) {
                    string8 = stringArray2[1];
                    ConnectionBuilderInternal.validatePort(string8);
                    String string12 = stringArray2[0];
                } else if (stringArray2.length >= 3 && ConnectionBuilderInternal.isNumeric(stringArray2[stringArray2.length - 1]) && ConnectionBuilderInternal.isNumeric(stringArray2[stringArray2.length - 2])) {
                    string8 = stringArray2[stringArray2.length - 2];
                    string9 = stringArray2[stringArray2.length - 1];
                    ConnectionBuilderInternal.validatePort(string8);
                    ConnectionBuilderInternal.validatePort(string9);
                    String string13 = String.join((CharSequence)":", Arrays.copyOf(stringArray2, stringArray2.length - 2));
                } else {
                    String string14 = string5;
                }
            } else {
                String string15 = "[" + string5 + "]";
            }
        }
        boolean bl3 = !string8.isEmpty() && !string9.isEmpty();
        boolean bl4 = bl = string4.equalsIgnoreCase("TCP_MULTI") || string4.equalsIgnoreCase("TLS_MULTI");
        if (bl3 && !bl && !string4.isEmpty()) {
            throw new ConnectionException("Invalid multi-port format: use TCP_MULTI or TLS_MULTI");
        }
        if (string4.isEmpty() && bl3 && (string8.equals("9143") && string9.equals("9243") || string8.equals("9243") && string9.equals("9143"))) {
            string4 = "TLS_MULTI";
        }
        if (string4.isEmpty() && string9.isEmpty() && (string8.equals("9143") || string8.equals("9243"))) {
            string4 = "TLS_MULTI";
        }
        if (string8.isEmpty() && string9.isEmpty()) {
            if ("TLS_STATUS".equalsIgnoreCase(string4)) {
                string8 = "9243";
            } else if ("TCP_STATUS".equalsIgnoreCase(string4)) {
                string8 = "9200";
            } else if ("TLS".equalsIgnoreCase(string4)) {
                string8 = "9143";
            } else if ("TCP".equalsIgnoreCase(string4)) {
                string8 = "9100";
            }
        }
        object = new StringBuilder();
        if (!string4.isEmpty()) {
            ((StringBuilder)object).append(string4).append(":");
        }
        ((StringBuilder)object).append((String)var7_13);
        if (!string8.isEmpty()) {
            ((StringBuilder)object).append(":").append(string8);
            if (!string9.isEmpty()) {
                ((StringBuilder)object).append(":").append(string9);
            }
        }
        return ((StringBuilder)object).toString();
    }

    private static boolean isNumeric(String string) {
        return string != null && string.matches("\\d+");
    }

    private static void validatePort(String string) throws ConnectionException {
        int n = Integer.parseInt(string);
        if (n < 1 || n > 65535) {
            throw new ConnectionException("Invalid port number: " + string);
        }
    }

    private static Connection reflectivelyInstatiateConnection(ConnectionInfo connectionInfo, Class<?> clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = clazz.getDeclaredConstructor(ConnectionInfo.class);
        constructor.setAccessible(true);
        return (Connection)constructor.newInstance(connectionInfo);
    }

    private static Connection determineConnectionToTry(List<Connection> list, VerbosePrinter verbosePrinter) {
        verbosePrinter.println(ConnectionBuilderInternal.createClassesToTestMessage(list));
        Connection connection = null;
        for (Connection connection2 : list) {
            try {
                verbosePrinter.print("Trying " + connection2.getClass().getSimpleName() + "... ");
                connection2.open();
                connection2.close();
                String string = connection2.getClass().getName();
                if (string.equals(MULTICHANNEL_BLUETOOTH_CONNECTION) || string.equals(BLUETOOTH_CONNECTION_INSECURE) || string.equals(BLUETOOTH_CONNECTION) || string.equals(BLUETOOTH_STATUS_CONNECTION_INSECURE) || string.equals(BLUETOOTH_STATUS_CONNECTION)) {
                    Sleeper.sleep(3000L);
                }
                connection = connection2;
                break;
            }
            catch (ConnectionException connectionException) {
                verbosePrinter.println("Failed - " + connectionException.getLocalizedMessage());
            }
        }
        return connection;
    }

    private static String createClassesToTestMessage(List<Connection> list) {
        String string = "The following are possible connection types:" + System.getProperty("line.separator");
        for (Connection connection : list) {
            String string2 = connection.getClass().getSimpleName();
            string = string + "   " + string2 + System.getProperty("line.separator");
        }
        return string;
    }

    private static void reflectivelyLoadImplementingClasses() {
        try {
            Class<?> clazz = Class.forName("com.zebra.sdk.comm.ConnectionBuilder");
            Method method = clazz.getDeclaredMethod("initializeClasses", new Class[0]);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addConnectionType(Class<? extends Connection> clazz) {
        if (implementingClasses == null) {
            implementingClasses = new LinkedHashSet();
        }
        implementingClasses.add(clazz);
    }

    public static void removeConnectionType(Class<? extends Connection> clazz) {
        implementingClasses.remove(clazz);
    }

    static {
        try {
            ConnectionBuilderInternal.reflectivelyLoadImplementingClasses();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

