/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.util.internal.Sleeper;
import java.util.concurrent.TimeoutException;

public abstract class ConnectionReestablisherBase
implements ConnectionReestablisher {
    protected Connection zebraPrinterConnection;
    protected long thresholdTime;
    protected long startTime;

    protected ConnectionReestablisherBase(Connection connection, long l) {
        this.zebraPrinterConnection = connection;
        this.thresholdTime = l;
    }

    protected String waitForPrinterToComeOnlineViaSgdAndGetFwVer(Connection connection) throws TimeoutException {
        this.startTime = System.currentTimeMillis();
        while (true) {
            try {
                connection.open();
                String string = SGD.GET("appl.name", connection);
                if (string == null || string.trim().isEmpty()) {
                    throw new ConnectionException("Printer is not responding");
                }
                return string;
            }
            catch (ConnectionException connectionException) {
                try {
                    connection.close();
                }
                catch (ConnectionException connectionException2) {
                    // empty catch block
                }
                Sleeper.sleep(2500L);
                this.timeoutCheck();
                continue;
            }
            break;
        }
    }

    protected void timeoutCheck() throws TimeoutException {
        if (System.currentTimeMillis() > this.startTime + this.thresholdTime) {
            throw new TimeoutException("Task timed out waiting for '" + this.zebraPrinterConnection + "' to come back online");
        }
    }
}

