/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm.internal;

import com.zebra.sdk.comm.TlsConfig;
import com.zebra.sdk.comm.internal.ZebraSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ZebraNetworkSocketTLS
implements ZebraSocket {
    private SSLSocket socket;
    private InetSocketAddress inetSocketAddress;
    private final int MAX_TIMEOUT = 15000;
    private final TlsConfig tlsConfig;

    public ZebraNetworkSocketTLS(String string, int n) throws UnknownHostException {
        this(string, n, TlsConfig.trustAll());
    }

    public ZebraNetworkSocketTLS(String string, int n, TlsConfig tlsConfig) throws UnknownHostException {
        this.inetSocketAddress = new InetSocketAddress(InetAddress.getByName(string), n);
        this.tlsConfig = tlsConfig != null ? tlsConfig : TlsConfig.trustAll();
    }

    @Override
    public void connect() throws IOException {
        try {
            SSLSocketFactory sSLSocketFactory = this.buildFactoryFromConfig(this.tlsConfig);
            this.socket = (SSLSocket)sSLSocketFactory.createSocket();
            try {
                this.socket.setEnabledProtocols(new String[]{"TLSv1.3", "TLSv1.2"});
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket.connect(this.inetSocketAddress, 15000);
            this.socket.setSoTimeout(15000);
            this.socket.startHandshake();
            this.socket.setSoTimeout(0);
        }
        catch (Exception exception) {
            throw new IOException("TLS connection failed: " + exception.getMessage(), exception);
        }
    }

    private SSLSocketFactory buildFactoryFromConfig(TlsConfig tlsConfig) throws Exception {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        switch (tlsConfig.mode) {
            case TRUST_ALL: {
                sSLContext.init(null, new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }}, new SecureRandom());
                break;
            }
            case VALIDATE_WITH_CERT_FILE: {
                if (tlsConfig.caCertificateStream == null) {
                    throw new IllegalArgumentException("Certificate stream required.");
                }
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(tlsConfig.caCertificateStream);
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                keyStore.setCertificateEntry("ca", x509Certificate);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                sSLContext.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
                break;
            }
            case VALIDATE_WITH_TRUST_MANAGER: {
                if (tlsConfig.trustManagers == null || tlsConfig.trustManagers.length == 0) {
                    throw new IllegalArgumentException("TrustManagers required.");
                }
                sSLContext.init(null, tlsConfig.trustManagers, new SecureRandom());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown TLS mode: " + (Object)((Object)tlsConfig.mode));
            }
        }
        return sSLContext.getSocketFactory();
    }

    @Override
    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.socket == null) {
            throw new IOException("Socket not connected");
        }
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.socket == null) {
            throw new IOException("Socket not connected");
        }
        return this.socket.getOutputStream();
    }

    @Override
    public void setReadTimeout(int n) throws IOException {
        if (this.socket == null) {
            throw new IOException("Socket not connected");
        }
        this.socket.setSoTimeout(n);
    }
}

