/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.OptionGroup;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.util.internal.Range;
import com.zebra.sdk.util.internal.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class Command {
    protected Set<Option> options = new LinkedHashSet<Option>();
    protected List<OptionGroup> groups = new ArrayList<OptionGroup>();
    protected boolean isVerbose = false;

    public abstract String getCommandName();

    public abstract String getDescription();

    public String getDescriptionSupplement() {
        return "";
    }

    public abstract void run(ParsedArguments var1) throws Exception;

    protected abstract Range getExpectedArgRange();

    public void addOption(Option option) {
        this.options.add(option);
    }

    protected void addOptions(Option ... optionArray) {
        for (Option option : optionArray) {
            this.options.add(option);
        }
    }

    public void setVerbose(boolean bl) {
        this.isVerbose = bl;
    }

    protected boolean isArgLengthValid(int n) {
        return this.getExpectedArgRange().containsInt(n);
    }

    protected void verbosePrint(String string) {
        if (this.isVerbose) {
            System.out.println(string);
        }
    }

    protected void verboseFormatPrint(String string, Object ... objectArray) {
        if (this.isVerbose) {
            System.out.format(string, objectArray);
        }
    }

    public String getDefaultHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    protected String getDefaultHelpWithCustomUsage(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(String.format("%n%n%s%n%n", this.getDescription()));
        stringBuilder.append("Options include:\n");
        this.getFormattedOptionsHelp(stringBuilder);
        stringBuilder.append("\n use --help option to display this message\n");
        return stringBuilder.toString();
    }

    protected void getFormattedOptionsHelp(StringBuilder stringBuilder) {
        CharSequence charSequence;
        int n = 0;
        HashMap<Option, StringBuilder> hashMap = new HashMap<Option, StringBuilder>();
        for (Option iterator : this.options) {
            StringBuilder stringBuilder2 = new StringBuilder();
            charSequence = iterator.getLongName();
            String string = iterator.getName();
            if (charSequence == null) {
                stringBuilder2.append(String.format("-%s", string));
            } else if (string == null) {
                stringBuilder2.append(String.format("--%s", charSequence));
            } else {
                stringBuilder2.append(String.format("-%s/--%s", string, charSequence));
            }
            if (n < stringBuilder2.length()) {
                n = stringBuilder2.length();
            }
            hashMap.put(iterator, stringBuilder2);
        }
        int n2 = 0;
        for (Option option : this.options) {
            charSequence = (StringBuilder)hashMap.get(option);
            int n3 = n - ((StringBuilder)charSequence).length();
            ((StringBuilder)charSequence).append(StringUtilities.repeat(" ", n3));
            if (option.getArgName() != null) {
                ((StringBuilder)charSequence).append(String.format(" <%s>", option.getArgName()));
            }
            if (n2 >= ((StringBuilder)charSequence).length()) continue;
            n2 = ((StringBuilder)charSequence).length();
        }
        for (Option option : this.options) {
            charSequence = (StringBuilder)hashMap.get(option);
            int n4 = n2 - ((StringBuilder)charSequence).length();
            ((StringBuilder)charSequence).append(StringUtilities.repeat(" ", n4));
            ((StringBuilder)charSequence).append(String.format(" - %s\n", this.blockWrite(option.getDescription(), 80 - (n2 + 3), true)));
            stringBuilder.append(charSequence);
        }
    }

    public abstract String getHelpMessage();

    public void printHelpMessage() {
        System.out.println(this.getHelpMessage());
    }

    public void printHelpMessage(Exception exception) {
        System.out.println(exception.getMessage());
        System.out.println(this.getHelpMessage());
    }

    public void validateOptions(ParsedArguments parsedArguments) throws IllegalArgumentException {
        for (Option object : this.options) {
            String string;
            if (!parsedArguments.containsOption(object) || object.hasArg() || (string = parsedArguments.getOptionArgument(object)) == null) continue;
            parsedArguments.addArg(string);
        }
        int n = parsedArguments.getArgSize();
        if (!this.isArgLengthValid(n)) {
            throw new IllegalArgumentException("Invalid argument length.");
        }
        for (Option option : this.options) {
            if (!parsedArguments.containsOption(option) || !option.argRequired() || parsedArguments.getOptionArgument(option) != null) continue;
            throw new IllegalArgumentException(String.format("Argument for %s must be supplied", option.getLongName() != null ? option.getLongName() : option.getName()));
        }
        for (OptionGroup optionGroup : this.groups) {
            if (optionGroup.isValid(parsedArguments)) continue;
            throw new IllegalArgumentException(optionGroup.getErrorMessage());
        }
    }

    public abstract String getExamples();

    protected String getConnectionFromArgs(ParsedArguments parsedArguments, String string) throws Exception {
        String string2 = "";
        if (parsedArguments.containsOption(ZebraCommandConstants.DRIVER_OPTION)) {
            string2 = "USB:" + string;
            this.verboseFormatPrint("Connecting via ZDesigner Driver to %s%n", string);
        } else if (parsedArguments.containsOption(ZebraCommandConstants.TCP_OPTION)) {
            string2 = "TCP:" + string;
            this.verboseFormatPrint("Connecting via TCP to %s%n", string);
        } else if (parsedArguments.containsOption(ZebraCommandConstants.TLS_OPTION)) {
            string2 = "TLS:" + string;
            this.verboseFormatPrint("Connecting via TLS to %s%n", string);
        } else {
            string2 = string;
            this.verboseFormatPrint("Connecting to %s%n", string2);
        }
        return string2;
    }

    public String blockWrite(String string, int n, boolean bl) {
        String[] stringArray;
        String string2 = "";
        if (bl) {
            stringArray = new StringBuffer();
            for (int i = 0; i < 80 - n; ++i) {
                stringArray.append(" ");
            }
            string2 = stringArray.toString();
        }
        stringArray = string.split("\n");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            stringBuilder.append(this.wrapStringWithoutNewlines(string3, n, string2).trim() + "\n" + string2);
        }
        return stringBuilder.toString().replaceAll("\\n\\s*$", "");
    }

    private String wrapStringWithoutNewlines(String string, int n, String string2) {
        if (string == null) {
            return null;
        }
        String string3 = "\n" + string2;
        if (n < 1) {
            n = 1;
        }
        int n2 = string.length();
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder(n2 + 32);
        while (n2 - n3 > n) {
            if (string.charAt(n3) == ' ') {
                ++n3;
                continue;
            }
            int n4 = string.lastIndexOf(32, n + n3);
            if (n4 >= n3) {
                stringBuilder.append(string.substring(n3, n4));
                stringBuilder.append(string3);
                n3 = n4 + 1;
                continue;
            }
            n4 = string.indexOf(32, n + n3);
            if (n4 >= 0) {
                stringBuilder.append(string.substring(n3, n4));
                stringBuilder.append(string3);
                n3 = n4 + 1;
                continue;
            }
            stringBuilder.append(string.substring(n3));
            n3 = n2;
        }
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }
}

