/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.certificate.CertificateParser;
import com.zebra.sdk.certificate.ZebraCertificateInfo;
import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionBuilder;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.printer.ZebraPrinterFactory;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.printer.operations.internal.FileStorer;
import com.zebra.sdk.settings.SettingsException;
import com.zebra.sdk.util.internal.FileWrapper;
import com.zebra.sdk.util.internal.PrinterFileDescriptor;
import com.zebra.sdk.util.internal.PrinterFileMetadata;
import com.zebra.sdk.util.internal.Range;
import java.io.ByteArrayInputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class ConvertCertificateCommand
extends Command {
    private static final Option INPUT_FILE_OPTION = new Option("c", "certificate", "Certificate file to send to printer").addArg("filePath", true);
    private static final Option PRINTER_OPTION = new Option("p", "printer", "Printer to send the certificate(s)").addArg("printerName", true);
    private static final Option OUTPUT_FILE_OPTION = new Option("f", "file", "Output file to write the converted certificate(s)").addArg("outputFile", true);
    private static final Option PASSWORD_OPTION = new Option("k", "password", "Password for certificate file (if applicable)").addArg("password", true);
    private static final Option ALIAS_OPTION = new Option("a", "alias", "Certificate alias to select (if applicable)").addArg("alias", false);
    private String alias;

    public ConvertCertificateCommand() {
        this.options.add(INPUT_FILE_OPTION);
        this.options.add(PRINTER_OPTION);
        this.options.add(OUTPUT_FILE_OPTION);
        this.options.add(PASSWORD_OPTION);
        this.options.add(ALIAS_OPTION);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.options.add(ZebraCommandConstants.TLS_OPTION);
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "certificate";
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Sends a certificate file directly to a Zebra printer.  ");
        return stringBuilder.toString();
    }

    private String getConnectionString(ParsedArguments parsedArguments) {
        try {
            String string = parsedArguments.getOptionArgument(PRINTER_OPTION);
            return this.getConnectionFromArgs(parsedArguments, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String promptForPassword(String string, ParsedArguments parsedArguments) throws IOException {
        char[] cArray;
        if (parsedArguments.containsOption(PASSWORD_OPTION)) {
            cArray = parsedArguments.getOptionArgument(PASSWORD_OPTION).toCharArray();
        } else {
            Console console = System.console();
            if (console == null) {
                System.out.println("Couldn't prompt the user for password.  No console is associated with the JVM.");
                throw new IOException("Couldn't prompt the user for password.  No console is associated with the JVM.");
            }
            cArray = console.readPassword(string, new Object[0]);
        }
        return new String(cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        File file = new File(parsedArguments.getOptionArgument(INPUT_FILE_OPTION)).getAbsoluteFile();
        if (!file.exists()) {
            throw new IllegalArgumentException("The provided certificate file (" + parsedArguments.getOptionArgument(INPUT_FILE_OPTION) + ") cannot be found.");
        }
        if (parsedArguments.containsOption(ALIAS_OPTION)) {
            this.alias = parsedArguments.getOptionArgument(ALIAS_OPTION);
        }
        String string = parsedArguments.getOptionArgument(PASSWORD_OPTION);
        this.verboseFormatPrint("Accessing certificate file %s%n", file.getAbsolutePath());
        FileInputStream fileInputStream = new FileInputStream(file.getAbsoluteFile());
        ZebraCertificateInfo zebraCertificateInfo = CertificateParser.parseCertificate(fileInputStream, this.alias, string);
        if (parsedArguments.containsOption(PRINTER_OPTION)) {
            try (Connection connection = ConnectionBuilder.build(this.getConnectionString(parsedArguments));){
                connection.open();
                this.sendCertificatesToPrinter(connection, zebraCertificateInfo, string);
            }
        }
        if (parsedArguments.containsOption(OUTPUT_FILE_OPTION)) {
            this.writeCertificatesToFile(zebraCertificateInfo, string, parsedArguments.getOptionArgument(OUTPUT_FILE_OPTION));
        }
    }

    private void writeCertificatesToFile(ZebraCertificateInfo zebraCertificateInfo, String string, String string2) throws IOException {
        File file = new File(string2);
        if (file.exists()) {
            throw new IllegalArgumentException("The output file (" + string2 + ") already exists.");
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            this.verbosePrint("Wrapping the individual components into Zebra-printer friendly file formats.");
            String string3 = zebraCertificateInfo.clientCertificate;
            String string4 = zebraCertificateInfo.getCaChain();
            String string5 = zebraCertificateInfo.privateKey;
            if (string3 == null && string5 == null && string4 == null) {
                throw new ZebraIllegalArgumentException("No certificate files found.");
            }
            if (string3 != null) {
                this.verbosePrint("Extracting client certificate to file");
                ((OutputStream)fileOutputStream).write(FileWrapper.createCisdfHeader(new PrinterFileDescriptor(new ByteArrayInputStream(string3.getBytes()), "E:CERTCLN.NRD", new PrinterFileMetadata(new ByteArrayInputStream(string3.getBytes())))).getBytes());
                ((OutputStream)fileOutputStream).write(string3.getBytes());
                ((OutputStream)fileOutputStream).write("\r\n".getBytes());
            }
            if (string4 != null) {
                this.verbosePrint("Extracting certificate authority chain to file");
                ((OutputStream)fileOutputStream).write(FileWrapper.createCisdfHeader(new PrinterFileDescriptor(new ByteArrayInputStream(string4.getBytes()), "E:CACERTSV.NRD", new PrinterFileMetadata(new ByteArrayInputStream(string4.getBytes())))).getBytes());
                ((OutputStream)fileOutputStream).write(string4.getBytes());
                ((OutputStream)fileOutputStream).write("\r\n".getBytes());
            }
            if (string5 != null) {
                this.verbosePrint("Extracting private key to file");
                ((OutputStream)fileOutputStream).write(FileWrapper.createCisdfHeader(new PrinterFileDescriptor(new ByteArrayInputStream(string5.getBytes()), "E:PRIVKEY.NRD", new PrinterFileMetadata(new ByteArrayInputStream(string5.getBytes())))).getBytes());
                ((OutputStream)fileOutputStream).write(string5.getBytes());
                ((OutputStream)fileOutputStream).write("\r\n".getBytes());
                if (string != null) {
                    String string6 = "! U1 setvar \"wlan.private_key_password\" \"" + string + "\"" + "\r\n";
                    ((OutputStream)fileOutputStream).write(string6.getBytes());
                    System.out.println("WARNING: The output file (" + file.getAbsolutePath() + ") will contain the plaintext password for the encrypted private key.");
                }
            }
        }
    }

    private void sendCertificatesToPrinter(Connection connection, ZebraCertificateInfo zebraCertificateInfo, String string) throws IOException, ConnectionException, SettingsException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = ZebraPrinterFactory.getLinkOsPrinter(connection);
        ArrayList<PrinterFileDescriptor> arrayList = new ArrayList<PrinterFileDescriptor>();
        FileStorer fileStorer = new FileStorer(arrayList, connection, zebraPrinterLinkOs.getPrinterControlLanguage(), zebraPrinterLinkOs.getLinkOsInformation());
        try {
            this.verbosePrint("Wrapping the individual components into Zebra-printer friendly file formats.");
            String string2 = zebraCertificateInfo.clientCertificate;
            String string3 = zebraCertificateInfo.getCaChain();
            String string4 = zebraCertificateInfo.privateKey;
            if (string2 == null && string4 == null && string3 == null) {
                throw new ZebraIllegalArgumentException("No certificate files found.");
            }
            if (string2 != null) {
                this.verbosePrint("Extracting client certificate");
                arrayList.add(new PrinterFileDescriptor(new ByteArrayInputStream(string2.getBytes()), "E:CERTCLN.NRD", new PrinterFileMetadata(new ByteArrayInputStream(string2.getBytes()))));
            }
            if (string4 != null) {
                this.verbosePrint("Extracting private key");
                arrayList.add(new PrinterFileDescriptor(new ByteArrayInputStream(string4.getBytes()), "E:PRIVKEY.NRD", new PrinterFileMetadata(new ByteArrayInputStream(string4.getBytes()))));
            }
            if (string3 != null) {
                this.verbosePrint("Extracting certificate authority chain");
                arrayList.add(new PrinterFileDescriptor(new ByteArrayInputStream(string3.getBytes()), "E:CACERTSV.NRD", new PrinterFileMetadata(new ByteArrayInputStream(string3.getBytes()))));
            }
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            throw new IllegalArgumentException("Failed to extract contents from the certificate file.  Make sure the provided certificate file, alias, and password are valid." + (throwable != null ? "  Cause: " + throwable.getLocalizedMessage() : ""), exception);
        }
        this.verbosePrint("Sending certificate files to printer");
        fileStorer.execute();
        if (string != null) {
            this.verbosePrint("Setting private key password on printer");
            SGD.SET("wlan.private_key_password", string, connection);
        }
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.ZERO_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s -%s <filePath> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName(), INPUT_FILE_OPTION.getName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Send p12 file to printer at IP address 1.2.3.4 with password \"mypassword\"\n");
        stringBuilder.append(String.format("\t%s %s -%s /path/to/example.p12 -%s %s -%s mypassword%n", "java -jar ZSDK_API.jar", this.getCommandName(), INPUT_FILE_OPTION.getName(), PRINTER_OPTION.getName(), "1.2.3.4", PASSWORD_OPTION.getName()));
        stringBuilder.append("Send pfx file to a printer via ZDesigner Driver with password \"mypassword\"\n");
        stringBuilder.append(String.format("\t%s %s -%s /path/to/example.pfx -%s \"ZDesigner QLn420\" --%s -%s mypassword%n", "java -jar ZSDK_API.jar", this.getCommandName(), INPUT_FILE_OPTION.getName(), PRINTER_OPTION.getName(), ZebraCommandConstants.DRIVER_OPTION.getLongName(), PASSWORD_OPTION.getName()));
        stringBuilder.append("Convert a .p7b file to a printer downloadable file (/path/to/outputfile.zpl)\n");
        stringBuilder.append(String.format("\t%s %s -%s /path/to/example.p7b -%s %s%n", "java -jar ZSDK_API.jar", this.getCommandName(), INPUT_FILE_OPTION.getName(), OUTPUT_FILE_OPTION.getName(), "/path/to/outputfile.zpl"));
        stringBuilder.append("Send a .cer file to a printer at IP address 1.2.3.4, and save the output to /path/to/outputfile.zpl\n");
        stringBuilder.append(String.format("\t%s %s -%s /path/to/example.cer -%s %s --%s %s%n", "java -jar ZSDK_API.jar", this.getCommandName(), INPUT_FILE_OPTION.getName(), PRINTER_OPTION.getName(), "1.2.3.4", OUTPUT_FILE_OPTION.getLongName(), "/path/to/outputfile.zpl"));
        stringBuilder.append("Send a .cer file to a printer at IP address 1.2.3.4 using TLS via port 9143, and save the output to /path/to/outputfile.zpl\n");
        stringBuilder.append(String.format("\t%s %s -%s /path/to/example.cer -%s %s:9143 --%s %s%n", "java -jar ZSDK_API.jar", this.getCommandName(), INPUT_FILE_OPTION.getName(), PRINTER_OPTION.getName(), "1.2.3.4", OUTPUT_FILE_OPTION.getLongName(), "/path/to/outputfile.zpl"));
        stringBuilder.append("Convert a .key file to a printer downloadable file (/path/to/privateKey.zpl)\n");
        stringBuilder.append(String.format("\t%s %s -%s /path/to/example.key -%s %s%n", "java -jar ZSDK_API.jar", this.getCommandName(), INPUT_FILE_OPTION.getName(), OUTPUT_FILE_OPTION.getName(), "/path/to/privateKey.zpl"));
        stringBuilder.append("Send pfx file to a printer via Driverless USB with password \"mypassword\"\n");
        stringBuilder.append(String.format("\t%s %s -%s /path/to/example.pfx -%s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" -%s mypassword%n", "java -jar ZSDK_API.jar", this.getCommandName(), INPUT_FILE_OPTION.getName(), PRINTER_OPTION.getName(), PASSWORD_OPTION.getName()));
        return stringBuilder.toString();
    }
}

