/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.comm.DriverPrinterConnection;
import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.OptionGroup;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.graphics.ZebraImageFactory;
import com.zebra.sdk.graphics.ZebraImageI;
import com.zebra.sdk.printer.PrinterUtil;
import com.zebra.sdk.printer.internal.PrinterConnectionOutputStream;
import com.zebra.sdk.util.internal.Range;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class ConvertGraphicCommand
extends Command {
    private static final Option HEIGHT_OPTION = new Option("y", "height", "Image height in pixels").addArg("height", true);
    private static final Option WIDTH_OPTION = new Option("x", "width", "Image width in pixels").addArg("width", true);
    private static final Option REMOTE_NAME_OPTION = new Option("n", "name", "Name to save on the printer, if not given, will default to E:IMG.GRF").addArg("fileName", true);
    private static final Option SAVE_OPTION = new Option("s", "save", "Save to a local file").addArg("filePath", true);
    private static final Option PRINTER_OPTION = new Option("p", "printer", "Printer to send the graphic to.").addArg("destination", true);
    private static final int GRAPHIC_FILE_INDEX = 0;
    private static final String DEFAULT_REMOTE_FILE = "E:IMG.GRF";

    public ConvertGraphicCommand() {
        this.options.add(HEIGHT_OPTION);
        this.options.add(WIDTH_OPTION);
        this.options.add(REMOTE_NAME_OPTION);
        this.options.add(SAVE_OPTION);
        this.options.add(PRINTER_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.options.add(ZebraCommandConstants.TLS_OPTION);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.groups.add(new OptionGroup().createGroup(SAVE_OPTION, PRINTER_OPTION));
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "graphic";
    }

    @Override
    public String getDescription() {
        return "Converts a graphic for storage on a printer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        block9: {
            if (parsedArguments.containsOption(HEIGHT_OPTION) ^ parsedArguments.containsOption(WIDTH_OPTION)) {
                throw new IllegalArgumentException("Must specify both width and height or neither.");
            }
            String string = this.getRemoteFilePath(parsedArguments);
            OutputStream outputStream = this.getOutputStream(parsedArguments);
            try {
                String string2;
                if (outputStream instanceof PrinterConnectionOutputStream) {
                    ((PrinterConnectionOutputStream)outputStream).openPrinterConnection();
                }
                if (new File(string2 = parsedArguments.getArg(0)).exists()) {
                    int n;
                    this.verboseFormatPrint("Reading image file %s%n", string2);
                    ZebraImageI zebraImageI = ZebraImageFactory.getImage(string2);
                    int n2 = parsedArguments.containsOption(HEIGHT_OPTION) ? Integer.parseInt(parsedArguments.getOptionArgument(HEIGHT_OPTION)) : 0;
                    int n3 = n = parsedArguments.containsOption(WIDTH_OPTION) ? Integer.parseInt(parsedArguments.getOptionArgument(WIDTH_OPTION)) : 0;
                    if (n2 == 0 || n == 0) {
                        this.verbosePrint("Keeping current image dimensions");
                    } else {
                        this.verboseFormatPrint("Resizing image to height : %d, width %d\n", n2, n);
                    }
                    this.verbosePrint("Converting Graphic");
                    PrinterUtil.convertGraphic(string, zebraImageI, n, n2, outputStream);
                    break block9;
                }
                throw new IllegalArgumentException("Image file " + string2 + " not found ");
            }
            finally {
                if (outputStream instanceof PrinterConnectionOutputStream) {
                    ((PrinterConnectionOutputStream)outputStream).closePrinterConnection();
                }
            }
        }
    }

    private OutputStream getOutputStream(ParsedArguments parsedArguments) throws Exception {
        this.verbosePrint("Determining output");
        if (parsedArguments.containsOption(PRINTER_OPTION)) {
            return this.createPrinterOutputStream(parsedArguments);
        }
        if (parsedArguments.containsOption(SAVE_OPTION)) {
            String string = parsedArguments.getOptionArgument(SAVE_OPTION);
            this.verboseFormatPrint("Outputting to %s%n", string);
            return new FileOutputStream(string);
        }
        this.verbosePrint("Outputting to system out");
        return System.out;
    }

    private OutputStream createPrinterOutputStream(ParsedArguments parsedArguments) throws Exception {
        String string = parsedArguments.getOptionArgument(PRINTER_OPTION);
        if (parsedArguments.containsOption(ZebraCommandConstants.DRIVER_OPTION)) {
            this.verboseFormatPrint("Creating ZDesigner Driver connection to %s%n", string);
            return new PrinterConnectionOutputStream(new DriverPrinterConnection(string));
        }
        this.verboseFormatPrint("Creating connection to %s%n", string);
        return new PrinterConnectionOutputStream(string);
    }

    private String getRemoteFilePath(ParsedArguments parsedArguments) {
        String string = parsedArguments.containsOption(REMOTE_NAME_OPTION) ? parsedArguments.getOptionArgument(REMOTE_NAME_OPTION) : DEFAULT_REMOTE_FILE;
        this.verboseFormatPrint("Remote name %s%n", string);
        return string;
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.ONE_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <graphicFile> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Convert myPic.png and output to commandline\n");
        stringBuilder.append(String.format("\t%s %s /path/to/myPic.png%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Convert myPic.jpg, rename to E:PIC.GRF, and store it to the printer\n");
        stringBuilder.append(String.format("\t%s %s /path/to/myPic.png --%s E:PIC.GRF --%s 1.2.3.4%n", "java -jar ZSDK_API.jar", this.getCommandName(), REMOTE_NAME_OPTION.getLongName(), PRINTER_OPTION.getLongName()));
        stringBuilder.append("Convert myPic.gif via port 6101, change its size, rename to myPic.png, using verbose mode\n");
        stringBuilder.append(String.format("\t%s %s /path/to/myPic.gif --%s 80 --%s 80 --%s E:PIC.GRF --%s 1.2.3.4:6101 --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), HEIGHT_OPTION.getLongName(), WIDTH_OPTION.getLongName(), REMOTE_NAME_OPTION.getLongName(), PRINTER_OPTION.getLongName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Convert myPic.gif using TLS via port 9143, change its size, rename to myPic.png, using verbose mode\n");
        stringBuilder.append(String.format("\t%s %s /path/to/myPic.gif --%s 80 --%s 80 --%s E:PIC.GRF --%s 1.2.3.4:9143 --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), HEIGHT_OPTION.getLongName(), WIDTH_OPTION.getLongName(), REMOTE_NAME_OPTION.getLongName(), PRINTER_OPTION.getLongName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Convert myPic.bmp via ZDesigner Driver connection\n");
        stringBuilder.append(String.format("\t%s %s /path/to/myPic.bmp --%s \"ZDesigner QLn320\" --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), PRINTER_OPTION.getLongName(), ZebraCommandConstants.DRIVER_OPTION.getLongName()));
        return stringBuilder.toString();
    }
}

