/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.CommandLineDiscoHandler;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.OptionGroup;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.discovery.DiscoveredPrinterDriver;
import com.zebra.sdk.printer.discovery.DiscoveredUsbPrinter;
import com.zebra.sdk.printer.discovery.NetworkDiscoverer;
import com.zebra.sdk.printer.discovery.UsbDiscoverer;
import com.zebra.sdk.printer.discovery.ZebraPrinterFilter;
import com.zebra.sdk.util.internal.Range;

public class DiscoverPrintersCommand
extends Command {
    private static final Option IPV6_MULTICAST_OPTION = new Option("i", "ipv6", "IPV6 Multicast Discovery").addArg("hops", true);
    private static final Option MULTICAST_OPTION = new Option("m", "multicast", "Multicast Discovery").addArg("hops", true);
    private static final Option LOCAL_BROADCAST_OPTION = new Option("l", "local", "Local Broadcast Discovery");
    private static final Option SUBNET_OPTION = new Option("s", "subnet", "Subnet Discovery").addArg("addr", true);
    private static final Option DIRECTED_BROADCAST_OPTION = new Option("r", "directed", "Directed Discovery").addArg("addr", true);
    private static final Option USB_OPTION = new Option("d", "driver", "ZDesigner Driver Discovery");
    private static final Option DIRECT_USB_OPTION = new Option("u", "usb", "Direct USB Discovery");
    private static final Option JSON_OPTION = new Option("j", "json", "Output JSON");
    private static final Option XML_OPTION = new Option("x", "xml", "Output XML");
    private static final Option TIMEOUT_OPTION = new Option("t", "timeout", "Discovery Timeout in ms").addArg("mills", true);
    private static final int DEFAULT_TIMEOUT = 5000;

    public DiscoverPrintersCommand() {
        this.options.add(IPV6_MULTICAST_OPTION);
        this.options.add(MULTICAST_OPTION);
        this.options.add(LOCAL_BROADCAST_OPTION);
        this.options.add(SUBNET_OPTION);
        this.options.add(DIRECTED_BROADCAST_OPTION);
        this.options.add(USB_OPTION);
        this.options.add(DIRECT_USB_OPTION);
        this.options.add(JSON_OPTION);
        this.options.add(XML_OPTION);
        this.options.add(TIMEOUT_OPTION);
        this.groups.add(new OptionGroup().createGroup(IPV6_MULTICAST_OPTION, MULTICAST_OPTION, LOCAL_BROADCAST_OPTION, SUBNET_OPTION, DIRECTED_BROADCAST_OPTION, USB_OPTION));
        this.groups.add(new OptionGroup().createGroup(JSON_OPTION, XML_OPTION, ZebraCommandConstants.VERBOSE_OPTION));
    }

    @Override
    public String getCommandName() {
        return "discover";
    }

    @Override
    public String getDescription() {
        return "Discover printers";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        CommandLineDiscoHandler commandLineDiscoHandler = new CommandLineDiscoHandler(parsedArguments.containsOption(XML_OPTION), parsedArguments.containsOption(JSON_OPTION));
        int n = 0;
        if (parsedArguments.containsOption(TIMEOUT_OPTION)) {
            n = Integer.parseInt(parsedArguments.getOptionArgument(TIMEOUT_OPTION));
            this.verboseFormatPrint("Discovery timeout set to: %d ms%n", n);
        } else {
            n = 5000;
            this.verboseFormatPrint("Setting timeout to default of %d ms%n", n);
        }
        if (parsedArguments.containsOption(IPV6_MULTICAST_OPTION)) {
            int n2 = Integer.parseInt(parsedArguments.getOptionArgument(IPV6_MULTICAST_OPTION));
            this.verboseFormatPrint("Performing IPv6 multicast with %d hops%n", n2);
            NetworkDiscoverer.ipv6Multicast(commandLineDiscoHandler, n2);
        } else if (parsedArguments.containsOption(MULTICAST_OPTION)) {
            int n3 = Integer.parseInt(parsedArguments.getOptionArgument(MULTICAST_OPTION));
            this.verboseFormatPrint("Performing multicast with %d hops%n", n3);
            NetworkDiscoverer.multicast(commandLineDiscoHandler, n3);
        } else if (parsedArguments.containsOption(LOCAL_BROADCAST_OPTION)) {
            this.verbosePrint("Performing local broadcast");
            NetworkDiscoverer.localBroadcast(commandLineDiscoHandler, n);
        } else if (parsedArguments.containsOption(SUBNET_OPTION)) {
            String string = parsedArguments.getOptionArgument(SUBNET_OPTION);
            this.verboseFormatPrint("Scanning subnet %s%n", string);
            NetworkDiscoverer.subnetSearch(commandLineDiscoHandler, string, n);
        } else if (parsedArguments.containsOption(DIRECTED_BROADCAST_OPTION)) {
            String string = parsedArguments.getOptionArgument(DIRECTED_BROADCAST_OPTION);
            this.verboseFormatPrint("Performing directed broadcast of %s%n", string);
            NetworkDiscoverer.directedBroadcast(commandLineDiscoHandler, string, n);
        } else if (parsedArguments.containsOption(USB_OPTION)) {
            this.verbosePrint("Scanning Driver USB ports");
            for (DiscoveredPrinterDriver discoveredPrinterDriver : UsbDiscoverer.getZebraDriverPrinters()) {
                commandLineDiscoHandler.foundPrinter(discoveredPrinterDriver);
            }
            commandLineDiscoHandler.discoveryFinished();
        } else if (parsedArguments.containsOption(DIRECT_USB_OPTION)) {
            this.verbosePrint("Scanning USB ports");
            for (DiscoveredUsbPrinter discoveredUsbPrinter : UsbDiscoverer.getZebraUsbPrinters(new ZebraPrinterFilter())) {
                commandLineDiscoHandler.foundPrinter(discoveredUsbPrinter);
            }
            commandLineDiscoHandler.discoveryFinished();
        } else {
            this.verbosePrint("Performing default discovery");
            NetworkDiscoverer.findPrinters(commandLineDiscoHandler);
        }
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.ZERO_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpMessage();
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Find printers using local search:\n");
        stringBuilder.append(String.format("\t%s %s --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), LOCAL_BROADCAST_OPTION.getLongName()));
        stringBuilder.append("Find all printers in a subnet:\n");
        stringBuilder.append(String.format("\t%s %s --%s 1.2.3.*%n", "java -jar ZSDK_API.jar", this.getCommandName(), SUBNET_OPTION.getLongName()));
        stringBuilder.append("Find all printers in a range:\n");
        stringBuilder.append(String.format("\t%s %s --%s 1.2.3.4-100%n", "java -jar ZSDK_API.jar", this.getCommandName(), SUBNET_OPTION.getLongName()));
        stringBuilder.append("Find all USB printers:\n");
        stringBuilder.append(String.format("\t%s %s --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), USB_OPTION.getLongName()));
        stringBuilder.append("Find printers and return in XML\n");
        stringBuilder.append(String.format("\t%s %s --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), XML_OPTION.getLongName()));
        stringBuilder.append("Find printers with 5 hops and return in JSON\n");
        stringBuilder.append(String.format("\t%s %s --%s 5 --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), MULTICAST_OPTION.getLongName(), JSON_OPTION.getLongName()));
        return stringBuilder.toString();
    }
}

