/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.PrinterUtil;
import com.zebra.sdk.util.internal.Range;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class GetObjectCommand
extends Command {
    private static final Option SAVE_OPTION = new Option("s", "save", "Save to local file").addArg("filePath", true);
    private static final Option FTP_PASSWORD = new Option("p", "password", "FTP Password (if specified will only attempt FTP retrieval)").addArg("password", true);
    private static final int CONNECTION_ARG_INDEX = 0;
    private static final int FILE_PATH_INDEX = 1;

    public GetObjectCommand() {
        this.options.add(SAVE_OPTION);
        this.options.add(FTP_PASSWORD);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.options.add(ZebraCommandConstants.TLS_OPTION);
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "get";
    }

    @Override
    public String getDescription() {
        return "Retrieves files from the printer.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        OutputStream outputStream = null;
        try {
            String string = parsedArguments.getOptionArgument(SAVE_OPTION);
            if (parsedArguments.containsOption(SAVE_OPTION)) {
                this.verboseFormatPrint("Output going to file %s%n", string);
                outputStream = new FileOutputStream(string);
            } else {
                this.verbosePrint("Output going to system out");
                outputStream = System.out;
            }
            String string2 = parsedArguments.getArg(0);
            if (parsedArguments.containsOption(FTP_PASSWORD)) {
                this.verboseFormatPrint("Preparing to fetch file %s on printer at %s via FTP%n", parsedArguments.getArg(1), string2);
                outputStream.write(PrinterUtil.getObjectFromPrinterViaFtp(this.getConnectionFromArgs(parsedArguments, string2), parsedArguments.getArg(1), parsedArguments.getOptionArgument(FTP_PASSWORD)));
            } else {
                this.verboseFormatPrint("Preparing to fetch file %s on printer at %s%n", parsedArguments.getArg(1), string2);
                outputStream.write(PrinterUtil.getObjectFromPrinter(this.getConnectionFromArgs(parsedArguments, string2), parsedArguments.getArg(1)));
            }
        }
        finally {
            if (outputStream instanceof FileOutputStream) {
                outputStream.close();
            }
        }
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.TWO_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> <fileOnPrinter> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Fetch a file on the printer and output contents to command line\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 E:FILE.ZPL%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Fetch a file on the printer and save to a local file\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 E:FILE.ZPL --%s local.zpl%n", "java -jar ZSDK_API.jar", this.getCommandName(), SAVE_OPTION.getLongName()));
        stringBuilder.append("Fetch a file on the printer via ZDesigner Driver and output contents to command line\n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" E:FILE.ZPL --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.DRIVER_OPTION.getLongName()));
        stringBuilder.append("Fetch a file on the printer via port 6101 and output contents to command line\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4:6101 E:FILE.ZPL%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Fetch a file on the printer using TLS via default port and output contents to command line\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 E:FILE.ZPL --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.TLS_OPTION.getLongName()));
        stringBuilder.append("Fetch a file on the printer using TLS via port 9143 and output contents to command line\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4:9143 E:FILE.ZPL %n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Fetch a file on the printer via FTP and output contents to command line\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 E:FILE.ZPL --%s ftpPassword%n", "java -jar ZSDK_API.jar", this.getCommandName(), FTP_PASSWORD.getLongName()));
        stringBuilder.append("Fetch a file on the printer via Driverless USB and output contents to command line\n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" E:FILE.ZPL%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        return stringBuilder.toString();
    }
}

