/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.OptionGroup;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.PrinterUtil;
import com.zebra.sdk.util.internal.JacksonObjectMapperFactory;
import com.zebra.sdk.util.internal.Range;
import com.zebra.sdk.util.internal.XmlUtil;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ListFilesCommand
extends Command {
    private static final Range ARG_RANGE = new Range(1, 2);
    private static final int CONNECTION_ARG_INDEX = 0;
    private static final int FILTER_INDEX = 1;
    private static final String DEFAULT_FILTER = "*:*.*";
    private static final Option XML_OPTION = new Option("x", "xml", "Output files as XML");
    private static final Option JSON_OPTION = new Option("j", "json", "Output files as JSON");

    public ListFilesCommand() {
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.options.add(ZebraCommandConstants.TLS_OPTION);
        this.options.add(XML_OPTION);
        this.options.add(JSON_OPTION);
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
        this.groups.add(new OptionGroup().createGroup(ZebraCommandConstants.VERBOSE_OPTION, XML_OPTION, JSON_OPTION));
    }

    @Override
    public String getCommandName() {
        return "ls";
    }

    @Override
    public String getDescription() {
        return "Lists the files on the remote printer";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        String string;
        if (parsedArguments.getArg(1) != null) {
            string = parsedArguments.getArg(1);
            this.verboseFormatPrint("Listing files matching %s%n", string);
        } else {
            this.verbosePrint("Listing all files");
            string = DEFAULT_FILTER;
        }
        String[] stringArray = PrinterUtil.listFiles(this.getConnectionFromArgs(parsedArguments, parsedArguments.getArg(0)), string);
        if (stringArray.length == 0) {
            System.out.println("No files found.");
        } else {
            this.listFiles(stringArray, parsedArguments);
        }
    }

    private void listFiles(String[] stringArray, ParsedArguments parsedArguments) throws Exception {
        if (parsedArguments.containsOption(JSON_OPTION)) {
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            hashMap.put("files", stringArray);
            System.out.println(JacksonObjectMapperFactory.getInstance().enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString(hashMap));
        } else if (parsedArguments.containsOption(XML_OPTION)) {
            this.printFilesAsXml(stringArray);
        } else {
            for (String string : stringArray) {
                System.out.println(string);
            }
        }
    }

    private void printFilesAsXml(String[] stringArray) throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element = document.createElement("PRINTER_FILES");
        for (String string : stringArray) {
            Element element2 = document.createElement("FILE");
            element2.appendChild(document.createTextNode(string));
            element.appendChild(element2);
        }
        System.out.println(XmlUtil.xmlToString(element));
    }

    @Override
    protected Range getExpectedArgRange() {
        return ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> <optionalFilter>%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("List all the files on a printer connecting to port 6101\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4:6101%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("List all the files on a printer using TLS via default port\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.TLS_OPTION.getLongName()));
        stringBuilder.append("List all the files on a printer using TLS via port 9143\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4:9143 %n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("List all zpl files on the E drive on a printer\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 E:*.ZPL%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("List all zpl files on the E drive on a printer via ZDesigner Driver\n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" E:*.ZPL --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.DRIVER_OPTION.getLongName()));
        stringBuilder.append("List all zpl files on the E drive on a printer outputing as JSON\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 E:*.ZPL --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), JSON_OPTION.getLongName()));
        stringBuilder.append("List all zpl files on the E drive on a printer via Driverless USB\n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" E:*.ZPL%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        return stringBuilder.toString();
    }
}

