/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.PrinterUtil;
import com.zebra.sdk.util.internal.Range;

public class LoadBackupCommand
extends Command {
    private static final int CONNECTION_ARG_INDEX = 0;
    private static final int BACKUP_FILE_INDEX = 1;

    public LoadBackupCommand() {
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.options.add(ZebraCommandConstants.TLS_OPTION);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "loadbackup";
    }

    @Override
    public String getDescription() {
        return "Loads backup onto printer. Will delete existing printer files.";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        String string = parsedArguments.getArg(1);
        this.verboseFormatPrint("Reading backup file %s%n", string);
        String string2 = parsedArguments.getArg(0);
        this.verboseFormatPrint("Loading backup onto printer at %s%n", string2);
        PrinterUtil.loadBackup(this.getConnectionFromArgs(parsedArguments, string2), string, this.isVerbose);
        this.verbosePrint("Finished loading backup");
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.TWO_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> <backupFile> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Load backup on printer\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 profile.zprofile%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Load backup on printer via port 6101 using verbose mode\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4:6101 profile.zprofile --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Load backup on printer using TLS network default port\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 profile.zprofile --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.TLS_OPTION.getLongName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Load backup on printer via TLS network using port 9143 using verbose mode\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4:9143 profile.zprofile --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Load backup on printer via ZDesigner Driver\n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" profile.zprofile --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.DRIVER_OPTION.getLongName()));
        stringBuilder.append("Load backup on printer via Driverless USB\n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" profile.zprofile%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        return stringBuilder.toString();
    }
}

