/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.OptionGroup;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.FileDeletionOption;
import com.zebra.sdk.printer.PrinterUtil;
import com.zebra.sdk.util.internal.Range;

public class LoadProfileCommand
extends Command {
    private static final Option DELETE_ALL_OPTION = new Option("a", "dAll", "Delete all files from printer before loading profile");
    private static final Option DELETE_CLONABLE_OPTION = new Option("c", "dClone", "Delete clonable files form the printer before loading the profile");
    private static final Option DELETE_NONE_OPTION = new Option("n", "dNone", "Delete no files");
    private static final int CONNECTION_ARG_INDEX = 0;
    private static final int PROFILE_PATH_INDEX = 1;

    public LoadProfileCommand() {
        this.options.add(DELETE_ALL_OPTION);
        this.options.add(DELETE_CLONABLE_OPTION);
        this.options.add(DELETE_NONE_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.options.add(ZebraCommandConstants.TLS_OPTION);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.groups.add(new OptionGroup().createGroup(DELETE_ALL_OPTION, DELETE_CLONABLE_OPTION, DELETE_NONE_OPTION));
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "loadprofile";
    }

    @Override
    public String getDescription() {
        return "Loads profile onto printer.";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        FileDeletionOption fileDeletionOption;
        if (parsedArguments.containsOption(DELETE_ALL_OPTION)) {
            this.verbosePrint("Loading profile, deleting all current files");
            fileDeletionOption = FileDeletionOption.ALL;
        } else if (parsedArguments.containsOption(DELETE_CLONABLE_OPTION)) {
            this.verbosePrint("Loading profile, deleting clonable files");
            fileDeletionOption = FileDeletionOption.CLONEABLE;
        } else {
            this.verbosePrint("Loading profile, keeping all current files");
            fileDeletionOption = FileDeletionOption.NONE;
        }
        String string = parsedArguments.getArg(1);
        this.verboseFormatPrint("Reading profile file %s%n", string);
        String string2 = parsedArguments.getArg(0);
        this.verboseFormatPrint("Loading profile onto printer at %s%n", string2);
        PrinterUtil.loadProfile(this.getConnectionFromArgs(parsedArguments, string2), string, fileDeletionOption, this.isVerbose);
        this.verbosePrint("Finished loading profile");
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.TWO_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> <profileFile> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Load profile onto a printer, keeping all current files\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 profile.zprofile --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), DELETE_NONE_OPTION.getLongName()));
        stringBuilder.append("Load profile onto a printer over port 9100, deleting clonable files\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 profile.zprofile --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), DELETE_CLONABLE_OPTION.getLongName()));
        stringBuilder.append("Load profile onto a printer using TLS network default port\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 profile.zprofile --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.TLS_OPTION.getLongName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Load profile ono a printer via TLS network using port 9143 using verbose mode\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4:9143 profile.zprofile --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Load profile onto a printer via ZDesigner Driver, deleting all files using verbose mode\n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" profile.zprofile --%s --%s --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), DELETE_ALL_OPTION.getLongName(), ZebraCommandConstants.DRIVER_OPTION.getLongName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Load profile onto a printer via Driverless USB, deleting all files\n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" profile.zprofile --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), DELETE_ALL_OPTION.getLongName()));
        return stringBuilder.toString();
    }
}

