/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.OptionGroup;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.CsvPrinter;
import com.zebra.sdk.printer.XmlPrinter;
import com.zebra.sdk.util.internal.Range;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PrintCommand
extends Command {
    private static final Option TEMPLATE_FILE = new Option("t", "template", "Template File").addArg("filePath", true);
    private static final Option SAVE_OPTION = new Option("s", "save", "Save output to file").addArg("filePath", true);
    private static final Option QUANTITY_OPTION = new Option("q", "quantity", "Label Quantity").addArg("num", true);
    private static final Option XML_OPTION = new Option("x", "xml", "XML print");
    private static final Option CSV_OPTION = new Option("c", "csv", "CSV print");
    private static final int CONNECTION_ARG_INDEX = 0;
    private static final int PRINT_ARG_INDEX = 1;
    private static final Range ARG_RANGE = new Range(1, 2);

    public PrintCommand() {
        this.options.add(TEMPLATE_FILE);
        this.options.add(SAVE_OPTION);
        this.options.add(QUANTITY_OPTION);
        this.options.add(XML_OPTION);
        this.options.add(CSV_OPTION);
        this.groups.add(new OptionGroup().createGroup(XML_OPTION, CSV_OPTION));
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "print";
    }

    @Override
    public String getDescription() {
        return "Print XML or CSV files";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        OutputStream outputStream;
        InputStream inputStream = this.getInputSource(parsedArguments);
        String string = this.getTemplateFile(parsedArguments);
        String string2 = parsedArguments.containsOption(QUANTITY_OPTION) ? parsedArguments.getOptionArgument(QUANTITY_OPTION) : null;
        OutputStream outputStream2 = outputStream = parsedArguments.containsOption(SAVE_OPTION) ? new FileOutputStream(parsedArguments.getOptionArgument(SAVE_OPTION)) : System.out;
        if (parsedArguments.containsOption(XML_OPTION)) {
            this.verbosePrint("Xml Print...");
            XmlPrinter.print(this.getConnectionFromArgs(parsedArguments, parsedArguments.getArg(0)), inputStream, string, string2, outputStream, this.isVerbose);
        } else if (parsedArguments.containsOption(CSV_OPTION)) {
            this.verbosePrint("Csv Print...");
            CsvPrinter.print(this.getConnectionFromArgs(parsedArguments, parsedArguments.getArg(0)), inputStream, string, string2, outputStream, this.isVerbose);
        } else {
            throw new IllegalArgumentException("Either --xml or --csv option must be specified");
        }
    }

    private String getTemplateFile(ParsedArguments parsedArguments) throws IllegalArgumentException {
        String string = null;
        if (parsedArguments.containsOption(TEMPLATE_FILE)) {
            string = parsedArguments.getOptionArgument(TEMPLATE_FILE);
        }
        return string;
    }

    private InputStream getInputSource(ParsedArguments parsedArguments) throws FileNotFoundException, IOException {
        String string = parsedArguments.getArg(1);
        if (string != null) {
            File file = new File(string);
            if (file.exists()) {
                this.verboseFormatPrint("Using file %s%n", string);
                return new FileInputStream(file);
            }
            System.out.println("Could not find file, interpreting second argument as data.");
            return new ByteArrayInputStream(string.getBytes());
        }
        if (System.in.available() == 0) {
            throw new IOException("No data to read from standard in.");
        }
        return System.in;
    }

    @Override
    protected Range getExpectedArgRange() {
        return ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> <fileToPrint> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Print an XML file using a template file\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 /path/to/my/file.xml --%s /path/to/template.zpl --%s %n", "java -jar ZSDK_API.jar", this.getCommandName(), TEMPLATE_FILE.getLongName(), XML_OPTION.getLongName()));
        stringBuilder.append("Print an XML file using a template file. Connect using TLS via default port\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 /path/to/my/file.xml --%s /path/to/template.zpl --%s --%s %n", "java -jar ZSDK_API.jar", this.getCommandName(), TEMPLATE_FILE.getLongName(), XML_OPTION.getLongName(), ZebraCommandConstants.TLS_OPTION.getLongName()));
        stringBuilder.append("Print an XML file using a template file. Connect using TLS via port 9143\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4:9143 /path/to/my/file.xml --%s /path/to/template.zpl --%s %n", "java -jar ZSDK_API.jar", this.getCommandName(), TEMPLATE_FILE.getLongName(), XML_OPTION.getLongName()));
        stringBuilder.append("Print a CSV file using a template file, and save generated output to file\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 /path/to/my/file.csv --%s /path/to/template.zpl --%s out.zpl --%s %n", "java -jar ZSDK_API.jar", this.getCommandName(), TEMPLATE_FILE.getLongName(), SAVE_OPTION.getLongName(), CSV_OPTION.getLongName()));
        stringBuilder.append("Print 10 copies of a XML file\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 /path/to/file.xml --%s template.zpl --%s 10 --%s %n", "java -jar ZSDK_API.jar", this.getCommandName(), TEMPLATE_FILE.getLongName(), QUANTITY_OPTION.getLongName(), XML_OPTION.getLongName()));
        stringBuilder.append("Print data using a sample template file [^XA^DFR:template.zpl^FO100,100^A0N,50,50^FN1^FS^FO100,200^A0N,50,50^FN2^FS^XZ]\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 \"hello,world\" --%s template.zpl --%s %n", "java -jar ZSDK_API.jar", this.getCommandName(), TEMPLATE_FILE.getLongName(), CSV_OPTION.getLongName()));
        stringBuilder.append("Print 2 copies of the data via ZDesigner Driver with verbose output\n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" \"hello,world\" --%s template.zpl --%s 2 --%s --%s --%s %n", "java -jar ZSDK_API.jar", this.getCommandName(), TEMPLATE_FILE.getLongName(), QUANTITY_OPTION.getLongName(), ZebraCommandConstants.DRIVER_OPTION.getLongName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName(), CSV_OPTION.getLongName()));
        stringBuilder.append("Print 2 copies of the data via Driverless USB with verbose output\n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" \"hello,world\" --%s template.zpl --%s 2 --%s --%s %n", "java -jar ZSDK_API.jar", this.getCommandName(), TEMPLATE_FILE.getLongName(), QUANTITY_OPTION.getLongName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName(), CSV_OPTION.getLongName()));
        return stringBuilder.toString();
    }
}

