/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionBuilder;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.ZebraPrinterFactory;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.printer.operations.internal.SendJsonOperation;
import com.zebra.sdk.util.internal.Range;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class SendJSONCommand
extends Command {
    private static final Option ENCODING_OPTION = new Option("e", "encoding", "Sets the transfer encoding, defaults to UTF8. Accepts all types supported by java.io API").addArg("type", true);
    private static final String DEFAULT_ENCODING = "UTF8";
    private static final int CONNECTION_ARG_INDEX = 0;
    private static final int DATA_ARG_INDEX = 1;

    public SendJSONCommand() {
        this.options.add(ENCODING_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.options.add(ZebraCommandConstants.TLS_OPTION);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.options.add(ZebraCommandConstants.SILENT_OPTION);
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "sendJSON";
    }

    @Override
    public String getDescription() {
        return "Sends JSON data to the printer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        String string = parsedArguments.getArg(1);
        String string2 = parsedArguments.getArg(0);
        if (parsedArguments.getArgSize() == 0) {
            throw new IllegalArgumentException("No arguments specified.");
        }
        if (string2 != null) {
            try (Connection connection = ConnectionBuilder.build(this.getConnectionFromArgs(parsedArguments, string2));){
                connection.open();
                ZebraPrinterLinkOs zebraPrinterLinkOs = ZebraPrinterFactory.getLinkOsPrinter(connection);
                if (string != null) {
                    File file = new File(string);
                    if (file.exists()) {
                        this.verboseFormatPrint("Sending JSON data from file %s%n", string);
                        String string3 = FileUtils.readFileToString((File)file, (String)this.getEncoding(parsedArguments));
                        SendJsonOperation sendJsonOperation = new SendJsonOperation(zebraPrinterLinkOs.getConnection(), zebraPrinterLinkOs.getPrinterControlLanguage(), string3);
                        this.executeAndCheckResponse(parsedArguments, sendJsonOperation);
                    }
                    this.verbosePrint("Sending JSON data");
                    SendJsonOperation sendJsonOperation = new SendJsonOperation(zebraPrinterLinkOs.getConnection(), zebraPrinterLinkOs.getPrinterControlLanguage(), string);
                    this.executeAndCheckResponse(parsedArguments, sendJsonOperation);
                }
                this.verbosePrint("Reading from system in");
                byte[] byArray = new byte[System.in.available()];
                IOUtils.read((InputStream)System.in, (byte[])byArray);
                SendJsonOperation sendJsonOperation = new SendJsonOperation(zebraPrinterLinkOs.getConnection(), zebraPrinterLinkOs.getPrinterControlLanguage(), new String(byArray, this.getEncoding(parsedArguments)));
                this.executeAndCheckResponse(parsedArguments, sendJsonOperation);
            }
        } else {
            throw new ConnectionException("Invalid connection");
        }
    }

    private void executeAndCheckResponse(ParsedArguments parsedArguments, SendJsonOperation sendJsonOperation) throws ConnectionException {
        String string = sendJsonOperation.execute();
        if (!parsedArguments.containsOption(ZebraCommandConstants.SILENT_OPTION)) {
            System.out.println(string);
        }
    }

    private String getEncoding(ParsedArguments parsedArguments) {
        return parsedArguments.containsOption(ENCODING_OPTION) ? parsedArguments.getOptionArgument(ENCODING_OPTION) : DEFAULT_ENCODING;
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.TWO_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> <data/file> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Set a setting on the printer\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 {}{\\\"ip.port\\\":\\\"9100\\\"}%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Retrieve a setting from the printer\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 {}{\\\"ip.port\\\":null}%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Set/Retrieve a setting to a printer from a file and suppress response.\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 /path/to/my/file.txt -%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.SILENT_OPTION.getName()));
        stringBuilder.append("Set/Retrieve a setting to a printer via ZDesigner Driver.\n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" /path/to/my/file.txt --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.DRIVER_OPTION.getLongName()));
        stringBuilder.append("Set/Retrieve a setting to a printer via TCP default port 9100 using verbose mode\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 /path/to/my/file.txt --%s --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.TCP_OPTION.getLongName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Set/Retrieve a setting to a printer using TLS via default port in verbose mode\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 /path/to/my/file.txt --%s --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.TLS_OPTION.getLongName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Set/Retrieve a setting to a printer using TLS via port 9143 in verbose mode\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4:9143 /path/to/my/file.txt --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Set/Retrieve a setting to a printer via Driverless USB\n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" /path/to/my/file.txt%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        return stringBuilder.toString();
    }
}

