/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.PrinterUtil;
import com.zebra.sdk.util.internal.Range;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SetClockCommand
extends Command {
    private static final Option SET_OPTION = new Option("t", "time", "Time to set the clock to. Format \"MM-dd-yyyy HH:mm:ss\"|\"MM-dd-yyyy\"|\"HH:mm:ss\"").addArg("time", false);
    private static final int CONNECTION_ARG_INDEX = 0;

    public SetClockCommand() {
        this.options.add(SET_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.options.add(ZebraCommandConstants.TLS_OPTION);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "clock";
    }

    @Override
    public String getDescription() {
        return "Set the Real-Time Clock.";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        String string;
        String string2 = parsedArguments.getOptionArgument(SET_OPTION);
        if (string2 == null) {
            string = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss").format(new Date());
            this.verbosePrint("Using local system time " + string + " since none specified by user.");
        } else {
            string = string2;
        }
        PrinterUtil.setClock(this.getConnectionFromArgs(parsedArguments, parsedArguments.getArg(0)), string);
        this.verboseFormatPrint("Set time to %s%n", string);
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.ONE_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Set the printer's clock to the local time\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Set the printer's clock to the local time using TLS via default port\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.TLS_OPTION.getLongName()));
        stringBuilder.append("Set the printer's clock to the local time using TLS via port 9143 in verbose mode\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4:9143 --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Set the printer's clock\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 --%s \"03-01-1990 12:12:12\"%n", "java -jar ZSDK_API.jar", this.getCommandName(), SET_OPTION.getLongName()));
        stringBuilder.append("Set only printer's date\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 --%s \"03-01-1990\"%n", "java -jar ZSDK_API.jar", this.getCommandName(), SET_OPTION.getLongName()));
        stringBuilder.append("Set the printer's time\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 --%s \"12:12:12\"%n", "java -jar ZSDK_API.jar", this.getCommandName(), SET_OPTION.getLongName()));
        stringBuilder.append("Set the printer's time via ZDesigner Driver using verbose mode\n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" --%s \"12:12:12\" --%s --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), SET_OPTION.getLongName(), ZebraCommandConstants.DRIVER_OPTION.getLongName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Set the printer's time via Driverless USB\n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" --%s \"12:12:12\"%n", "java -jar ZSDK_API.jar", this.getCommandName(), SET_OPTION.getLongName()));
        return stringBuilder.toString();
    }
}

