/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.OptionGroup;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.PrinterUtil;
import com.zebra.sdk.printer.TcpPortStatus;
import com.zebra.sdk.util.internal.Range;

public class StatusCommand
extends Command {
    private static final Option PORT_OPTION = new Option("r", "portstatus", "Port Status");
    private static final Option PRINTER_OPTION = new Option("p", "printer", "Printer Status");
    private static final Option ODOMETER_OPTION = new Option("o", "odometer", "Odometer status");
    private static final int CONNECTION_ARG_INDEX = 0;

    public StatusCommand() {
        this.options.add(PRINTER_OPTION);
        this.options.add(PORT_OPTION);
        this.options.add(ODOMETER_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.options.add(ZebraCommandConstants.TLS_OPTION);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.groups.add(new OptionGroup().createGroup(PORT_OPTION, PRINTER_OPTION, ODOMETER_OPTION));
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "status";
    }

    @Override
    public String getDescription() {
        return "Retrieve the status of the printer";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        String string = parsedArguments.getArg(0);
        if (parsedArguments.containsOption(PORT_OPTION)) {
            this.verbosePrint("Retrieving port status");
            for (TcpPortStatus tcpPortStatus : PrinterUtil.getPortStatus(this.getConnectionFromArgs(parsedArguments, string))) {
                System.out.println(tcpPortStatus);
            }
        } else if (parsedArguments.containsOption(PRINTER_OPTION)) {
            this.verbosePrint("Retrieving printer status");
            for (String string2 : PrinterUtil.getPrinterStatus(this.getConnectionFromArgs(parsedArguments, string))) {
                System.out.println(string2);
            }
        } else if (parsedArguments.containsOption(ODOMETER_OPTION)) {
            this.verbosePrint("Retrieving odometer status");
            for (String string3 : PrinterUtil.getOdometerStatus(this.getConnectionFromArgs(parsedArguments, string))) {
                System.out.println(string3);
            }
        } else {
            this.verbosePrint("Retrieving quick status");
            System.out.println(PrinterUtil.quickStatus(this.getConnectionFromArgs(parsedArguments, string)));
        }
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.ONE_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Get the status for a printer at 10.3.4.5\n");
        stringBuilder.append(String.format("\t%s %s 10.3.4.5%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Get the status for a printer using TLS via default port\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.TLS_OPTION.getLongName()));
        stringBuilder.append("Get the status for a printer using TLS via port 9143 in verbose mode\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4:9143 --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Get the port status for a printer at XXB1234\n");
        stringBuilder.append(String.format("\t%s %s XXB1234 --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), PORT_OPTION.getLongName()));
        stringBuilder.append("Get the status for a printer via ZDesigner Driver\n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.DRIVER_OPTION.getLongName()));
        stringBuilder.append("Get the status for a printer via Driverless USB\n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\"%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        return stringBuilder.toString();
    }
}

