/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.internal;

import com.zebra.sdk.certificate.ZebraCertificateException;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.internal.ConnectionBuilderInternal;
import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.commands.internal.HelpCommand;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.Parser;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.NotALinkOsPrinterException;
import com.zebra.sdk.printer.ZebraPrinterLanguageUnknownException;
import com.zebra.sdk.printer.discovery.DiscoveryException;
import com.zebra.sdk.settings.SettingsException;
import com.zebra.sdk.util.internal.ReflectionUtil;
import com.zebra.sdk.weblink.ZebraWeblinkException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ZebraCommandLineApp {
    private static Map<String, Command> commands = new HashMap<String, Command>();
    public static final int IO_ERROR = 100;
    public static final int CONNECTION_ERROR = 101;
    public static final int WEBLINK_CONNECTION_ERROR = 102;
    public static final int PRINTER_DISCOVERY_ERROR = 103;
    public static final int ILLEGAL_ARGUMENT_ERROR = 200;
    public static final int CERTIFICATE_PROCESSING_ERROR = 201;
    public static final int NOT_A_LINKOS_PRINTER_ERROR = 300;
    public static final int ZEBRA_PRINTER_LANGUAGE_UNKNOWN_ERROR = 301;
    public static final int PRINTER_SETTINGS_CONFIGURATION_ERROR = 302;
    public static final int CLASS_NOT_FOUND = 400;
    public static final int UNKNOWN_ERROR = 1000;
    public static boolean VERBOSE_NEED = false;

    public static void main(String[] stringArray) {
        try {
            ZebraCommandLineApp.loadCommands();
            ParsedArguments parsedArguments = new Parser().parse(stringArray);
            String string = parsedArguments.getCommand();
            if (string != null && commands.containsKey(string)) {
                ZebraCommandLineApp.runCommand(commands.get(string), parsedArguments);
            } else {
                ZebraCommandLineApp.printTopLevelHelp();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            System.exit(400);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(100);
        }
    }

    public static void printTopLevelHelp() {
        System.out.println("Link-OS Multiplatform SDK - Version 2.15.5553");
        System.out.println("usage: java -jar ZSDK_API.jar <commmand> [<args>]\n");
        System.out.println("Commands include:\n");
        int n = -1;
        for (Command object2 : commands.values()) {
            if (object2.getCommandName().length() <= n) continue;
            n = object2.getCommandName().length();
        }
        ArrayList arrayList = new ArrayList();
        String string = " %-" + n + "s - %s%n";
        for (Command command : commands.values()) {
            arrayList.add(String.format(string, command.getCommandName(), command.blockWrite(command.getDescription(), 80 - (n + 4), true)));
        }
        Collections.sort(arrayList);
        Iterator<Command> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)((Object)iterator.next());
            System.out.print(string2);
        }
        System.out.println("\nUse 'java -jar ZSDK_API.jar <command> --help' to see more information on a specific command");
        System.out.println("\nUse 'java -jar ZSDK_API.jar help <command>' to see examples and information on a specific command");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runCommand(Command command, ParsedArguments parsedArguments) {
        try {
            if (parsedArguments.containsOption(ZebraCommandConstants.HELP_OPTION)) {
                command.printHelpMessage();
            } else if (command instanceof HelpCommand) {
                ((HelpCommand)command).run(commands.get(parsedArguments.getArg(0)));
            } else {
                command.validateOptions(parsedArguments);
                command.setVerbose(parsedArguments.containsOption(ZebraCommandConstants.VERBOSE_OPTION));
                VERBOSE_NEED = parsedArguments.containsOption(ZebraCommandConstants.VERBOSE_OPTION);
                ConnectionBuilderInternal.setConnBuilderVerbosity(parsedArguments.containsOption(ZebraCommandConstants.VERBOSE_OPTION));
                command.run(parsedArguments);
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            System.out.println(string == null ? "Unknown error occurred." : string);
            if (command != null) {
                System.out.format("See 'help %s' for usage and options, or use verbose option for more details.%n", command.getCommandName());
            }
            int n = 1000;
            if (exception instanceof ConnectionException) {
                n = 101;
            } else if (exception instanceof ZebraIllegalArgumentException || exception instanceof IllegalArgumentException) {
                n = 200;
            } else if (exception instanceof DiscoveryException) {
                n = 103;
            } else if (exception instanceof NotALinkOsPrinterException) {
                n = 300;
            } else if (exception instanceof ZebraPrinterLanguageUnknownException) {
                n = 301;
            } else if (exception instanceof SettingsException) {
                n = 302;
            } else if (exception instanceof ZebraWeblinkException) {
                n = 102;
            } else if (exception instanceof ZebraCertificateException) {
                n = 201;
            }
            System.exit(n);
        }
        finally {
            ConnectionBuilderInternal.setConnBuilderVerbosity(false);
        }
    }

    private static void loadCommands() throws ClassNotFoundException, IOException {
        for (Class<?> clazz : ReflectionUtil.getClassesInPackageExtending("com.zebra.sdk.commandline.commands.internal", Command.class)) {
            try {
                Command command = (Command)clazz.newInstance();
                command.addOption(ZebraCommandConstants.HELP_OPTION);
                command.addOption(ZebraCommandConstants.VERBOSE_OPTION);
                commands.put(command.getCommandName(), command);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    public static boolean isVerboseNeed() {
        return VERBOSE_NEED;
    }

    public static boolean isCommandLineExecution() {
        return !commands.isEmpty();
    }
}

