/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.QuoteRemovingOutputStream;
import com.zebra.sdk.settings.internal.ConnectionUtil;
import com.zebra.sdk.settings.internal.JsonHelper;
import com.zebra.sdk.settings.internal.JsonValidator;
import com.zebra.sdk.settings.internal.SgdValidator;
import com.zebra.sdk.util.internal.StringUtilities;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class SGD {
    private SGD() {
    }

    public static void SET(String string, int n, Connection connection) throws ConnectionException {
        SGD.SET(string, String.valueOf(n), connection);
    }

    public static void SET(String string, String string2, Connection connection) throws ConnectionException {
        Connection connection2 = ConnectionUtil.selectConnection(connection);
        if (connection2 instanceof StatusConnection) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(string, string2);
            byte[] byArray = JsonHelper.buildSetCommand(hashMap);
            connection2.sendAndWaitForValidResponse(byArray, connection2.getMaxTimeoutForRead(), connection2.getTimeToWaitForMoreData(), new JsonValidator());
        } else {
            String string3 = "! U1 setvar \"" + string + "\" \"" + string2 + "\"" + "\r\n";
            connection2.write(string3.getBytes());
        }
    }

    public static String GET(String string, Connection connection) throws ConnectionException {
        return SGD.GET(string, connection, connection.getMaxTimeoutForRead(), connection.getTimeToWaitForMoreData());
    }

    public static String GET(String string, Connection connection, int n, int n2) throws ConnectionException {
        String string2 = "";
        Connection connection2 = ConnectionUtil.selectConnection(connection);
        if (connection2 instanceof StatusConnection) {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(string);
            byte[] byArray = JsonHelper.buildQuery(linkedList);
            byte[] byArray2 = connection2.sendAndWaitForValidResponse(byArray, n, n2, new JsonValidator());
            try {
                Map<String, String> map = JsonHelper.parseGetResponse(byArray2);
                string2 = map.get(string);
            }
            catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
                // empty catch block
            }
            if (null == string2) {
                string2 = "";
            }
        } else {
            String string3 = "! U1 getvar \"" + string + "\"" + "\r\n";
            byte[] byArray = connection2.sendAndWaitForValidResponse(string3.getBytes(), n, n2, new SgdValidator());
            string2 = StringUtilities.stripQuotes(new String(byArray));
        }
        return string2;
    }

    public static String DO(String string, String string2, Connection connection) throws ConnectionException {
        return SGD.DO(string, string2, connection, connection.getMaxTimeoutForRead(), connection.getTimeToWaitForMoreData());
    }

    public static void DO(OutputStream outputStream, String string, String string2, Connection connection) throws ConnectionException {
        SGD.DO(outputStream, string, string2, connection, connection.getMaxTimeoutForRead(), connection.getTimeToWaitForMoreData());
    }

    public static String DO(String string, String string2, Connection connection, int n, int n2) throws ConnectionException {
        String string3 = "";
        Connection connection2 = ConnectionUtil.selectConnection(connection);
        if (connection2 instanceof StatusConnection) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(string, string2);
            byte[] byArray = JsonHelper.buildSetCommand(hashMap);
            byte[] byArray2 = connection2.sendAndWaitForValidResponse(byArray, n, n2, new JsonValidator());
            try {
                Map<String, String> map = JsonHelper.parseGetResponse(byArray2);
                string3 = map.get(string);
            }
            catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
                // empty catch block
            }
            if (null == string3) {
                string3 = "";
            }
        } else {
            String string4 = "! U1 do \"" + string + "\" \"" + string2 + "\"" + "\r\n";
            byte[] byArray = connection2.sendAndWaitForValidResponse(string4.getBytes(), n, n2, new SgdValidator());
            string3 = StringUtilities.stripQuotes(new String(byArray));
        }
        return string3;
    }

    public static void DO(OutputStream outputStream, String string, String string2, Connection connection, int n, int n2) throws ConnectionException {
        Connection connection2 = ConnectionUtil.selectConnection(connection);
        if (connection2 instanceof StatusConnection) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(string, string2);
            byte[] byArray = JsonHelper.buildSetCommand(hashMap);
            byte[] byArray2 = connection2.sendAndWaitForValidResponse(byArray, n, n2, new JsonValidator());
            String string3 = null;
            try {
                Map<String, String> map = JsonHelper.parseGetResponse(byArray2);
                string3 = map.get(string);
            }
            catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
                // empty catch block
            }
            if (null == string3) {
                string3 = "";
            }
            try {
                outputStream.write(string3.getBytes());
            }
            catch (Exception exception) {
                throw new ConnectionException(exception.getLocalizedMessage());
            }
        }
        QuoteRemovingOutputStream quoteRemovingOutputStream = new QuoteRemovingOutputStream(outputStream);
        String string4 = "! U1 do \"" + string + "\" \"" + string2 + "\"" + "\r\n";
        connection2.sendAndWaitForValidResponse(quoteRemovingOutputStream, new ByteArrayInputStream(string4.getBytes()), n, n2, new SgdValidator());
    }
}

