/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery.internal;

import com.zebra.sdk.printer.discovery.DiscoveredPrinterNetwork;
import com.zebra.sdk.printer.discovery.DiscoveryException;
import com.zebra.sdk.printer.discovery.DiscoveryHandler;
import com.zebra.sdk.printer.discovery.DiscoveryPacketDecodeException;
import com.zebra.sdk.printer.discovery.internal.DeviceType;
import com.zebra.sdk.printer.discovery.internal.DiscoveredPrinterNetworkFactory;
import com.zebra.sdk.printer.discovery.internal.ZebraDiscoSocket;
import com.zebra.sdk.printer.discovery.internal.ZebraDiscoSocketImpl;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public abstract class BroadcastA {
    private Map<String, String> discoveredPrinters;
    protected boolean isSubnetSearch = false;
    protected DiscoveryHandler discoveryHandler;
    private final int DISCOVERY_PORT = 4201;
    public static int MAX_DATAGRAM_SIZE = 65507;
    protected static byte[] ADVANCED_DISCOVERY_REQUEST_PACKET = new byte[]{46, 44, 58, 1, 0, 0, 0, 1, -92, -19, 0, 0, 0};
    protected static byte[] ENHANCED_DISCOVERY_REQUEST_PACKET = new byte[]{46, 44, 90, 1, 0, 0, -92, -19};
    public static byte[] DISCOVERY_REQUEST_PACKET = new byte[]{46, 44, 58, 1, 0, 0};
    private byte[] DEVICE_DISCOVERY_REQUEST_PACKET = (byte[])ADVANCED_DISCOVERY_REQUEST_PACKET.clone();
    protected static final int DEFAULT_LATE_ARRIVAL_DELAY = 6000;
    private int waitForResponsesTimeout = 6000;
    protected InetAddress[] broadcastIpAddresses;

    protected BroadcastA(int n) {
        this.waitForResponsesTimeout = n;
        this.discoveredPrinters = new HashMap<String, String>();
    }

    protected abstract void setSocketOptions(ZebraDiscoSocket var1) throws DiscoveryException;

    public void doBroadcast(DiscoveryHandler discoveryHandler) throws DiscoveryException {
        if (discoveryHandler == null) {
            throw new DiscoveryException("A DiscoveryHandler must be supplied");
        }
        this.discoveryHandler = discoveryHandler;
        this.startDiscoveryInBackground();
    }

    private void startDiscoveryInBackground() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (BroadcastA.this.doDiscovery()) {
                    BroadcastA.this.discoveryHandler.discoveryFinished();
                }
            }
        }).start();
    }

    protected boolean doDiscovery() {
        try {
            ZebraDiscoSocket zebraDiscoSocket = this.createDiscoverySocket();
            DatagramPacket datagramPacket = this.createDiscoveryRequestPacket();
            byte[] byArray = new byte[MAX_DATAGRAM_SIZE];
            DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length);
            this.sendDiscoveryRequest(zebraDiscoSocket, datagramPacket);
            this.getDiscoveryResponses(zebraDiscoSocket, datagramPacket2);
            zebraDiscoSocket.close();
            return true;
        }
        catch (IOException iOException) {
            this.discoveryHandler.discoveryError(iOException.getMessage());
        }
        catch (DiscoveryException discoveryException) {
            this.discoveryHandler.discoveryError(discoveryException.getMessage());
        }
        catch (DiscoveryPacketDecodeException discoveryPacketDecodeException) {
            this.discoveryHandler.discoveryError(discoveryPacketDecodeException.getMessage());
        }
        return false;
    }

    protected DatagramPacket createDiscoveryRequestPacket() {
        return new DatagramPacket(this.DEVICE_DISCOVERY_REQUEST_PACKET, this.DEVICE_DISCOVERY_REQUEST_PACKET.length);
    }

    private ZebraDiscoSocket createDiscoverySocket() throws DiscoveryException, SocketException, UnknownHostException {
        ZebraDiscoSocket zebraDiscoSocket = this.createDiscoSocket();
        this.setSocketOptions(zebraDiscoSocket);
        zebraDiscoSocket.setSoTimeout(this.waitForResponsesTimeout);
        return zebraDiscoSocket;
    }

    private void getDiscoveryResponses(ZebraDiscoSocket zebraDiscoSocket, DatagramPacket datagramPacket) throws DiscoveryPacketDecodeException, IOException {
        try {
            while (true) {
                DiscoveredPrinterNetwork discoveredPrinterNetwork;
                zebraDiscoSocket.receive(datagramPacket);
                InetAddress inetAddress = datagramPacket.getAddress();
                if (this.isSubnetSearch) {
                    if (inetAddress instanceof Inet6Address) {
                        inetAddress = this.resolveIpv6BroadcastAddress(inetAddress);
                    } else if (!this.isAddressInRange(inetAddress)) continue;
                }
                if (!this.discoveredPrinters.containsKey((discoveredPrinterNetwork = this.getDiscoveredPrinter(datagramPacket, inetAddress)).getDiscoveryDataMap().get("ADDRESS"))) {
                    this.discoveryHandler.foundPrinter(discoveredPrinterNetwork);
                    this.discoveredPrinters.put(discoveredPrinterNetwork.getDiscoveryDataMap().get("ADDRESS"), discoveredPrinterNetwork.getDiscoveryDataMap().get("DNS_NAME"));
                }
                if (this.shouldExitOnceAPrinterIsFound()) break;
            }
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
        }
    }

    private boolean isAddressInRange(InetAddress inetAddress) {
        for (InetAddress inetAddress2 : this.broadcastIpAddresses) {
            if (!inetAddress2.equals(inetAddress)) continue;
            return true;
        }
        return false;
    }

    private InetAddress resolveIpv6BroadcastAddress(InetAddress inetAddress) {
        for (InetAddress inetAddress2 : this.broadcastIpAddresses) {
            if (!this.isInSameSubnet(inetAddress, inetAddress2)) continue;
            return inetAddress2;
        }
        return inetAddress;
    }

    private boolean isInSameSubnet(InetAddress inetAddress, InetAddress inetAddress2) {
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = inetAddress2.getAddress();
        for (int i = 0; i < 8; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private DiscoveredPrinterNetwork getDiscoveredPrinter(DatagramPacket datagramPacket, InetAddress inetAddress) throws DiscoveryPacketDecodeException {
        if (inetAddress instanceof Inet6Address) {
            return DiscoveredPrinterNetworkFactory.getDiscoveredPrinterNetworkWithIpv6(datagramPacket.getData(), inetAddress.getHostAddress());
        }
        return DiscoveredPrinterNetworkFactory.getDiscoveredPrinterNetwork(datagramPacket.getData());
    }

    protected boolean shouldExitOnceAPrinterIsFound() {
        return false;
    }

    private void sendDiscoveryRequest(ZebraDiscoSocket zebraDiscoSocket, DatagramPacket datagramPacket) throws IOException {
        for (int i = 0; i < this.broadcastIpAddresses.length; ++i) {
            datagramPacket.setSocketAddress(new InetSocketAddress(this.broadcastIpAddresses[i], 4201));
            zebraDiscoSocket.send(datagramPacket);
        }
    }

    protected ZebraDiscoSocket createDiscoSocket() throws DiscoveryException {
        return new ZebraDiscoSocketImpl();
    }

    protected void configureDiscoPacket(DeviceType deviceType) {
        switch (deviceType) {
            case ALL: {
                this.DEVICE_DISCOVERY_REQUEST_PACKET[7] = 2;
                break;
            }
            case ZMOTIF: {
                this.DEVICE_DISCOVERY_REQUEST_PACKET = ENHANCED_DISCOVERY_REQUEST_PACKET;
                this.DEVICE_DISCOVERY_REQUEST_PACKET[5] = 2;
                break;
            }
            default: {
                this.DEVICE_DISCOVERY_REQUEST_PACKET = ADVANCED_DISCOVERY_REQUEST_PACKET;
                this.DEVICE_DISCOVERY_REQUEST_PACKET[7] = 1;
            }
        }
    }
}

