/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery.internal;

import com.zebra.sdk.printer.discovery.DiscoveryException;
import com.zebra.sdk.printer.discovery.internal.BroadcastA;
import com.zebra.sdk.printer.discovery.internal.ZebraDiscoSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class MulticastBroadcastIpv6
extends BroadcastA {
    private int hops = 0;
    private String scope = "ff02::1";

    public MulticastBroadcastIpv6(int n) throws DiscoveryException {
        this(n, 6000);
    }

    public MulticastBroadcastIpv6(int n, int n2) throws DiscoveryException {
        super(n2);
        if (n < 0) {
            throw new DiscoveryException(n + " is an invalid multicast hop argument");
        }
        this.hops = n;
        try {
            this.broadcastIpAddresses = InetAddress.getAllByName(this.scope);
        }
        catch (UnknownHostException unknownHostException) {
            throw new DiscoveryException(unknownHostException.getMessage());
        }
    }

    @Override
    protected void setSocketOptions(ZebraDiscoSocket zebraDiscoSocket) throws DiscoveryException {
        try {
            zebraDiscoSocket.joinGroup(this.scope);
            zebraDiscoSocket.setTimeToLive(this.hops);
        }
        catch (IOException iOException) {
            throw new DiscoveryException(iOException.getMessage());
        }
    }
}

