/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.printer.FirmwareUpdateHandler;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.util.internal.StringUtilities;

public class FirmwareUpdateHandlerVerboseDecorator
implements FirmwareUpdateHandler {
    private FirmwareUpdateHandler myDecoratedFimwareUpdateHander;
    private boolean isVerbose;
    private String connectionIdentifierString;
    private String firmwareFileIdentifierString;
    private int lastPercentComplete = -1;

    public FirmwareUpdateHandlerVerboseDecorator(boolean bl, String string, String string2, FirmwareUpdateHandler firmwareUpdateHandler) {
        this.myDecoratedFimwareUpdateHander = firmwareUpdateHandler;
        this.isVerbose = bl;
        this.connectionIdentifierString = string;
        this.firmwareFileIdentifierString = string2;
    }

    @Override
    public void progressUpdate(int n, int n2) {
        if (this.isVerbose) {
            double d;
            int n3;
            if (this.lastPercentComplete == -1) {
                System.out.format("FW download progress : [%20s]", " ");
            }
            if ((n3 = (int)(d = (double)n / (double)n2 * 100.0)) == 100) {
                System.out.format("%s", StringUtilities.repeat("\b", 12));
                System.out.format("%s", "100");
                System.out.format("%s]%n", StringUtilities.repeat("*", 8));
            } else if (this.lastPercentComplete != n3) {
                this.lastPercentComplete = n3;
                int n4 = this.lastPercentComplete / 5;
                String string = String.format("%02d", this.lastPercentComplete);
                if (this.lastPercentComplete % 5 == 0) {
                    System.out.format("%s", StringUtilities.repeat("\b", 21));
                    if (n4 < 10) {
                        System.out.format("%-9s", StringUtilities.repeat("*", n4));
                        System.out.format("%-11s]", string);
                    } else {
                        System.out.format("%-9s", StringUtilities.repeat("*", 9));
                        System.out.format("%-2s", string);
                        int n5 = n4 - 11 >= 0 ? n4 - 11 : 0;
                        System.out.format("%-9s]", StringUtilities.repeat("*", n5));
                    }
                } else {
                    System.out.format("%s", StringUtilities.repeat("\b", 12));
                    System.out.format("%-2s", string);
                    if (n4 < 11) {
                        System.out.format("%-9s]", " ");
                    } else {
                        int n6 = n4 - 11 >= 0 ? n4 - 11 : 0;
                        System.out.format("%-9s]", StringUtilities.repeat("*", n6));
                    }
                }
            }
        }
        this.myDecoratedFimwareUpdateHander.progressUpdate(n, n2);
    }

    @Override
    public void firmwareDownloadComplete() {
        if (this.isVerbose) {
            System.out.format("%s accepted firmware file %s%n", this.connectionIdentifierString, this.firmwareFileIdentifierString);
            System.out.format("Flashing firmware to printer...%n", new Object[0]);
        }
        this.myDecoratedFimwareUpdateHander.firmwareDownloadComplete();
    }

    @Override
    public void printerOnline(ZebraPrinterLinkOs zebraPrinterLinkOs, String string) {
        if (this.isVerbose) {
            System.out.format("%s is back online with address %s and firmware version %s%n", this.connectionIdentifierString, zebraPrinterLinkOs == null ? "unknown" : zebraPrinterLinkOs.getConnection().getSimpleConnectionName(), string);
        }
        this.myDecoratedFimwareUpdateHander.printerOnline(zebraPrinterLinkOs, string);
    }
}

