/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.MultichannelConnection;
import com.zebra.sdk.comm.MultichannelTcpConnection;
import com.zebra.sdk.comm.MultichannelTlsConnection;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.comm.TcpConnection;
import com.zebra.sdk.comm.TlsConnection;
import com.zebra.sdk.comm.internal.ConnectionBuilderInternal;
import com.zebra.sdk.device.ProgressMonitor;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.FirmwareUpdateHandler;
import com.zebra.sdk.printer.FirmwareUpdateHandlerBase;
import com.zebra.sdk.printer.FirmwareUpdaterLinkOs;
import com.zebra.sdk.printer.ZebraPrinterFactory;
import com.zebra.sdk.printer.ZebraPrinterLanguageUnknownException;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.printer.discovery.DiscoveredPrinter;
import com.zebra.sdk.printer.discovery.DiscoveryException;
import com.zebra.sdk.printer.discovery.DiscoveryHandler;
import com.zebra.sdk.printer.internal.FirmwareDownloadRunnable;
import com.zebra.sdk.printer.internal.FirmwareUtil;
import com.zebra.sdk.util.internal.IPv6Util;
import com.zebra.sdk.util.internal.ReflectionUtil;
import com.zebra.sdk.util.internal.SGDUtilities;
import com.zebra.sdk.util.internal.Sleeper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeoutException;

public class FirmwareUpdaterLinkOsBase
implements FirmwareUpdaterLinkOs {
    private static final int MIN_TIMEOUT_MS = 600000;
    private String firmwareFilePath;
    protected Connection zebraPrinterConnection;

    public FirmwareUpdaterLinkOsBase(ZebraPrinterLinkOs zebraPrinterLinkOs) {
        this.zebraPrinterConnection = zebraPrinterLinkOs.getConnection();
    }

    @Override
    public void updateFirmware(String string, FirmwareUpdateHandler firmwareUpdateHandler) throws ConnectionException, ZebraPrinterLanguageUnknownException, ZebraIllegalArgumentException, DiscoveryException, TimeoutException, FileNotFoundException {
        this.updateFirmware(string, 600000L, firmwareUpdateHandler, false);
    }

    @Override
    public void updateFirmware(String string, long l, FirmwareUpdateHandler firmwareUpdateHandler) throws ConnectionException, ZebraPrinterLanguageUnknownException, ZebraIllegalArgumentException, DiscoveryException, TimeoutException, FileNotFoundException {
        this.updateFirmware(string, l, firmwareUpdateHandler, false);
    }

    @Override
    public void updateFirmwareUnconditionally(String string, FirmwareUpdateHandler firmwareUpdateHandler) throws ConnectionException, ZebraPrinterLanguageUnknownException, ZebraIllegalArgumentException, DiscoveryException, TimeoutException, FileNotFoundException {
        this.updateFirmware(string, 600000L, firmwareUpdateHandler, true);
    }

    @Override
    public void updateFirmwareUnconditionally(String string, long l, FirmwareUpdateHandler firmwareUpdateHandler) throws ConnectionException, ZebraPrinterLanguageUnknownException, ZebraIllegalArgumentException, DiscoveryException, TimeoutException, FileNotFoundException {
        this.updateFirmware(string, l, firmwareUpdateHandler, true);
    }

    private void updateFirmware(String string, long l, FirmwareUpdateHandler firmwareUpdateHandler, boolean bl) throws ConnectionException, ZebraPrinterLanguageUnknownException, ZebraIllegalArgumentException, DiscoveryException, TimeoutException, FileNotFoundException {
        if (!new File(string).exists()) {
            throw new FileNotFoundException(string + " does not exist.");
        }
        this.throwExceptionStatusOnly();
        if (bl || this.firmwareVersionsDontMatch(string)) {
            this.doFwDownload(string, l, firmwareUpdateHandler);
        } else {
            firmwareUpdateHandler.firmwareDownloadComplete();
            firmwareUpdateHandler.printerOnline(ZebraPrinterFactory.getLinkOsPrinter(this.zebraPrinterConnection), FirmwareUtil.getFWVersionFromPrinterConnection(this.zebraPrinterConnection).trim());
        }
    }

    private void throwExceptionStatusOnly() throws ConnectionException {
        if (this.zebraPrinterConnection instanceof MultichannelConnection) {
            MultichannelConnection multichannelConnection = (MultichannelConnection)this.zebraPrinterConnection;
            if (this.isOnlySettingsChannelOpen(multichannelConnection)) {
                throw new ConnectionException("Cannot upgrade firmware with only the status channel open");
            }
        } else if (this.zebraPrinterConnection instanceof StatusConnection) {
            throw new ConnectionException("Cannot upgrade firmware on the status channel");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean firmwareVersionsDontMatch(String string) throws ConnectionException, FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(string);
        boolean bl = true;
        try {
            bl = FirmwareUtil.firmwareVersionsDontMatch((InputStream)fileInputStream, this.zebraPrinterConnection);
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                throw new ConnectionException(iOException.getLocalizedMessage());
            }
        }
        return bl;
    }

    protected void doFwDownload(String string, long l, final FirmwareUpdateHandler firmwareUpdateHandler) throws DiscoveryException, ConnectionException, TimeoutException, ZebraIllegalArgumentException, ZebraPrinterLanguageUnknownException {
        ConnectionReestablisher connectionReestablisher = this.zebraPrinterConnection.getConnectionReestablisher(180000L);
        long l2 = System.currentTimeMillis() + (l < 600000L ? 600000L : l);
        boolean bl = ReflectionUtil.isDriverConnection(this.zebraPrinterConnection);
        boolean bl2 = ReflectionUtil.isUsbConnection(this.zebraPrinterConnection);
        this.firmwareFilePath = string;
        if (this.isTcpConnection() || this.isTlsConnection()) {
            this.downloadFwViaThreadAndWaitForFailure(l2, firmwareUpdateHandler);
        } else if (this.zebraPrinterConnection instanceof MultichannelTcpConnection || this.zebraPrinterConnection instanceof MultichannelTlsConnection) {
            ZebraPrinterFactory.getInstance(this.zebraPrinterConnection).sendFileContents(string, new ProgressMonitor(){

                @Override
                public void updateProgress(int n, int n2) {
                    firmwareUpdateHandler.progressUpdate(n, n2);
                }
            });
        } else if (this.zebraPrinterConnection instanceof MultichannelConnection) {
            ZebraPrinterFactory.getInstance(this.zebraPrinterConnection).sendFileContents(string, new ProgressMonitor(){

                @Override
                public void updateProgress(int n, int n2) {
                    firmwareUpdateHandler.progressUpdate(n, n2);
                }
            });
        } else {
            ZebraPrinterFactory.getInstance(this.zebraPrinterConnection).sendFileContents(string, new ProgressMonitor(){

                @Override
                public void updateProgress(int n, int n2) {
                    firmwareUpdateHandler.progressUpdate(n, n2);
                }
            });
        }
        firmwareUpdateHandler.firmwareDownloadComplete();
        if (bl || bl2) {
            this.zebraPrinterConnection.close();
            Sleeper.sleep(90000L);
        } else {
            Sleeper.sleep(60000L);
            this.waitForPrinterToGoOffline(l2);
            this.zebraPrinterConnection.close();
        }
        connectionReestablisher.reestablishConnection(firmwareUpdateHandler);
    }

    protected String getConnectionPortNumber() {
        if (this.zebraPrinterConnection instanceof TcpConnection) {
            return ((TcpConnection)this.zebraPrinterConnection).getPortNumber();
        }
        if (this.zebraPrinterConnection instanceof MultichannelTcpConnection) {
            Connection connection = ((MultichannelTcpConnection)this.zebraPrinterConnection).getPrintingChannel();
            return ((TcpConnection)connection).getPortNumber();
        }
        if (this.zebraPrinterConnection instanceof TlsConnection) {
            return ((TlsConnection)this.zebraPrinterConnection).getPortNumber();
        }
        if (this.zebraPrinterConnection instanceof MultichannelTlsConnection) {
            Connection connection = ((MultichannelTlsConnection)this.zebraPrinterConnection).getPrintingChannel();
            return ((TlsConnection)connection).getPortNumber();
        }
        throw new IllegalStateException("Unsupported connection type for port extraction: " + this.zebraPrinterConnection.getClass().getName());
    }

    protected boolean isTcpConnection() {
        return this.zebraPrinterConnection instanceof TcpConnection;
    }

    protected boolean isTlsConnection() {
        return this.zebraPrinterConnection instanceof TlsConnection;
    }

    protected String getConnectionAddress() {
        if (this.zebraPrinterConnection instanceof TcpConnection) {
            return ((TcpConnection)this.zebraPrinterConnection).getAddress();
        }
        if (this.zebraPrinterConnection instanceof MultichannelTcpConnection) {
            Connection connection = ((MultichannelTcpConnection)this.zebraPrinterConnection).getPrintingChannel();
            return ((TcpConnection)connection).getAddress();
        }
        if (this.zebraPrinterConnection instanceof TlsConnection) {
            return ((TlsConnection)this.zebraPrinterConnection).getAddress();
        }
        if (this.zebraPrinterConnection instanceof MultichannelTlsConnection) {
            Connection connection = ((MultichannelTlsConnection)this.zebraPrinterConnection).getPrintingChannel();
            return ((TlsConnection)connection).getAddress();
        }
        throw new IllegalStateException("Unsupported connection type for address extraction: " + this.zebraPrinterConnection.getClass().getName());
    }

    private void timeoutCheck(long l) throws TimeoutException {
        if (System.currentTimeMillis() > l) {
            throw new TimeoutException("Firmware downloader timed out waiting for '" + this.zebraPrinterConnection + "' to come back online");
        }
    }

    protected void waitForPrinterToGoOffline(long l) throws ConnectionException, TimeoutException {
        while (true) {
            Sleeper.sleep(5000L);
            try {
                byte[] byArray = this.zebraPrinterConnection.sendAndWaitForResponse(SGDUtilities.decorateWithGetCommand("appl.name").getBytes(), 10000, 10000, null);
                if (byArray == null) break;
                if (byArray.length == 0) {
                }
            }
            catch (ConnectionException connectionException) {}
            break;
            this.timeoutCheck(l);
        }
    }

    private void downloadFwViaThreadAndWaitForFailure(long l, FirmwareUpdateHandlerBase firmwareUpdateHandlerBase) throws ConnectionException, ZebraIllegalArgumentException {
        Connection connection = ConnectionBuilderInternal.build(this.getConnectionString());
        FirmwareDownloadRunnable firmwareDownloadRunnable = new FirmwareDownloadRunnable(this.zebraPrinterConnection, this.firmwareFilePath, firmwareUpdateHandlerBase);
        Thread thread = new Thread(firmwareDownloadRunnable);
        thread.start();
        connection.open();
        while (System.currentTimeMillis() < l && thread.isAlive()) {
            Sleeper.sleep(12500L);
            connection.write(SGDUtilities.decorateWithGetCommand("device.host_status").getBytes());
            if (connection.read() == null) continue;
            connection.write(SGDUtilities.decorateWithGetCommand("device.reset").getBytes());
            connection.close();
            throw new ZebraIllegalArgumentException("Firmware not accepted by printer, rebooting printer.  Please verify firmware is valid.");
        }
        connection.close();
        if (firmwareDownloadRunnable.exceptionOccured()) {
            throw new ConnectionException(firmwareDownloadRunnable.getExceptionMessage());
        }
    }

    protected String getConnectionString() {
        String string = this.getConnectionAddress();
        String string2 = this.getConnectionPortNumber();
        if (IPv6Util.isIPv6Address(string) && !string.startsWith("[")) {
            string = "[" + string + "]";
        }
        String string3 = this.zebraPrinterConnection instanceof TlsConnection ? "TLS" : "TCP";
        return string3 + ":" + string + ":" + string2;
    }

    private boolean isOnlySettingsChannelOpen(MultichannelConnection multichannelConnection) {
        return multichannelConnection.getStatusChannel().isConnected() && !multichannelConnection.getPrintingChannel().isConnected();
    }

    private final class SinglePrinterDiscoveryHandler
    implements DiscoveryHandler {
        public boolean isFinished = false;
        public DiscoveredPrinter printer;

        private SinglePrinterDiscoveryHandler() {
        }

        @Override
        public void foundPrinter(DiscoveredPrinter discoveredPrinter) {
            this.printer = discoveredPrinter;
            this.isFinished = true;
        }

        @Override
        public void discoveryFinished() {
            this.isFinished = true;
        }

        @Override
        public void discoveryError(String string) {
        }
    }
}

