/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.MultichannelConnection;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.device.Profile;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.FileDeletionOption;
import com.zebra.sdk.printer.FirmwareUpdateHandler;
import com.zebra.sdk.printer.LinkOsInformation;
import com.zebra.sdk.printer.PrinterAlert;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.ProfileUtil;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.printer.ZebraPrinterLanguageUnknownException;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.printer.discovery.DiscoveryException;
import com.zebra.sdk.printer.internal.FirmwareUpdateHandlerVerboseDecorator;
import com.zebra.sdk.printer.internal.ProfileHelper;
import com.zebra.sdk.printer.internal.RestoreType;
import com.zebra.sdk.printer.internal.ZebraPrinterLinkOsImpl;
import com.zebra.sdk.settings.SettingsException;
import com.zebra.sdk.settings.internal.ConnectionUtil;
import com.zebra.sdk.settings.internal.JsonValidator;
import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.FileWrapper;
import com.zebra.sdk.util.internal.MultipartFileSender;
import com.zebra.sdk.util.internal.PrinterFileDescriptor;
import com.zebra.sdk.util.internal.PrinterFileMetadata;
import com.zebra.sdk.util.internal.ZipUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;

public class ProfileUtilLinkOsImpl
implements ProfileUtil {
    protected final ZebraPrinterLinkOsImpl linkOsPrinter;
    protected String drivePrefix;

    public ProfileUtilLinkOsImpl(ZebraPrinterLinkOsImpl zebraPrinterLinkOsImpl) {
        this.linkOsPrinter = zebraPrinterLinkOsImpl;
        this.drivePrefix = "*:";
    }

    @Override
    public void createProfile(String string) throws IOException, ZebraIllegalArgumentException, ConnectionException {
        String string2 = FileUtilities.changeExtension(string, "zprofile");
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        this.createOutputZipFile(fileOutputStream, this.getAllConfig());
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    @Override
    public void createProfile(OutputStream outputStream) throws IOException, ZebraIllegalArgumentException, ConnectionException {
        this.createOutputZipFile(outputStream, this.getAllConfig());
    }

    private byte[] getAllConfig() throws ConnectionException {
        Connection connection = ConnectionUtil.selectConnection(this.linkOsPrinter.getConnection());
        return connection.sendAndWaitForValidResponse("{}{\"allconfig\":null}".getBytes(), 10000, 2000, new JsonValidator());
    }

    @Override
    public void createBackup(String string) throws IOException, ZebraIllegalArgumentException, ConnectionException {
        this.createProfile(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOutputZipFile(OutputStream outputStream, byte[] byArray) throws FileNotFoundException, IOException, ZebraIllegalArgumentException, ConnectionException {
        ZipOutputStream zipOutputStream = null;
        boolean bl = false;
        try {
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(outputStream));
            zipOutputStream.putNextEntry(new ZipEntry("settings.json"));
            zipOutputStream.write(byArray);
            zipOutputStream.closeEntry();
            Connection connection = this.linkOsPrinter.getConnection();
            boolean bl2 = bl = this.linkOsPrinter.getPrinterControlLanguage() == PrinterLanguage.LINE_PRINT && !(connection instanceof StatusConnection) && !(connection instanceof MultichannelConnection);
            if (bl) {
                this.enableZplMode(this.linkOsPrinter);
            }
            try {
                String string = ProfileHelper.createJson(this.linkOsPrinter.getConfiguredAlerts());
                zipOutputStream.putNextEntry(new ZipEntry("alerts.json"));
                zipOutputStream.write(string.getBytes());
                zipOutputStream.closeEntry();
            }
            catch (SettingsException settingsException) {
                throw new IOException(settingsException);
            }
            this.saveFilesToProfile(zipOutputStream, this.linkOsPrinter);
        }
        finally {
            if (bl) {
                try {
                    this.reEnableLinePrintMode(this.linkOsPrinter);
                }
                catch (ConnectionException connectionException) {}
            }
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
    }

    private void enableZplMode(ZebraPrinterLinkOsImpl zebraPrinterLinkOsImpl) throws ConnectionException {
        SGD.SET("device.languages", "zpl", zebraPrinterLinkOsImpl.getConnection());
    }

    private void reEnableLinePrintMode(ZebraPrinterLinkOsImpl zebraPrinterLinkOsImpl) throws ConnectionException {
        SGD.SET("device.languages", "line_print", zebraPrinterLinkOsImpl.getConnection());
    }

    private void loadCloneOrArchiveImage(String string, RestoreType restoreType, boolean bl) throws IOException, ConnectionException {
        this.loadFirmwareFromProfile(string, bl);
        this.restoreSettings(string, restoreType);
        this.loadAlertsFromProfile(string);
        this.loadFilesFromProfile(string);
        this.loadSupplementFromProfile(string);
    }

    @Override
    public void loadBackup(String string, boolean bl) throws IOException, ConnectionException {
        this.deleteFilesBeforeLoadingProfile(FileDeletionOption.ALL);
        this.loadCloneOrArchiveImage(string, RestoreType.ARCHIVE, bl);
    }

    @Override
    public void loadBackup(String string) throws IOException, ConnectionException {
        this.loadBackup(string, false);
    }

    @Override
    public void loadProfile(String string, FileDeletionOption fileDeletionOption, boolean bl) throws IOException, ConnectionException {
        this.deleteFilesBeforeLoadingProfile(fileDeletionOption);
        this.loadCloneOrArchiveImage(string, RestoreType.CLONE, bl);
    }

    @Override
    public void loadProfile(String string) throws IOException, ConnectionException {
        this.loadProfile(string, FileDeletionOption.NONE, false);
    }

    private void deleteFilesBeforeLoadingProfile(FileDeletionOption fileDeletionOption) {
        switch (fileDeletionOption) {
            case ALL: {
                this.deleteAllFiles();
                break;
            }
            case CLONEABLE: {
                this.deleteAllCloneableFiles();
                break;
            }
        }
    }

    private void deleteAllFiles() {
        try {
            this.linkOsPrinter.deleteFile(this.drivePrefix + "*.*");
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    private void deleteAllCloneableFiles() {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList("ZPL", "GRF", "DAT", "BAS", "STO", "PNG", "LBL", "PCX", "BMP", "IMG", "WML", "HTM"));
        for (String string : hashSet) {
            try {
                this.linkOsPrinter.deleteFile(this.drivePrefix + "*." + string);
            }
            catch (ConnectionException connectionException) {}
        }
    }

    private void loadFirmwareFromProfile(String string, boolean bl) throws IOException, ConnectionException {
        ZipUtil zipUtil = new ZipUtil(string);
        if (zipUtil.containsEntry("firmwareFile.txt")) {
            File file = null;
            try {
                file = File.createTempFile("sdkTmpFwFile", "txt");
                zipUtil.extractEntry(file.getAbsolutePath(), "firmwareFile.txt");
                this.linkOsPrinter.updateFirmware(file.getAbsolutePath(), new FirmwareUpdateHandlerVerboseDecorator(bl, this.linkOsPrinter.getConnection().toString(), string, new FirmwareUpdateHandler(){

                    @Override
                    public void progressUpdate(int n, int n2) {
                    }

                    @Override
                    public void firmwareDownloadComplete() {
                    }

                    @Override
                    public void printerOnline(ZebraPrinterLinkOs zebraPrinterLinkOs, String string) {
                        Connection connection = zebraPrinterLinkOs.getConnection();
                        try {
                            connection.open();
                            ProfileUtilLinkOsImpl.this.linkOsPrinter.setConnection(connection);
                        }
                        catch (ConnectionException connectionException) {
                            // empty catch block
                        }
                    }
                }));
            }
            catch (ZebraPrinterLanguageUnknownException zebraPrinterLanguageUnknownException) {
                throw new ConnectionException(zebraPrinterLanguageUnknownException.getMessage());
            }
            catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
                throw new ConnectionException(zebraIllegalArgumentException.getMessage());
            }
            catch (DiscoveryException discoveryException) {
                throw new ConnectionException(discoveryException.getMessage());
            }
            catch (TimeoutException timeoutException) {
                throw new ConnectionException(timeoutException.getMessage());
            }
            finally {
                if (file != null) {
                    file.delete();
                }
            }
        }
    }

    private void restoreSettings(String string, RestoreType restoreType) throws FileNotFoundException, IOException, ConnectionException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap();
        LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
        Profile profile = new Profile(string);
        try {
            linkedHashMap = restoreType == RestoreType.ARCHIVE ? profile.getArchivableSettingValues() : profile.getClonableSettingValues();
        }
        catch (SettingsException settingsException) {
            throw new IOException(settingsException.getLocalizedMessage());
        }
        ProfileHelper.handleSpecialCases(linkedHashMap, restoreType);
        try {
            int n = 0;
            for (String string2 : linkedHashMap.keySet()) {
                linkedHashMap2.put(string2, (String)linkedHashMap.get(string2));
                if (n >= 100) {
                    n = 0;
                    this.linkOsPrinter.setSettings(linkedHashMap2);
                    linkedHashMap2 = new LinkedHashMap();
                }
                ++n;
            }
            this.linkOsPrinter.setSettings(linkedHashMap2);
        }
        catch (SettingsException settingsException) {
            throw new ConnectionException(settingsException.getLocalizedMessage());
        }
    }

    private void loadFilesFromProfile(String string) throws FileNotFoundException, IOException, ConnectionException {
        ZipUtil zipUtil = new ZipUtil(string);
        List<String> list = zipUtil.getEntryNames();
        ArrayList<PrinterFileDescriptor> arrayList = new ArrayList<PrinterFileDescriptor>();
        Connection connection = ConnectionUtil.selectConnection(this.linkOsPrinter.getConnection());
        for (String string2 : list) {
            if (ProfileHelper.isSpecialProfileFile(string2)) continue;
            byte[] byArray = zipUtil.extractEntry(string2);
            if (this.shouldSendMultipartForm(connection, this.linkOsPrinter)) {
                arrayList.add(this.getFileDescriptors(byArray, string2));
                continue;
            }
            connection.write(byArray);
        }
        if (!arrayList.isEmpty()) {
            MultipartFileSender.send(connection, arrayList);
        }
    }

    private PrinterFileDescriptor getFileDescriptors(byte[] byArray, String string) throws IOException {
        Closeable closeable;
        if (string.matches("^[A-Za-z]:[^\\\\/].*")) {
            string = string.substring(0, 2) + "\\" + string.substring(2);
        }
        if (this.containsCisdWrapper(new String(byArray))) {
            byArray = FileWrapper.stripOffCISDFWrapper(byArray);
        } else if (FileWrapper.isHzoExtension(FilenameUtils.getExtension((String)string))) {
            closeable = new ByteArrayOutputStream();
            try {
                FileWrapper.unwrapHZOResult((OutputStream)closeable, string, new String(byArray));
            }
            catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
                throw new IOException(zebraIllegalArgumentException);
            }
            byArray = ((ByteArrayOutputStream)closeable).toByteArray();
        }
        closeable = new ByteArrayInputStream(byArray);
        PrinterFileMetadata printerFileMetadata = new PrinterFileMetadata(byArray.length, "0000", "0000");
        PrinterFileDescriptor printerFileDescriptor = new PrinterFileDescriptor((InputStream)closeable, string, printerFileMetadata);
        return printerFileDescriptor;
    }

    private boolean isLinkOs2_5_OrHigher(LinkOsInformation linkOsInformation) {
        if (linkOsInformation.getMajor() == 2) {
            return linkOsInformation.getMinor() >= 5;
        }
        return linkOsInformation.getMajor() >= 3;
    }

    private boolean containsCisdWrapper(String string) {
        return (string = string.trim()).startsWith("! CISDFCRC16") || string.startsWith("! CISDFRCRC16");
    }

    private boolean shouldSendMultipartForm(Connection connection, ZebraPrinterLinkOs zebraPrinterLinkOs) {
        return this.isLinkOs2_5_OrHigher(zebraPrinterLinkOs.getLinkOsInformation()) && (zebraPrinterLinkOs.getPrinterControlLanguage() != PrinterLanguage.LINE_PRINT || connection instanceof StatusConnection);
    }

    private void loadSupplementFromProfile(String string) throws FileNotFoundException, IOException, ConnectionException {
        byte[] byArray = new ZipUtil(string).extractEntry("profileSupplement.txt");
        if (byArray.length > 0) {
            this.linkOsPrinter.getConnection().write(byArray);
        }
    }

    private void loadAlertsFromProfile(String string) throws FileNotFoundException, IOException {
        List<PrinterAlert> list = ProfileHelper.getAlertsFromJson(string);
        try {
            this.linkOsPrinter.removeAllAlerts();
            this.linkOsPrinter.configureAlerts(list);
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    private void saveFilesToProfile(ZipOutputStream zipOutputStream, ZebraPrinterLinkOs zebraPrinterLinkOs) throws ConnectionException, IOException, ZebraIllegalArgumentException {
        String[] stringArray = zebraPrinterLinkOs.retrieveFileNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.isCloneable(stringArray[i])) continue;
            try {
                byte[] byArray = zebraPrinterLinkOs.getPrinterDownloadableObjectFromPrinter(stringArray[i]);
                if (byArray.length <= 0) continue;
                zipOutputStream.putNextEntry(new ZipEntry(stringArray[i]));
                zipOutputStream.write(byArray);
                zipOutputStream.closeEntry();
                continue;
            }
            catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
                // empty catch block
            }
        }
    }

    private boolean isCloneable(String string) {
        if (string.toUpperCase().startsWith("Z:")) {
            return false;
        }
        return this.isValidExtension(string);
    }

    private boolean isValidExtension(String string) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList("PAC", "NRD", "BAZ", "BAE", "TTF", "TTE", "TXT", "CSV"));
        return !hashSet.contains(string.substring(string.lastIndexOf(46) + 1));
    }
}

