/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.remote.comm;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.MultichannelConnection;
import com.zebra.sdk.comm.internal.ConnectionInfo;
import com.zebra.sdk.comm.internal.NotMyConnectionDataException;
import com.zebra.sdk.remote.comm.RemoteConnection;
import com.zebra.sdk.remote.comm.RemoteStatusConnection;
import com.zebra.sdk.remote.comm.internal.MultichannelRemoteConnectionReestablisher;
import com.zebra.sdk.util.internal.RegexUtil;
import java.util.List;

public class MultichannelRemoteConnection
extends MultichannelConnection {
    protected MultichannelRemoteConnection(ConnectionInfo connectionInfo) throws NotMyConnectionDataException {
        this.initRemoteConnection(connectionInfo);
    }

    private String getConnectionBuilderPrefix() {
        return "REMOTE_MULTI";
    }

    private void initRemoteConnection(ConnectionInfo connectionInfo) throws NotMyConnectionDataException {
        String string = connectionInfo.getMyData();
        String string2 = "^\\s*((?i)" + this.getConnectionBuilderPrefix() + ":)?([^:]+)(:([\\d]{1,5}))?\\s*$";
        List<String> list = RegexUtil.getMatches(string2, string);
        if (list.isEmpty()) {
            throw new NotMyConnectionDataException("REMOTE Connection doesn't understand " + string);
        }
        int n = 11995;
        try {
            n = Integer.parseInt(list.get(4));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.init(list.get(2), n, 15000, 3000, 15000, 3000);
    }

    public MultichannelRemoteConnection(String string) {
        this(string, 11995, 15000, 3000);
    }

    public MultichannelRemoteConnection(String string, int n) {
        this(string, n, 15000, 3000);
    }

    public MultichannelRemoteConnection(String string, int n, int n2) {
        this(string, 11995, n, n2);
    }

    public MultichannelRemoteConnection(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, n2, n3);
    }

    public MultichannelRemoteConnection(String string, int n, int n2, int n3, int n4) {
        this.init(string, 11995, n, n2, n3, n4);
    }

    public MultichannelRemoteConnection(String string, int n, int n2, int n3, int n4, int n5) {
        this.init(string, n, n2, n3, n4, n5);
    }

    protected void init(String string, int n, int n2, int n3, int n4, int n5) {
        this.raw = new RemoteConnection(string, n, n2, n3);
        this.settings = new RemoteStatusConnection(string, n, n2, n3);
    }

    @Override
    public ConnectionReestablisher getConnectionReestablisher(long l) throws ConnectionException {
        return new MultichannelRemoteConnectionReestablisher(this, l);
    }

    @Override
    public String toString() {
        return this.getConnectionBuilderPrefix() + ":" + ((RemoteConnection)this.raw).getUniqueId() + ":" + ((RemoteConnection)this.raw).getRmiServerPort();
    }

    @Override
    public String getSimpleConnectionName() {
        return ((RemoteConnection)this.raw).getSimpleConnectionName();
    }
}

