/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.remote.comm;

import com.zebra.sdk.comm.ConnectionA;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.internal.ConnectionInfo;
import com.zebra.sdk.comm.internal.NotMyConnectionDataException;
import com.zebra.sdk.remote.comm.AlertMonitorI;
import com.zebra.sdk.remote.comm.internal.RemoteConnectionReestablisher;
import com.zebra.sdk.remote.comm.internal.WebSocketPortalI;
import com.zebra.sdk.settings.AlertCondition;
import com.zebra.sdk.util.internal.RegexUtil;
import java.io.ByteArrayOutputStream;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class RemoteConnection
extends ConnectionA {
    public static final int DEFAULT_ZEBRA_WEBSERVICES_RMI_PORT = 11995;
    public static final int DEFAULT_MAX_TIMEOUT_FOR_READ_REMOTE = 15000;
    public static final int DEFAULT_TIME_TO_WAIT_FOR_MORE_DATA_REMOTE = 3000;
    protected WebSocketPortalI webSocketPortal;
    protected String uniqueId;
    protected int rmiServerPort;
    private Queue<Byte> fifo;

    private RemoteConnection(ConnectionInfo connectionInfo) throws NotMyConnectionDataException {
        this.initRemoteConnection(connectionInfo);
    }

    private String getConnectionBuilderPrefix() {
        return "REMOTE";
    }

    protected void initRemoteConnection(ConnectionInfo connectionInfo) throws NotMyConnectionDataException {
        String string = "^\\s*((?i)REMOTE:)?([^:]+)(:([\\d]{1,5}))?\\s*$";
        String string2 = connectionInfo.getMyData();
        List<String> list = RegexUtil.getMatches(string, string2);
        if (list.isEmpty()) {
            throw new NotMyConnectionDataException("REMOTE Connection doesn't understand " + string2);
        }
        int n = 11995;
        try {
            n = Integer.parseInt(list.get(4));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setupRemoteConnection(list.get(2), n, 15000, 3000);
    }

    public RemoteConnection(String string) {
        this(string, 11995);
    }

    public RemoteConnection(String string, int n) {
        this(string, n, 15000, 3000);
    }

    public RemoteConnection(String string, int n, int n2, int n3) {
        this.setupRemoteConnection(string, n, n2, n3);
    }

    private void setupRemoteConnection(String string, int n, int n2, int n3) {
        this.isConnected = false;
        this.uniqueId = string;
        this.timeToWaitForMoreData = n3;
        this.maxTimeoutForRead = n2;
        this.rmiServerPort = n;
        this.fifo = new LinkedList<Byte>();
    }

    @Override
    public void open() throws ConnectionException {
        try {
            this.webSocketPortal = (WebSocketPortalI)LocateRegistry.getRegistry(this.rmiServerPort).lookup("WebSocketPortal");
        }
        catch (AccessException accessException) {
            throw new ConnectionException(accessException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new ConnectionException(remoteException.getLocalizedMessage());
        }
        catch (NotBoundException notBoundException) {
            throw new ConnectionException(notBoundException.getLocalizedMessage());
        }
        if (!this.isConnected()) {
            throw new ConnectionException("Printer " + this.uniqueId + " is not connected to the Zebra servlet");
        }
    }

    @Override
    public void close() throws ConnectionException {
    }

    @Override
    public void write(byte[] byArray) throws ConnectionException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws ConnectionException {
        try {
            this.getWebSocketPortal().writeViaWebSocket(this.uniqueId, byArray, n, n2);
            this.writeToLogStream(byArray, n, n2);
        }
        catch (RemoteException remoteException) {
            throw new ConnectionException(remoteException.getLocalizedMessage());
        }
    }

    @Override
    public synchronized byte[] read() throws ConnectionException {
        this.getAdditionalData();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (!this.fifo.isEmpty()) {
            byteArrayOutputStream.write(RemoteConnection.byte2int(this.fifo.remove()));
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public synchronized byte[] read(int n) throws ConnectionException {
        this.getAdditionalData();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while (!this.fifo.isEmpty() && n2++ <= n) {
            byteArrayOutputStream.write(RemoteConnection.byte2int(this.fifo.remove()));
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public synchronized int readChar() throws ConnectionException {
        if (this.fifo.isEmpty()) {
            this.getAdditionalData();
            if (this.fifo.isEmpty()) {
                return -1;
            }
        }
        return RemoteConnection.byte2int(this.fifo.remove());
    }

    private synchronized void getAdditionalData() throws ConnectionException {
        try {
            byte[] byArray;
            for (byte by : byArray = this.getWebSocketPortal().readViaWebSocket(this.uniqueId)) {
                this.fifo.add(by);
            }
        }
        catch (RemoteException remoteException) {
            throw new ConnectionException(remoteException.getLocalizedMessage());
        }
    }

    private static int byte2int(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    @Override
    public boolean isConnected() {
        boolean bl = false;
        try {
            bl = this.getWebSocketPortal().isConnected(this.uniqueId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public synchronized int bytesAvailable() throws ConnectionException {
        if (this.fifo.isEmpty()) {
            this.getAdditionalData();
        }
        return this.fifo.size();
    }

    public void registerForAlerts(HashSet<AlertCondition> hashSet, AlertMonitorI alertMonitorI) throws ConnectionException {
        try {
            this.getWebSocketPortal().registerForWebSocketAlerts(this.uniqueId, hashSet, alertMonitorI);
        }
        catch (RemoteException remoteException) {
            throw new ConnectionException(remoteException.getMessage());
        }
    }

    public void unregisterForAlerts(HashSet<AlertCondition> hashSet, AlertMonitorI alertMonitorI) throws ConnectionException {
        try {
            this.getWebSocketPortal().unregisterForWebSocketAlerts(this.uniqueId, hashSet, alertMonitorI);
        }
        catch (RemoteException remoteException) {
            throw new ConnectionException(remoteException.getMessage());
        }
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public int getRmiServerPort() {
        return this.rmiServerPort;
    }

    @Override
    public String toString() {
        return this.getConnectionBuilderPrefix() + ":" + this.getUniqueId() + ":" + this.getRmiServerPort();
    }

    @Override
    public String getSimpleConnectionName() {
        return this.getUniqueId();
    }

    @Override
    public ConnectionReestablisher getConnectionReestablisher(long l) throws ConnectionException {
        return new RemoteConnectionReestablisher(this, l);
    }

    protected WebSocketPortalI getWebSocketPortal() throws ConnectionException {
        if (this.webSocketPortal != null) {
            return this.webSocketPortal;
        }
        throw new ConnectionException("Could not connect to Zebra servlet");
    }
}

