/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.remote.comm;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.ConnectionStatusA;
import com.zebra.sdk.comm.internal.ConnectionInfo;
import com.zebra.sdk.comm.internal.NotMyConnectionDataException;
import com.zebra.sdk.remote.comm.internal.RemoteStatusConnectionReestablisher;
import com.zebra.sdk.remote.comm.internal.WebSocketPortalI;
import com.zebra.sdk.util.internal.RegexUtil;
import java.io.ByteArrayOutputStream;
import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class RemoteStatusConnection
extends ConnectionStatusA {
    protected WebSocketPortalI webSocketPortal;
    protected String uniqueId;
    protected int rmiServerPort;
    private Queue<Byte> fifo;

    protected RemoteStatusConnection(ConnectionInfo connectionInfo) throws NotMyConnectionDataException {
        String string = connectionInfo.getMyData();
        String string2 = "^\\s*(REMOTE_STATUS:)?([^:]+)(:([\\d]{1,5}))?\\s*$";
        List<String> list = RegexUtil.getMatches(string2, string);
        if (list.isEmpty()) {
            throw new NotMyConnectionDataException("REMOTE_STATUS Connection doesn't understand " + string);
        }
        int n = 11995;
        try {
            n = Integer.parseInt(list.get(4));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setupRemoteConnection(list.get(2), n, 15000, 3000);
    }

    public RemoteStatusConnection(String string) {
        this(string, 11995);
    }

    public RemoteStatusConnection(String string, int n) {
        this(string, n, 15000, 3000);
    }

    public RemoteStatusConnection(String string, int n, int n2, int n3) {
        this.setupRemoteConnection(string, n, n2, n3);
    }

    private String getConnectionBuilderPrefix() {
        return "REMOTE_STATUS";
    }

    private void setupRemoteConnection(String string, int n, int n2, int n3) {
        this.isConnected = false;
        this.uniqueId = string;
        this.timeToWaitForMoreData = n3;
        this.maxTimeoutForRead = n2;
        this.rmiServerPort = n;
        this.fifo = new LinkedList<Byte>();
        this.initWebSocketPortal(n);
    }

    protected void initWebSocketPortal(int n) {
        try {
            this.webSocketPortal = (WebSocketPortalI)LocateRegistry.getRegistry(n).lookup("WebSocketPortal");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void open() throws ConnectionException {
        try {
            this.getWebSocketPortal().openSettingsChannel(this.uniqueId);
        }
        catch (AccessException accessException) {
            throw new ConnectionException(accessException.getLocalizedMessage());
        }
        catch (RemoteException remoteException) {
            throw new ConnectionException(remoteException.getLocalizedMessage());
        }
    }

    @Override
    public void close() throws ConnectionException {
        try {
            this.getWebSocketPortal().closeSettingsChannel(this.uniqueId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void write(byte[] byArray) throws ConnectionException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws ConnectionException {
        try {
            this.getWebSocketPortal().writeViaSettingsWebSocket(this.uniqueId, byArray, n, n2);
            this.writeToLogStream(byArray, n, n2);
        }
        catch (RemoteException remoteException) {
            throw new ConnectionException(remoteException.getLocalizedMessage());
        }
    }

    @Override
    public synchronized byte[] read() throws ConnectionException {
        this.getAdditionalData();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (!this.fifo.isEmpty()) {
            byteArrayOutputStream.write(RemoteStatusConnection.byte2int(this.fifo.remove()));
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public synchronized byte[] read(int n) throws ConnectionException {
        this.getAdditionalData();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while (!this.fifo.isEmpty() && n2++ <= n) {
            byteArrayOutputStream.write(RemoteStatusConnection.byte2int(this.fifo.remove()));
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public synchronized int readChar() throws ConnectionException {
        if (this.fifo.isEmpty()) {
            this.getAdditionalData();
            if (this.fifo.isEmpty()) {
                return -1;
            }
        }
        return RemoteStatusConnection.byte2int(this.fifo.remove());
    }

    private synchronized void getAdditionalData() throws ConnectionException {
        try {
            byte[] byArray;
            for (byte by : byArray = this.getWebSocketPortal().readViaSettingsWebSocket(this.uniqueId)) {
                this.fifo.add(by);
            }
        }
        catch (RemoteException remoteException) {
            throw new ConnectionException(remoteException.getLocalizedMessage());
        }
    }

    private static int byte2int(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    @Override
    public boolean isConnected() {
        boolean bl = false;
        try {
            bl = this.getWebSocketPortal().isSettingsChannelConnected(this.uniqueId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public synchronized int bytesAvailable() throws ConnectionException {
        if (this.fifo.isEmpty()) {
            this.getAdditionalData();
        }
        return this.fifo.size();
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public int getRmiServerPort() {
        return this.rmiServerPort;
    }

    @Override
    public String toString() {
        return this.getConnectionBuilderPrefix() + ":" + this.getUniqueId() + ":" + this.getRmiServerPort();
    }

    @Override
    public String getSimpleConnectionName() {
        return this.getUniqueId();
    }

    @Override
    public ConnectionReestablisher getConnectionReestablisher(long l) throws ConnectionException {
        return new RemoteStatusConnectionReestablisher(this, l);
    }

    protected WebSocketPortalI getWebSocketPortal() throws ConnectionException {
        if (this.webSocketPortal != null) {
            return this.webSocketPortal;
        }
        throw new ConnectionException("Could not connect to Zebra servlet");
    }
}

