/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPv6Util {
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
    private static final Pattern IPV4_PATTERN = Pattern.compile("^\\s*(?:(?:[\\d]{1,3}\\.){3}[\\d]{1,3})\\s*$");
    private static final Pattern IPV4_WITH_PORT_PATTERN = Pattern.compile("^\\s*(?:(?:[\\d]{1,3}\\.){3}[\\d]{1,3})(?::(\\d{1,5}))?\\s*$");
    private static final Pattern DNS_WITH_PORT_PATTERN = Pattern.compile("^\\s*([^:\\s]+)(?::(\\d{1,5}))?\\s*$");
    private static final Pattern IPV6_WITH_PORT_PATTERN = Pattern.compile("^\\[(.+?)](?::(\\d{1,5}))?$");

    public static ParsedConnection parseConnectionInfo(String string, int n, String string2) throws IllegalArgumentException {
        Matcher matcher;
        String string3;
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Connection string is empty");
        }
        if (string2 != null && string.toLowerCase().startsWith(string2.toLowerCase() + ":")) {
            string = string.substring(string2.length() + 1).trim();
        }
        if (!(string3 = IPv6Util.getZoneId(string)).isEmpty()) {
            string = string.replace(string3, "");
        }
        if ((matcher = IPV6_WITH_PORT_PATTERN.matcher(string)).matches()) {
            int n2;
            String string4 = matcher.group(1);
            String string5 = matcher.group(2);
            int n3 = n2 = string5 != null ? Integer.parseInt(string5) : n;
            if (!string3.isEmpty()) {
                string4 = string4 + string3;
            }
            return new ParsedConnection(string4, n2, true);
        }
        Matcher matcher2 = IPV4_WITH_PORT_PATTERN.matcher(string);
        if (matcher2.matches()) {
            String string6 = string.split(":")[0];
            String string7 = matcher2.group(1);
            int n4 = string7 != null ? Integer.parseInt(string7) : n;
            return new ParsedConnection(string6, n4, false);
        }
        Matcher matcher3 = DNS_WITH_PORT_PATTERN.matcher(string);
        if (matcher3.matches()) {
            String string8 = matcher3.group(1);
            String string9 = matcher3.group(2);
            int n5 = string9 != null ? Integer.parseInt(string9) : n;
            return new ParsedConnection(string8, n5, false);
        }
        throw new IllegalArgumentException("Unsupported connection format: " + string);
    }

    public static ParsedMultiChannelConnection parseMultiChannelConnectionInfo(String string, int n, int n2, String string2) throws IllegalArgumentException {
        Matcher matcher;
        String string3;
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Connection string is empty");
        }
        if (string2 != null && string.toLowerCase().startsWith(string2.toLowerCase() + ":")) {
            string = string.substring(string2.length() + 1).trim();
        }
        if (!(string3 = IPv6Util.getZoneId(string)).isEmpty()) {
            string = string.replace(string3, "");
        }
        if ((matcher = Pattern.compile("^\\[(.+?)](?::(\\d{1,5}))?(?::(\\d{1,5}))?$").matcher(string)).matches()) {
            String string4 = matcher.group(1);
            if (!string3.isEmpty()) {
                string4 = string4 + string3;
            }
            int n3 = matcher.group(2) != null ? Integer.parseInt(matcher.group(2)) : n;
            int n4 = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : n2;
            return new ParsedMultiChannelConnection(string4, n3, n4, true);
        }
        Matcher matcher2 = Pattern.compile("^([^:\\s]+)(?::(\\d{1,5}))?(?::(\\d{1,5}))?$").matcher(string);
        if (matcher2.matches()) {
            String string5 = matcher2.group(1);
            int n5 = matcher2.group(2) != null ? Integer.parseInt(matcher2.group(2)) : n;
            int n6 = matcher2.group(3) != null ? Integer.parseInt(matcher2.group(3)) : n2;
            return new ParsedMultiChannelConnection(string5, n5, n6, false);
        }
        throw new IllegalArgumentException("Unrecognized multi-channel address format: " + string);
    }

    public static String getZoneId(String string) {
        Matcher matcher = Pattern.compile("%\\d+|%[a-zA-Z0-9]+").matcher(string);
        return matcher.find() ? matcher.group() : "";
    }

    public static boolean isIPv6Address(String string) {
        return IPv6Util.isIPv6StdAddress(string) || IPv6Util.isIPv6HexCompressedAddress(string);
    }

    public static boolean isIPv6StdAddress(String string) {
        return IPV6_STD_PATTERN.matcher(string).matches();
    }

    public static boolean isIPv6HexCompressedAddress(String string) {
        return IPV6_HEX_COMPRESSED_PATTERN.matcher(string).matches();
    }

    public static class ParsedConnection {
        public final String address;
        public final int port;
        public final boolean ipv6;

        public ParsedConnection(String string, int n, boolean bl) {
            this.address = string;
            this.port = n;
            this.ipv6 = bl;
        }

        public String toString() {
            return (this.ipv6 ? "[IPv6]" : "[IPv4/DNS]") + " " + this.address + ":" + this.port;
        }
    }

    public static class ParsedMultiChannelConnection {
        public final String address;
        public final int printPort;
        public final int statusPort;
        public final boolean ipv6;

        public ParsedMultiChannelConnection(String string, int n, int n2, boolean bl) {
            this.address = string;
            this.printPort = n;
            this.statusPort = n2;
            this.ipv6 = bl;
        }

        public String toString() {
            return (this.ipv6 ? "[IPv6]" : "[IPv4/DNS]") + " " + this.address + ":" + this.printPort + ":" + this.statusPort;
        }
    }
}

