/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import uk.co.westhawk.snmp.beans.ncdPart;
import uk.co.westhawk.snmp.pdu.GetNextPdu_vec;
import uk.co.westhawk.snmp.pdu.GetPdu_vec;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnUnsInteger;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.varbind;

class ethernet
extends ncdPart
implements Observer {
    private static final int ethernetType = 6;
    private static final int statusUp = 1;
    private static final String sysUpTime = "1.3.6.1.2.1.1.3.0";
    private static final String ifIndex = "1.3.6.1.2.1.2.2.1.1";
    private static final String ifType = "1.3.6.1.2.1.2.2.1.3";
    private static final String ifOperStatus = "1.3.6.1.2.1.2.2.1.8";
    private static final String ifInOctets = "1.3.6.1.2.1.2.2.1.10";
    private static final String ifOutOctets = "1.3.6.1.2.1.2.2.1.16";
    private long speed = -1L;
    private long prevSpeed = -1L;
    private long prevSys = -1L;
    private int prevOper = -1;
    private long prevInO = -1L;
    private long prevOutO = -1L;
    private int index = -1;
    GetNextPdu_vec typePdu;
    GetPdu_vec ethernetPdu;
    private boolean first = true;
    private boolean foundEthernet = false;

    public ethernet(String h, int p, String c, int i, SnmpContext con) {
        super(h, p, c, i, con);
    }

    public long getSpeed() {
        return this.speed;
    }

    public void doPdu() throws PduException, IOException {
        if (this.first) {
            this.typePdu = new GetNextPdu_vec(this.context, 2);
            this.typePdu.addObserver(this);
            this.typePdu.addOid(ifIndex);
            this.typePdu.addOid(ifType);
            this.typePdu.send();
            this.first = false;
        } else if (this.foundEthernet) {
            this.ethernetPdu = new GetPdu_vec(this.context, 5);
            this.ethernetPdu.addObserver(this);
            this.ethernetPdu.addOid(sysUpTime);
            this.ethernetPdu.addOid("1.3.6.1.2.1.2.2.1.3." + this.index);
            this.ethernetPdu.addOid("1.3.6.1.2.1.2.2.1.8." + this.index);
            this.ethernetPdu.addOid("1.3.6.1.2.1.2.2.1.10." + this.index);
            this.ethernetPdu.addOid("1.3.6.1.2.1.2.2.1.16." + this.index);
            this.ethernetPdu.send();
        }
    }

    public void update(Observable obs, Object ov) {
        if (obs == this.typePdu) {
            if (this.typePdu.getErrorStatus() == 0) {
                varbind[] vars = (varbind[])ov;
                if (vars[0].getOid().toString().startsWith(ifIndex)) {
                    int i = ((AsnInteger)vars[0].getValue()).getValue();
                    int t = ((AsnInteger)vars[1].getValue()).getValue();
                    if (t == 6) {
                        this.index = i;
                        this.foundEthernet = true;
                        this.isPduInFlight = false;
                    } else {
                        this.typePdu = new GetNextPdu_vec(this.context, 2);
                        this.typePdu.addObserver(this);
                        this.typePdu.addOid(vars[0]);
                        this.typePdu.addOid(vars[1]);
                        try {
                            this.typePdu.send();
                        }
                        catch (PduException exc) {
                            System.out.println("PduException " + exc.getMessage());
                        }
                        catch (IOException exc) {
                            System.out.println("IOException " + exc.getMessage());
                        }
                    }
                } else {
                    this.setMessage("Ethernet interface not available!");
                }
            } else {
                this.setMessage("Ethernet interface not available!");
            }
        } else {
            this.speed = -1L;
            int oper = -1;
            if (this.ethernetPdu.getErrorStatus() == 0) {
                varbind[] vars = (varbind[])ov;
                long sys = ((AsnUnsInteger)vars[0].getValue()).getValue();
                int t = ((AsnInteger)vars[1].getValue()).getValue();
                oper = ((AsnInteger)vars[2].getValue()).getValue();
                long inO = ((AsnUnsInteger)vars[3].getValue()).getValue();
                long outO = ((AsnUnsInteger)vars[4].getValue()).getValue();
                if (t == 6) {
                    long tdif;
                    if (oper == 1 && this.prevOper == 1 && (tdif = sys - this.prevSys) != 0L) {
                        this.speed = (inO - this.prevInO + (outO - this.prevOutO)) / tdif * 100L;
                        this.firePropertyChange("Speed", new Long(this.prevSpeed), new Long(this.speed));
                    }
                    this.prevSys = sys;
                    this.prevInO = inO;
                    this.prevOutO = outO;
                } else {
                    this.first = true;
                    this.foundEthernet = false;
                }
            }
            this.prevSpeed = this.speed;
            this.prevOper = oper;
            this.isPduInFlight = false;
        }
    }
}

