/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import uk.co.westhawk.snmp.stack.AsnDecoderv3;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnPduSequence;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.GetPdu;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.SnmpContextv3Basis;

public class SnmpContextv3Discovery
extends SnmpContextv3Basis {
    private static final String version_id = "@(#)$Id: SnmpContextv3Discovery.java,v 3.11 2009/03/05 13:12:50 birgita Exp $ Copyright Westhawk Ltd";

    public SnmpContextv3Discovery(String host, int port) throws IOException {
        super(host, port);
    }

    public SnmpContextv3Discovery(String host, int port, String typeSocketA) throws IOException {
        super(host, port, typeSocketA);
    }

    public SnmpContextv3Discovery(String host, int port, String bindAddress, String typeSocketA) throws IOException {
        super(host, port, bindAddress, typeSocketA);
    }

    public Pdu processIncomingPdu(byte[] message) throws DecodingException, IOException {
        String msg = this.checkContextSanity();
        if (msg != null) {
            throw new DecodingException(msg);
        }
        int l = message.length;
        byte[] copyOfMessage = new byte[l];
        System.arraycopy(message, 0, copyOfMessage, 0, l);
        AsnDecoderv3 rpdu = new AsnDecoderv3();
        ByteArrayInputStream in = new ByteArrayInputStream(message);
        AsnSequence asnTopSeq = rpdu.DecodeSNMPv3(in);
        int msgId = rpdu.getMsgId(asnTopSeq);
        AsnPduSequence pduSeq = rpdu.processSNMPv3(this, asnTopSeq, copyOfMessage, true);
        Pdu pdu = null;
        if (pduSeq != null) {
            byte type = pduSeq.getRespType();
            if (type == -96 && pduSeq.isSnmpv3Discovery()) {
                pdu = new GetPdu(this);
            } else if (AsnObject.debug > 3) {
                System.out.println(this.getClass().getName() + ".ProcessIncomingPdu(): PDU received with type " + pduSeq.getRespTypeString() + ". Ignoring it.");
            }
            if (pdu != null) {
                pdu.fillin(pduSeq);
                pdu.snmpv3MsgId = new Integer(msgId);
            }
        }
        return pdu;
    }

    public Object clone() throws CloneNotSupportedException {
        SnmpContextv3Discovery clContext = null;
        try {
            clContext = new SnmpContextv3Discovery(this.hostname, this.hostPort, this.bindAddr, this.typeSocket);
            clContext = (SnmpContextv3Discovery)this.cloneParameters(clContext);
        }
        catch (IOException exc) {
            throw new CloneNotSupportedException("IOException " + exc.getMessage());
        }
        return clContext;
    }
}

