@ECHO OFF
if not "%1" == "max" start /MAX cmd /c %0 max & exit/b
SET JRE_HOME=%CD%\jre

REM set defaults here:
SET _defaultsubnet=192.168.1.*
SET _defaultaddress=192.168.1.90
SET _defaultFileToSend=resources\sdk-cmdline-demo.prn

:MAIN
CLS
SETLOCAL ENABLEDELAYEDEXPANSION
ECHO.
ECHO ******************************************************************************************************************************************
ECHO *   Zebra Technologies Link-OS SDK Command Line Demo                                                                                     *
ECHO *                                                                                                                                        *
ECHO *   This demo shows how the Zebra Multiplatform SDK command line functions can be used in a script.                                      *
ECHO *   Reference: https://docs.microsoft.com/en-us/windows-server/administration/windows-commands/windows-commands                          *
ECHO *   SDK Version: 2.15.5553                                                                                                               *
ECHO *   Date: 16 JAN 2026                                                                                                                    *
ECHO *                                                                                                                                        *
ECHO *   THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTIES OF ANY KIND FROM ZEBRA, EITHER EXPRESS OR IMPLIED.                             *
ECHO *                                                                                                                                        *
ECHO ******************************************************************************************************************************************
ECHO.
ECHO  MAIN MENU
ECHO.
ECHO  1. Discover network connected printers on a specified subnet.
ECHO     Discovers and gets information from network connected printers.
ECHO     HINT: you can change the default subnet at the top of the batch file.
ECHO.
ECHO  2. Send a file.
ECHO     Sends a file to network connected printers via the TLS port.
ECHO     For every printer found:
ECHO      - Connection is attempted via the TLS port.
ECHO      - If successful, the Advanced Security Mode value is queried.
ECHO      - A file is sent to the printer if the value is "advanced" which assumes to be a printer shipped in EU Red configuration.
ECHO     HINT: add your config file to the resources folder and modify the filename for _defaultFileToSend at the top of the batch file.
ECHO.
ECHO  3. Test a single printer using port 9100.
ECHO     Checks if port 9100 is enabled by requesting printer status.
ECHO.
ECHO  4. Visit the Security Setup Wizard webpage.
ECHO     Access more information ^& resources about EU RED Security Enhancements for Zebra Printers.
ECHO.
ECHO  H. Display the list of command line functions.
ECHO     This shows all the available SDK command line options.
ECHO.
ECHO  S. Display help for a specific function.
ECHO     This shows help and examples for a specific function.
ECHO.
ECHO  Q. Quit.
ECHO.

REM MAIN MENU
SET /P "_menu=Type a menu option [1-4/H/S/Q] and press <Enter>: "
IF "%_menu%"=="1" GOTO GETSUBNETINFO
IF "%_menu%"=="2" GOTO GETSUBNETINFO
IF "%_menu%"=="3" GOTO GETPRINTERSTATUS
IF "%_menu%"=="4" GOTO LAUNCHASRPAGE
IF /I "%_menu%"=="h" GOTO SDKHELP
IF /I "%_menu%"=="s" GOTO SDKHELPSPECIFIC
IF /I "%_menu%"=="v" GOTO JAVAVERSION
IF /I "%_menu%"=="q" GOTO QUIT

ECHO.
ECHO =============INVALID INPUT=============
ECHO. 
ECHO      Please select a valid option
ECHO          from the Main Menu   
ECHO. 
ECHO =======PRESS ANY KEY TO CONTINUE=======

PAUSE > NUL
GOTO MAIN


:JAVAVERSION
CLS
ECHO Java Version:
%JRE_HOME%\bin\java -version
ECHO.
PAUSE
GOTO MAIN

:GETSUBNETINFO
CLS
IF "%_menu%"=="1" ECHO Menu Option: Discover network connected printers on a specified subnet
IF "%_menu%"=="2" ECHO Menu Option: Send a file
ECHO.
SET /P "_discosubnet=Enter the subnet to search (n.n.n.*) and press <Enter> (default !_defaultsubnet!): " || SET _discosubnet=!_defaultsubnet!
SET "_discomessage=Performing network discovery on subnet !_discosubnet!"
SET _discoverytype=`%JRE_HOME%\bin\java -jar sdk\ZSDK_API.jar discover --subnet !_discosubnet!`
IF "%_menu%"=="1" (GOTO NETWORKDISCOVERY)
IF "%_menu%"=="2" (GOTO SENDFILEMENU)


:NETWORKDISCOVERY
ECHO !_discomessage!
ECHO.
SET count=1
FOR /F "tokens=* USEBACKQ" %%F IN (!_discoverytype!) DO (  

  REM ** DISPLAY IP OF DISCOVERED PRINTER **
  ECHO -------------------------------------------------
  ECHO Found printer at address %%F
  ECHO Attempting connection to printer ... 
  SET scount=1
  FOR /F "delims=^" %%S in ('%JRE_HOME%\bin\java -jar sdk\ZSDK_API.jar status %%F --tls') DO (
     SET status!scount!=%%S
   	 SET /a scount=!scount!+1
   )

	 REM Print message if connection fails
	 SET "_prefix=!status1:~0,27!"
	 IF "!_prefix!"=="Could not connect to device" (
			ECHO TLS connection to printer failed: !status1!
			ECHO This printer likely isn't running Link-OS 7.4.2 or later.			
  			ECHO -------------------------------------------------
     	) ELSE (
			REM Continue for any other status			
			REM Check for not a Link-OS printer
			IF "!status1!"=="This is not a Link-OS printer" (
				ECHO Connection successful. Response: !status1!
				ECHO This maybe a Link-OS Basic printer.
				ECHO -------------------------------------------------
			) ELSE (
				REM Get printer info for a Link-OS printer
				ECHO Connection successful. Printer Status: !status1!
				ECHO.
				ECHO Getting printer information ...
				"%JRE_HOME%"\bin\java -jar sdk\ZSDK_API.jar sendJSON %%F {}{\"device.product_name\":null,\"device.unique_id\":null,\"appl.link_os_version\":null,\"appl.link_os_version_full\":null,\"device.protected_mode\":null,\"device.advanced_security_mode\":null} --tls
				ECHO -------------------------------------------------
			)
		)
  
  ECHO.
  REM ** INCREMENT COUNT **
  SET /a count=!count!+1
)
ECHO ** Operation Complete **
ECHO.
PAUSE
GOTO MAIN

:SDKHELP
CLS
REM display all SDK commands
%JRE_HOME%\bin\java -jar sdk\ZSDK_API.jar
PAUSE
GOTO MAIN

:SDKHELPSPECIFIC
CLS
REM display all SDK commands
%JRE_HOME%\bin\java -jar sdk\ZSDK_API.jar
ECHO.
SET /P "_sdkfunction=Enter an SDK function to see detailed help and press <Enter> (default: discover): " || SET _sdkfunction=discover
CLS
ECHO.
REM display help for specific SDK command
%JRE_HOME%\bin\java -jar sdk\ZSDK_API.jar help !_sdkfunction!
PAUSE
GOTO MAIN

:SENDFILEMENU
ECHO.
SET /P "_fileToSend=Enter the path and filename of the file to send and press <Enter> (default !_defaultFileToSend!):" || SET _fileToSend=!_defaultFileToSend!

ECHO !_discomessage!
ECHO.
SET count=1
FOR /F "tokens=* USEBACKQ" %%F IN (!_discoverytype!) DO (

  ECHO -------------------------------------------------

  REM start try connection
  ECHO Attempting connection to printer at %%F using TLS ... 
  SET scount=1
  FOR /F "delims=^" %%S in ('%JRE_HOME%\bin\java -jar sdk\ZSDK_API.jar status %%F --tls') DO (
     SET _status!scount!=%%S
   	 SET /a scount=!scount!+1
   )
   REM end try connection

		REM start display message
		SET "_prefix=!_status1:~0,27!"
		IF "!_prefix!"=="Could not connect to device" (
			ECHO TLS connection to printer failed: !_status1!
			ECHO This printer likely isn't running Link-OS 7.4.2 or later.
  			ECHO -------------------------------------------------
     	) ELSE (
			REM Continue for any other status			
			REM Check for not a Link-OS printer
			IF "!_status1!"=="This is not a Link-OS printer" (
				ECHO Connection successful. Response: !_status1!
				ECHO This maybe Link-OS Basic printer.
				ECHO -------------------------------------------------
			) ELSE (
				ECHO Connection successful. Printer Status: !_status1!
				ECHO Checking Advanced Security Mode ...
				SET _asm=EMPTY
				FOR /F tokens^=4^ delims^=^" %%M in ('%JRE_HOME%\bin\java -jar sdk\ZSDK_API.jar sendJSON %%F {}{\"device.advanced_security_mode\":null} --tls') DO (
				SET _asm=%%M)
				IF !_asm!==advanced (     	
					REM device.advanced_security_mode SGD is advanced
					ECHO Advanced Security Mode value is: !_asm!.
					ECHO Sending file !_fileToSend! to %%F ...
					"%JRE_HOME%"\bin\java -jar sdk\ZSDK_API.jar send %%F !_fileToSend! --tls
				) ELSE (
					IF !_asm!==EMPTY (
						REM device.advanced_security_mode SGD does not exist
						ECHO No Advanced Security Mode value returned.
						ECHO This printer is likely running a Link-OS version prior to 7.4.2.
						ECHO Not sending file.
						ECHO -------------------------------------------------				
					) ELSE (
						REM device.advanced_security_mode SGD value is returned but not advanced.
						ECHO Advanced Security Mode value is: !_asm!.
						ECHO This is likely an upgraded printer and not shipped in EU Red configuration.
						ECHO Not sending file.
						ECHO -------------------------------------------------
					)
				)
			)
		)
		REM end display message

  ECHO.
  REM increment count
  SET /a count=!count!+1
)

ECHO ** Operation Complete **
ECHO.
PAUSE
GOTO MAIN

:GETPRINTERSTATUS
CLS
ECHO Menu Option: Test a single printer using port 9100
ECHO.
SET /P "_printeraddress=Enter the printer IP address and press <Enter> (default !_defaultaddress!): " || SET _printeraddress=!_defaultaddress!
ECHO Checking printer at !_printeraddress!
ECHO.
REM Force tcp connection on port 9100
%JRE_HOME%\bin\java -jar sdk\ZSDK_API.jar status !_printeraddress!:9100 --tcp -v
ECHO.
PAUSE
GOTO MAIN

:CUSTOMCOMMAND
CLS
ECHO.
%JRE_HOME%\bin\java -jar sdk\ZSDK_API.jar
ECHO.
SET /P "_sdkcommand=Enter one of the SDK commands listed above : "
%JRE_HOME%\bin\java -jar sdk\ZSDK_API.jar help !_sdkcommand!
ECHO.
SET /P "_sdkparameters=Enter the any command parameters (see examples) : "
%JRE_HOME%\bin\java -jar sdk\ZSDK_API.jar !_sdkcommand! !_sdkparameters! -v
ECHO.
PAUSE
GOTO MAIN

:LAUNCHASRPAGE
START https://www.zebra.com/asr
GOTO MAIN

:QUIT
EXIT
PAUSE
