/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLSocketClient {
    private static final String[] protocols = new String[]{"TLSv1.2"};

    public static void main(String[] args) throws Exception {
        String version = "v1.0.2";
        try {
            Integer inputLine;
            if (args.length < 3) {
                System.out.println("Zebra Technologies TLS Demo " + version);
                System.out.println("Error: Missing argument(s): 3 expected");
                System.out.println("Usage: SSLSocketClient address port [send | receive]");
                System.out.println("Example: SSLSocketClient 192.168.1.100 9143 receive");
                System.exit(0);
            }
            String address = args[0];
            String port = args[1];
            String action = args[2];
            System.out.println("Zebra Technologies TLS Demo " + version);
            System.out.println("Connecting ....");
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            SSLSocketFactory factory = sslContext.getSocketFactory();
            SSLSocket socket = (SSLSocket)factory.createSocket(address, Integer.parseInt(port));
            socket.setEnabledProtocols(protocols);
            System.out.println("Connected. Sending/Retrieving data ...");
            String zplCommand = "";
            switch (action) {
                case "receive": {
                    zplCommand = "^XA^HH^XZ";
                    break;
                }
                case "send": {
                    System.out.println("Sent to printer:");
                    zplCommand = "^XA^MMT^PW406^LL365^LS0^FT97,56^A0N,25,25^FB212,1,6,C^FH\\^CI28^FDZebra Technologies^FS^CI27^FT97,87^A0N,25,25^FB212,1,6,C^FH\\^CI28^FDTLS Demo^FS^CI27^FT97,178^A0N,25,25^FH\\^CI28^FDPatient Information:^FS^CI27^FT84,230^A0N,25,25^FB89,1,6,R^FH\\^CI28^FDName :^FS^CI27^FT84,261^A0N,25,25^FB89,1,6,R^FH\\^CI28^FDD.O.B. :^FS^CI27^FT212,230^A0N,25,25^FH\\^CI28^FDJohn Doe^FS^CI27^FT212,261^A0N,25,25^FH\\^CI28^FD29/09/1978^FS^CI27^FO32,126^GB343,167,8^FS^PQ1,0,1,Y^XZ\r\n~HQSN";
                    break;
                }
                default: {
                    zplCommand = "~WC";
                    System.out.println("Error: No action parameter specified");
                    System.out.println("Usage: SSLSocketClient address port [send | receive | command] (zpl commands)");
                    System.exit(0);
                }
            }
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())));
            out.println(zplCommand);
            out.println();
            out.flush();
            if (out.checkError()) {
                System.out.println("SSLSocketClient:  java.io.PrintWriter error");
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((inputLine = Integer.valueOf(in.read())) != 3) {
                if (inputLine <= 4) continue;
                System.out.print(Character.toChars(inputLine));
            }
            in.close();
            out.close();
            socket.close();
            System.out.println("\r\nFinished!");
            System.exit(0);
        }
        catch (Exception e) {
            switch (e.getMessage()) {
                case "Connection timed out: connect": {
                    System.out.println("Error: " + e.getMessage());
                    System.out.println("Check the printer is online and the IP address is correct.");
                    break;
                }
                case "Connection refused: connect": {
                    System.out.println("Error: " + e.getMessage());
                    System.out.println("Check the certificate is stored on the printer.");
                    break;
                }
                default: {
                    e.printStackTrace();
                }
            }
        }
    }
}

