/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm;

import com.zebra.sdk.comm.ConnectionA;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.IpAddressable;
import com.zebra.sdk.comm.TcpZebraConnectorImpl;
import com.zebra.sdk.comm.internal.ConnectionI;
import com.zebra.sdk.comm.internal.ConnectionInfo;
import com.zebra.sdk.comm.internal.NotMyConnectionDataException;
import com.zebra.sdk.comm.internal.TcpConnectionReestablisher;
import com.zebra.sdk.comm.internal.ZebraConnector;
import com.zebra.sdk.util.internal.IPv6Util;
import com.zebra.sdk.util.internal.ReflectionUtil;
import com.zebra.sdk.util.internal.RegexUtil;
import java.util.ArrayList;
import java.util.List;

public class TcpConnection
extends ConnectionA
implements IpAddressable,
ConnectionI {
    public static final int DEFAULT_ZPL_TCP_PORT = 9100;
    public static final int DEFAULT_CPCL_TCP_PORT = 6101;
    public boolean isCardPrinter;
    public String serialNumber;

    protected TcpConnection(ConnectionInfo connectionInfo) throws NotMyConnectionDataException {
        String string;
        String string2;
        boolean bl;
        List<Object> list;
        block18: {
            String string3;
            String string4;
            block19: {
                int n;
                block16: {
                    block17: {
                        this.isCardPrinter = false;
                        this.serialNumber = "";
                        list = new ArrayList<String>();
                        bl = false;
                        string2 = "";
                        string = connectionInfo.getMyData();
                        string2 = IPv6Util.getZoneId(string);
                        string = string.replace(string2, "");
                        if (!string.contains("[")) break block16;
                        if (!string.contains(this.getConnectionBuilderPrefix())) break block17;
                        string4 = string.substring(this.getConnectionBuilderPrefix().length() + 1);
                        if (string4.charAt(0) != '[') break block18;
                        list = IPv6Util.getAddressAndPort(string4);
                        break block19;
                    }
                    if (string.charAt(0) == '[') {
                        list = IPv6Util.getAddressAndPort(string);
                    }
                    break block19;
                }
                if (IPv6Util.isIPv6Address(string)) {
                    list.add(string);
                } else if (string.contains(this.getConnectionBuilderPrefix()) && IPv6Util.isIPv6Address(string3 = string.substring((n = string.indexOf(this.getConnectionBuilderPrefix())) + this.getConnectionBuilderPrefix().length() + 1))) {
                    list.add(string3);
                }
            }
            if (list.size() > 0) {
                bl = true;
            } else {
                string4 = "^\\s*((?i)" + this.getConnectionBuilderPrefix() + ":)?([\\d]{1,3}.[\\d]{1,3}.[\\d]{1,3}.[\\d]{1,3})(:([\\d]{1,5}))?\\s*$";
                list = RegexUtil.getMatches(string4, string);
                if (list.size() <= 0) {
                    if (string.contains("zebra.com/apps/r/nfc?") && string.contains("mB=")) {
                        throw new NotMyConnectionDataException("TCP Connection doesn't understand " + string);
                    }
                    string3 = "^\\s*((?i)" + this.getConnectionBuilderPrefix() + ":)?([^:]+)(:([\\d]{1,5}))?\\s*$";
                    list = RegexUtil.getMatches(string3, string);
                    if (list.size() <= 0) {
                        throw new NotMyConnectionDataException(this.getConnectionBuilderPrefix() + " Connection doesn't understand " + string);
                    }
                }
            }
        }
        string = "";
        int n = this.getDefaultPort();
        if (bl) {
            string = (String)list.get(0);
            if (!string2.isEmpty()) {
                string = string + string2;
            }
            try {
                n = Integer.parseInt((String)list.get(1));
            }
            catch (Exception exception) {}
        } else {
            string = (String)list.get(2);
            try {
                n = Integer.parseInt((String)list.get(4));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.zebraConnector = new TcpZebraConnectorImpl(string, n);
        this.maxTimeoutForRead = 5000;
        this.timeToWaitForMoreData = 500;
    }

    protected int getDefaultPort() {
        return 9100;
    }

    protected String getConnectionBuilderPrefix() {
        return "TCP";
    }

    public TcpConnection(String string, int n) {
        this(string, n, 5000, 500);
    }

    public TcpConnection(String string, int n, int n2, int n3) {
        this(new TcpZebraConnectorImpl(string, n), n2, n3);
    }

    private TcpConnection(ZebraConnector zebraConnector, int n, int n2) {
        this.isCardPrinter = false;
        this.serialNumber = "";
        this.zebraConnector = zebraConnector;
        this.maxTimeoutForRead = n;
        this.timeToWaitForMoreData = n2;
    }

    @Override
    public String toString() {
        String string = this.getAddress();
        if (IPv6Util.isIPv6Address(string) && !string.startsWith("[")) {
            string = "[" + string + "]";
        }
        return "TCP:" + string + ":" + this.getPortNumber();
    }

    @Override
    public String getSimpleConnectionName() {
        return this.getAddress();
    }

    @Override
    public String getAddress() {
        return ((TcpZebraConnectorImpl)this.zebraConnector).getAddress();
    }

    @Override
    public String getPortNumber() {
        return String.valueOf(((TcpZebraConnectorImpl)this.zebraConnector).getPort());
    }

    @Override
    public ConnectionReestablisher getConnectionReestablisher(long l) throws ConnectionException {
        if (this.isCardPrinter) {
            return ReflectionUtil.loadTcpCardConnectionReestablisher(this, l);
        }
        return new TcpConnectionReestablisher(this, l);
    }
}

