/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.internal.ConnectionInfo;
import com.zebra.sdk.printer.internal.VerbosePrinter;
import com.zebra.sdk.util.internal.Sleeper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ConnectionBuilderInternal {
    private static final String MULTICHANNEL_BLUETOOTH_CONNECTION = "com.zebra.sdk.comm.MultichannelBluetoothConnection";
    private static final String BLUETOOTH_CONNECTION_INSECURE = "com.zebra.sdk.comm.BluetoothConnectionInsecure";
    private static final String BLUETOOTH_CONNECTION = "com.zebra.sdk.comm.BluetoothConnection";
    private static final String BLUETOOTH_STATUS_CONNECTION_INSECURE = "com.zebra.sdk.comm.BluetoothStatusConnectionInsecure";
    private static final String BLUETOOTH_STATUS_CONNECTION = "com.zebra.sdk.comm.BluetoothStatusConnection";
    public static Set<Class<?>> implementingClasses = null;
    private static boolean isConnBuilderVerbose = false;

    public static void setConnBuilderVerbosity(boolean bl) {
        isConnBuilderVerbose = bl;
    }

    public static boolean isConnBuilderVerbose() {
        return isConnBuilderVerbose;
    }

    public static Connection build(String string) throws ConnectionException {
        if (implementingClasses == null) {
            throw new RuntimeException("Builder not correctly implemented");
        }
        string = ConnectionBuilderInternal.formatTcpConnection(string);
        VerbosePrinter verbosePrinter = new VerbosePrinter(isConnBuilderVerbose);
        verbosePrinter.println("Building connection for the string \"" + string + "\"");
        ConnectionInfo connectionInfo = new ConnectionInfo(string);
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        Connection connection = null;
        for (Class<?> clazz : implementingClasses) {
            try {
                connection = ConnectionBuilderInternal.reflectivelyInstatiateConnection(connectionInfo, clazz);
                arrayList.add(connection);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ConnectionException(clazz.getName() + " does not implement a constructor that takes a ConnectionInfo object");
            }
            catch (Exception exception) {
                throw new ConnectionException(exception.getMessage());
            }
        }
        if (arrayList.isEmpty()) {
            verbosePrinter.println("Could not determine connection type of the value \"" + string + "\"");
            throw new ConnectionException("Invalid connection type");
        }
        if (arrayList.size() == 1) {
            verbosePrinter.println("Determined connection string \"" + string + "\" is of type " + ((Connection)arrayList.get(0)).getClass().getSimpleName());
            return (Connection)arrayList.get(0);
        }
        Connection connection2 = ConnectionBuilderInternal.determineConnectionToTry(arrayList, verbosePrinter);
        if (connection2 == null) {
            throw new ConnectionException("Could not open connection string \"" + string + "\"");
        }
        verbosePrinter.println("Success!" + System.getProperty("line.separator"));
        return connection2;
    }

    public static String formatTcpConnection(String string) {
        String string2;
        if (string == null || !string.toUpperCase().startsWith("TCP:")) {
            return string;
        }
        String string3 = string.substring(4).trim();
        String string4 = "";
        if (string3.matches("\\d+\\.\\d+\\.\\d+\\.\\d+:\\d+")) {
            return string;
        }
        if (string3.matches("\\[[^]]+\\]:\\d+")) {
            return string;
        }
        int n = string3.lastIndexOf(58);
        boolean bl = false;
        if (n > 0 && string3.indexOf(93) < 0 && (string2 = string3.substring(n + 1)).matches("\\d+")) {
            string4 = string2;
            string3 = string3.substring(0, n);
            bl = true;
        }
        String string5 = !string3.startsWith("[") && string3.contains(":") ? "[" + string3 + "]" : string3;
        if (string4.isEmpty()) {
            string4 = "9100";
        }
        return "TCP:" + string5 + ":" + string4;
    }

    private static Connection reflectivelyInstatiateConnection(ConnectionInfo connectionInfo, Class<?> clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = clazz.getDeclaredConstructor(ConnectionInfo.class);
        constructor.setAccessible(true);
        return (Connection)constructor.newInstance(connectionInfo);
    }

    private static Connection determineConnectionToTry(List<Connection> list, VerbosePrinter verbosePrinter) {
        verbosePrinter.println(ConnectionBuilderInternal.createClassesToTestMessage(list));
        Connection connection = null;
        for (Connection connection2 : list) {
            try {
                verbosePrinter.print("Trying " + connection2.getClass().getSimpleName() + "... ");
                connection2.open();
                connection2.close();
                String string = connection2.getClass().getName();
                if (string.equals(MULTICHANNEL_BLUETOOTH_CONNECTION) || string.equals(BLUETOOTH_CONNECTION_INSECURE) || string.equals(BLUETOOTH_CONNECTION) || string.equals(BLUETOOTH_STATUS_CONNECTION_INSECURE) || string.equals(BLUETOOTH_STATUS_CONNECTION)) {
                    Sleeper.sleep(3000L);
                }
                connection = connection2;
                break;
            }
            catch (ConnectionException connectionException) {
                verbosePrinter.println("Failed - " + connectionException.getLocalizedMessage());
            }
        }
        return connection;
    }

    private static String createClassesToTestMessage(List<Connection> list) {
        String string = "The following are possible connection types:" + System.getProperty("line.separator");
        for (Connection connection : list) {
            String string2 = connection.getClass().getSimpleName();
            string = string + "   " + string2 + System.getProperty("line.separator");
        }
        return string;
    }

    private static void reflectivelyLoadImplementingClasses() {
        try {
            Class<?> clazz = Class.forName("com.zebra.sdk.comm.ConnectionBuilder");
            Method method = clazz.getDeclaredMethod("initializeClasses", new Class[0]);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addConnectionType(Class<? extends Connection> clazz) {
        if (implementingClasses == null) {
            implementingClasses = new LinkedHashSet();
        }
        implementingClasses.add(clazz);
    }

    public static void removeConnectionType(Class<? extends Connection> clazz) {
        implementingClasses.remove(clazz);
    }

    static {
        try {
            ConnectionBuilderInternal.reflectivelyLoadImplementingClasses();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

