/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionBuilder;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.OptionGroup;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.FontConverterZpl;
import com.zebra.sdk.printer.NotALinkOsPrinterException;
import com.zebra.sdk.printer.ZebraPrinter;
import com.zebra.sdk.printer.ZebraPrinterFactory;
import com.zebra.sdk.printer.ZebraPrinterLanguageUnknownException;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.util.internal.Range;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FilenameUtils;

public class ConvertFontCommand
extends Command {
    private static final Option TTF_OPTION = new Option("f", "ttf", "Convert as TTF");
    private static final Option TTE_OPTION = new Option("e", "tte", "Convert as TTE");
    private static final Option NAME_OPTION = new Option("n", "name", "Name of the font to be stored on the printer. Will default to E:FONT.[TTF|TTE]").addArg("pathName", true);
    private static final Option SAVE_OPTION = new Option("s", "save", "Save output to local file").addArg("filePath", true);
    private static final Option PRINTER_OPTION = new Option("p", "printer", "Printer to send the font").addArg("printerName", true);
    private static final int FONT_FILEPATH_INDEX = 0;
    private static final Range ARG_RANGE = new Range(0, 1);
    private static final String TTE = "tte";
    private static final String TTF = "ttf";

    public ConvertFontCommand() {
        this.options.add(NAME_OPTION);
        this.options.add(TTE_OPTION);
        this.options.add(TTF_OPTION);
        this.options.add(SAVE_OPTION);
        this.options.add(PRINTER_OPTION);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.groups.add(new OptionGroup().createGroup(TTF_OPTION, TTE_OPTION));
        this.groups.add(new OptionGroup().createGroup(PRINTER_OPTION, SAVE_OPTION));
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "convertfont";
    }

    @Override
    public String getDescription() {
        return "Converts a TTF/TTE font for storage on a Zebra Printer.";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        String string = this.determineTypeToSave(parsedArguments);
        InputStream inputStream = this.getFontInputStream(parsedArguments);
        String string2 = this.getConnectionString(parsedArguments);
        if (string2 != null) {
            this.sendFontToPrinter(parsedArguments, string, inputStream, string2);
        } else {
            this.sendFontToOutputStream(parsedArguments, string, inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFontToOutputStream(ParsedArguments parsedArguments, String string, InputStream inputStream) throws Exception {
        OutputStream outputStream = null;
        try {
            if (parsedArguments.containsOption(SAVE_OPTION)) {
                String string2 = parsedArguments.getOptionArgument(SAVE_OPTION);
                this.verboseFormatPrint("Saving font to file %s%n", string2);
                outputStream = new FileOutputStream(string2);
            } else {
                this.verbosePrint("Outputting font to system out.");
                outputStream = System.out;
            }
            if (string.equalsIgnoreCase(TTF)) {
                FontConverterZpl.saveAsTtfPrinterFont(inputStream, outputStream, this.getFontName(parsedArguments, TTF));
            } else if (string.equalsIgnoreCase(TTE)) {
                FontConverterZpl.saveAsTtePrinterFont(inputStream, outputStream, this.getFontName(parsedArguments, TTE));
            }
        }
        finally {
            if (outputStream instanceof FileOutputStream) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFontToPrinter(ParsedArguments parsedArguments, String string, InputStream inputStream, String string2) throws ConnectionException, ZebraPrinterLanguageUnknownException, IOException, NotALinkOsPrinterException {
        block8: {
            Connection connection = null;
            try {
                connection = ConnectionBuilder.build(string2);
                connection.open();
                ZebraPrinter zebraPrinter = ZebraPrinterFactory.getInstance(connection);
                ZebraPrinterLinkOs zebraPrinterLinkOs = ZebraPrinterFactory.createLinkOsPrinter(zebraPrinter);
                if (zebraPrinterLinkOs != null) {
                    if (string.equalsIgnoreCase(TTF)) {
                        this.verbosePrint("Sending TTF to printer.");
                        zebraPrinterLinkOs.downloadTtfFont(inputStream, this.getFontName(parsedArguments, TTF));
                    } else if (string.equalsIgnoreCase(TTE)) {
                        this.verbosePrint("Sending TTE to printer.");
                        zebraPrinterLinkOs.downloadTteFont(inputStream, this.getFontName(parsedArguments, TTE));
                    }
                    break block8;
                }
                throw new NotALinkOsPrinterException();
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
                inputStream.close();
            }
        }
    }

    private String getFontName(ParsedArguments parsedArguments, String string) {
        String string2 = parsedArguments.containsOption(NAME_OPTION) ? parsedArguments.getOptionArgument(NAME_OPTION) : this.getDefaultFontName(string);
        this.verboseFormatPrint("Font name %s%n", string2);
        return string2;
    }

    private String getDefaultFontName(String string) {
        return String.format("E:FONT.%s", string.toUpperCase());
    }

    private String getConnectionString(ParsedArguments parsedArguments) {
        if (parsedArguments.containsOption(PRINTER_OPTION)) {
            try {
                String string = parsedArguments.getOptionArgument(PRINTER_OPTION);
                return this.getConnectionFromArgs(parsedArguments, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private InputStream getFontInputStream(ParsedArguments parsedArguments) throws FileNotFoundException {
        String string = parsedArguments.getArg(0);
        if (string != null) {
            this.verboseFormatPrint("Reading from %s%n", string);
            return new FileInputStream(string);
        }
        this.verbosePrint("Reading from System in%n");
        return System.in;
    }

    private String determineTypeToSave(ParsedArguments parsedArguments) {
        if (parsedArguments.containsOption(TTE_OPTION)) {
            this.verboseFormatPrint("Coverting as %s%n", TTE);
            return TTE;
        }
        if (parsedArguments.containsOption(TTF_OPTION)) {
            this.verboseFormatPrint("Coverting as %s%n", TTF);
            return TTF;
        }
        if (parsedArguments.getArg(0) != null) {
            String string;
            String string2 = parsedArguments.getArg(0);
            if (string2.matches("^[A-Za-z]:[^\\\\/].*")) {
                string2 = string2.substring(0, 2) + "\\" + string2.substring(2);
            }
            if ((string = FilenameUtils.getExtension((String)string2)).equalsIgnoreCase(TTE)) {
                this.verboseFormatPrint("Coverting as %s%n", TTE);
                return TTE;
            }
            if (string.equalsIgnoreCase(TTF)) {
                this.verboseFormatPrint("Coverting as %s%n", TTF);
                return TTF;
            }
        }
        this.verboseFormatPrint("Coverting as %s%n", TTF);
        return TTF;
    }

    @Override
    protected Range getExpectedArgRange() {
        return ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <fontFile> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Convert a font file\n");
        stringBuilder.append(String.format("\t%s %s /path/to/my/font.tte%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Convert a font file as TTF and store onto a printer, named E:ASDF.TTF\n");
        stringBuilder.append(String.format("\t%s %s /path/to/my/font.ttf --%s --%s 1.2.3.4 --%s E:ASDF.TTF%n", "java -jar ZSDK_API.jar", this.getCommandName(), TTF_OPTION.getLongName(), PRINTER_OPTION.getLongName(), NAME_OPTION.getLongName()));
        stringBuilder.append("Convert a font as a TTE and save to local file system\n");
        stringBuilder.append(String.format("\t%s %s /path/to/font.tte --%s --%s convertedFont.zpl%n", "java -jar ZSDK_API.jar", this.getCommandName(), TTE_OPTION.getLongName(), SAVE_OPTION.getLongName()));
        stringBuilder.append("Convert a font file as TTF and store onto a printer via ZDesigner Driver, named E:ASDF.TTF\n");
        stringBuilder.append(String.format("\t%s %s /path/to/my/font.ttf --%s --%s \"ZDesigner QLn420\" --%s --%s E:ASDF.TTF%n", "java -jar ZSDK_API.jar", this.getCommandName(), TTF_OPTION.getLongName(), PRINTER_OPTION.getLongName(), ZebraCommandConstants.DRIVER_OPTION.getLongName(), NAME_OPTION.getLongName()));
        stringBuilder.append("Convert a font file as TTF and store onto a printer via Driverless USB, named E:ASDF.TTF\n");
        stringBuilder.append(String.format("\t%s %s /path/to/my/font.ttf --%s --%s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\"  --%s E:ASDF.TTF%n", "java -jar ZSDK_API.jar", this.getCommandName(), TTF_OPTION.getLongName(), PRINTER_OPTION.getLongName(), NAME_OPTION.getLongName()));
        return stringBuilder.toString();
    }
}

