/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.PrinterUtil;
import com.zebra.sdk.util.internal.Range;
import java.io.File;
import java.io.FileInputStream;

public class SendDataCommand
extends Command {
    private static final Option ENCODING_OPTION = new Option("e", "encoding", "Sets the transfer encoding, defaults to UTF8. Accepts all types supported by java.io API").addArg("type", true);
    private static final Range ARG_RANGE = new Range(1, 2);
    private static final String DEFAULT_ENCODING = "UTF8";
    private static final int CONNECTION_ARG_INDEX = 0;
    private static final int DATA_ARG_INDEX = 1;

    public SendDataCommand() {
        this.options.add(ENCODING_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "send";
    }

    @Override
    public String getDescription() {
        return "Sends data to the raw port on the printer";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        String string = parsedArguments.getArg(1);
        String string2 = parsedArguments.getArg(0);
        if (string != null) {
            File file = new File(string);
            if (file.exists()) {
                this.verboseFormatPrint("Sending data from file %s%n", string);
                PrinterUtil.sendContents(this.getConnectionFromArgs(parsedArguments, string2), new FileInputStream(file), this.getEncoding(parsedArguments));
            } else {
                this.verbosePrint("Sending data");
                PrinterUtil.sendContents(this.getConnectionFromArgs(parsedArguments, string2), string, this.getEncoding(parsedArguments));
            }
        } else {
            this.verbosePrint("Reading from system in");
            PrinterUtil.sendContents(this.getConnectionFromArgs(parsedArguments, string2), System.in, this.getEncoding(parsedArguments));
        }
    }

    private String getEncoding(ParsedArguments parsedArguments) {
        return parsedArguments.containsOption(ENCODING_OPTION) ? parsedArguments.getOptionArgument(ENCODING_OPTION) : DEFAULT_ENCODING;
    }

    @Override
    protected Range getExpectedArgRange() {
        return ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> <data/file> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Send a ~WC to a printer with IPv4 address\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 ~WC%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Send a ~WC to a printer with IPv6 address\n");
        stringBuilder.append(String.format("\t%s %s fe80:0:0:0:4aa4:93ff:fefa:3a64 ~WC%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Send a ~WC to a printer with IPv6 address via port nnnn\n");
        stringBuilder.append(String.format("\t%s %s [fe80::4aa4:93ff:fefa:3a64]:9100 ~WC%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Send data to a printer with IPv4 address from a file as ASCII.\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 /path/to/my/file.txt -e ASCII%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Send data to a printer with IPv6 address from a file as ASCII.\n");
        stringBuilder.append(String.format("\t%s %s fe80::4aa4:93ff:fefa:3a64 /path/to/my/file.txt -e ASCII%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Send data to a printer via ZDesigner Driver\n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" /path/to/my/file.txt --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.DRIVER_OPTION.getLongName()));
        stringBuilder.append("Send data to a printer with IPv4 address via port nnnn using verbose mode\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4:9100 /path/to/my/file.txt --%s --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.TCP_OPTION.getLongName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Send data to a printer via Driverless USB\n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" /path/to/my/file.txt%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        return stringBuilder.toString();
    }
}

