/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery.internal;

import com.zebra.sdk.printer.discovery.DiscoveredPrinterNetwork;
import com.zebra.sdk.printer.discovery.DiscoveryPacketDecodeException;
import com.zebra.sdk.printer.discovery.internal.DiscoveredPrinterLanguage;
import com.zebra.sdk.printer.discovery.internal.IPAquisitionProtocol;
import com.zebra.sdk.printer.discovery.internal.NetworkProtocol;
import com.zebra.sdk.printer.discovery.internal.PrintMethod;
import com.zebra.sdk.printer.discovery.internal.PrintMode;
import com.zebra.sdk.printer.discovery.internal.PrinterError;
import com.zebra.sdk.printer.discovery.internal.PrinterInterface;
import com.zebra.sdk.printer.discovery.internal.PrinterMediaType;
import com.zebra.sdk.printer.discovery.internal.PrinterPortStatus;
import com.zebra.sdk.printer.discovery.internal.PrinterWarning;
import com.zebra.sdk.printer.discovery.internal.SecondaryPrinterLanguage;
import com.zebra.sdk.printer.discovery.internal.SupportedFeatures;
import com.zebra.sdk.printer.discovery.internal.Wired8021xSecuritySetting;
import com.zebra.sdk.printer.discovery.internal.ZbiState;
import com.zebra.sdk.util.internal.Base64;
import com.zebra.sdk.util.internal.PacketParsingUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class DiscoveryPacketDecoderAdvanced {
    private static final int DISCOVERY_VERSION_OFFSET = 3;
    private static final int ADVANCED_PACKET_FORMAT_OFFSET = 4;
    private static final int COMPANY_ABBERVIATION_OFFSET = 8;
    private static final int COMPANY_ABBERVIATION_SIZE = 5;
    private static final int SYSTEM_NAME_OFFSET = 13;
    private static final int SYSTEM_NAME_SIZE = 63;
    private static final int PRODUCT_NAME_OFFSET = 76;
    private static final int PRODUCT_NAME_SIZE = 32;
    private static final int FW_VERSION_OFFSET = 108;
    private static final int FW_VERSION_SIZE = 16;
    private static final int LOCATION_OFFSET = 124;
    private static final int LOCATION_SIZE = 36;
    private static final int ERRORS_SEGMENT0_OFFSET = 160;
    private static final int ERRORS_SEGMENT0_SIZE = 4;
    private static final int ERRORS_SEGMENT1_OFFSET = 164;
    private static final int ERRORS_SEGMENT1_SIZE = 4;
    private static final int ERRORS_SEGMENT2_OFFSET = 168;
    private static final int ERRORS_SEGMENT2_SIZE = 4;
    private static final int WARNINGS_SEGMENT0_OFFSET = 172;
    private static final int WARNINGS_SEGMENT0_SIZE = 4;
    private static final int WARNINGS_SEGMENT1_OFFSET = 176;
    private static final int WARNINGS_SEGMENT1_SIZE = 4;
    private static final int WARNINGS_SEGMENT2_OFFSET = 180;
    private static final int WARNINGS_SEGMENT2_SIZE = 4;
    private static final int AVAILABLE_INTERFACES_BITFIELD_OFFSET = 184;
    private static final int AVAILABLE_INTERFACES_BITFIELD_SIZE = 4;
    private static final int DEVICE_UNIQUE_ID_OFFSET = 188;
    private static final int DEVICE_UNIQUE_ID_SIZE = 32;
    private static final int DNS_DOMAIN_OFFSET = 220;
    private static final int DNS_DOMAIN_SIZE = 100;
    private static final int ACTIVE_INTERFACE_OFFSET = 320;
    private static final int ACTIVE_INTERFACE_SIZE = 4;
    private static final int MAC_ADDRESS_OFFSET = 324;
    private static final int MAC_ADDRESS_SIZE = 6;
    private static final int IP_ACQUISITION_PROTO_OFFSET = 330;
    private static final int IP_ACQUISITION_PROTO_SIZE = 2;
    private static final int IP_ADDRESS_OFFSET = 332;
    private static final int IP_ADDRESS_SIZE = 4;
    private static final int SUBNET_MASK_OFFSET = 336;
    private static final int SUBNET_MASK_SIZE = 4;
    private static final int GATEWAY_MASK_OFFSET = 340;
    private static final int GATEWAY_MASK_SIZE = 4;
    private static final int PORT_OFFSET = 344;
    private static final int PORT_SIZE = 2;
    private static final int AVAILABLE_PROTOCOLS_OFFSET = 346;
    private static final int AVAILABLE_PROTOCOLS_SIZE = 2;
    private static final int PRIMARY_LANGUAGE_OFFSET = 348;
    private static final int PRIMARY_LANGUAGE_SIZE = 4;
    private static final int AVAILABLE_LANGUAGES_BITFIELD_OFFSET = 352;
    private static final int AVAILABLE_LANGUAGES_BITFIELD_SIZE = 4;
    private static final int AVAILABLE_SECONDARY_LANGUAGES_BITFIELD_OFFSET = 356;
    private static final int AVAILABLE_SECONDARY_LANGUAGES_BITFIELD_SIZE = 4;
    private static final int DOTS_PER_MM_OFFSET = 360;
    private static final int DOTS_PER_MM_SIZE = 2;
    private static final int DOTS_PER_DOT_ROW_OFFSET = 362;
    private static final int DOTS_PER_DOT_ROW_SIZE = 2;
    private static final int LABEL_LENGTH_OFFSET = 364;
    private static final int LABEL_LENGTH_SIZE = 2;
    private static final int LABEL_WIDTH_OFFSET = 366;
    private static final int LABEL_WIDTH_SIZE = 2;
    private static final int DARKNESS_OFFSET = 368;
    private static final int DARKNESS_SIZE = 2;
    private static final int MEDIA_TYPE_OFFSET = 370;
    private static final int MEDIA_TYPE_SIZE = 2;
    private static final int PRINT_METHOD_OFFSET = 372;
    private static final int PRINT_METHOD_SIZE = 2;
    private static final int PRINT_MODE_OFFSET = 374;
    private static final int PRINT_MODE_SIZE = 2;
    private static final int ODOMETER_TOTAL_OFFSET = 376;
    private static final int ODOMETER_TOTAL_SIZE = 4;
    private static final int ODOMETER_MARKER_ONE_OFFSET = 380;
    private static final int ODOMETER_MARKER_ONE_SIZE = 4;
    private static final int ODOMETER_MARKER_TWO_OFFSET = 384;
    private static final int ODOMETER_MARKER_TWO_SIZE = 4;
    private static final int NUM_OF_LABELS_IN_BATCH_OFFSET = 388;
    private static final int NUM_OF_LABELS_IN_BATCH_SIZE = 2;
    private static final int LABELS_QUEUED_OFFSET = 390;
    private static final int LABELS_QUEUED_SIZE = 2;
    private static final int ZBI_ENABLED_OFFSET = 392;
    private static final int ZBI_ENABLED_SIZE = 1;
    private static final int ZBI_STATE_OFFSET = 393;
    private static final int ZBI_STATE_SIZE = 1;
    private static final int ZBI_MAJOR_VERSION_OFFSET = 394;
    private static final int ZBI_MINOR_VERSION_OFFSET = 395;
    private static final int PRINT_HEAD_WIDTH_OFFSET = 396;
    private static final int PRINT_HEAD_WIDTH_SIZE = 2;
    private static final int JSON_PORT_OFFSET = 398;
    private static final int JSON_PORT_SIZE = 2;
    private static final int LINK_OS_MAJOR_VER_OFFSET = 400;
    private static final int LINK_OS_MINOR_VER_OFFSET = 401;
    private static final int AVS_INI_VERSION_OFFSET = 402;
    private static final int AVS_INI_VERSION_SIZE = 6;
    private static final int PROCESSOR_ID_OFFSET = 408;
    private static final int PROCESSOR_ID_SIZE = 8;
    private static final int TLS_RAW_PORT_OFFSET = 416;
    private static final int TLS_RAW_PORT_SIZE = 2;
    private static final int TLS_JSON_PORT_OFFSET = 418;
    private static final int TLS_JSON_PORT_SIZE = 2;
    private static final int WIRED_8021X_SECURITY_SETTING_OFFSET = 420;
    private static final int WIRED_8021X_SECURITY_SETTING_SIZE = 1;
    private static final int PROTECTED_MODE_OFFSET = 421;
    private static final int SUPPORTED_NETWORK_PROTOCOLS_OFFEST = 422;
    private static final int SUPPORTED_NETWORK_PROTOCOLS_SIZE = 2;
    private static final int SUPPORTED_FEATURES_OFFSET = 424;
    private static final int SUPPORTED_FEATURES_SIZE = 2;
    private static final int LINK_OS_BASIC_MAJOR_VER_OFFSET = 426;
    private static final int LINK_OS_BASIC_MINOR_VER_OFFSET = 427;
    private static final int LINK_OS_MICRO_VER_OFFSET = 428;
    private static final int MIN_PACKET_SIZE = 395;
    private byte[] rawDiscoveryPacket = null;
    private String ipv6Address = null;

    public DiscoveryPacketDecoderAdvanced(byte[] byArray) {
        this.rawDiscoveryPacket = byArray;
    }

    public DiscoveryPacketDecoderAdvanced(byte[] byArray, String string) {
        this.ipv6Address = string;
        this.rawDiscoveryPacket = byArray;
    }

    public DiscoveredPrinterNetwork getDiscoveredPrinterNetworkAdvanced() throws DiscoveryPacketDecodeException {
        if (this.rawDiscoveryPacket.length < 395) {
            throw new DiscoveryPacketDecodeException("Unable to parse the supplied discovery packet due to an invalid discovery packet length");
        }
        return new DiscoveredPrinterNetwork(this.getDiscoveryDataMap());
    }

    public static void main(String[] stringArray) {
        byte[] byArray = Base64.decode("OiwuBAIBAAFaQlIAAFhYUUxWMTIzNAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFpUQyBRTG4yMjAtMjAzZHBpIENQQ0wAAAAAAAAAAAAAVjY4LjIwLjAyUDM0Nzc2LQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAW1YWFFMVjEyMzQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHplYnJhLmxhbgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAAdNRjzhAAAKUBYn////AApQFgEX1QH/AAAAAgAAAAcAAAADAAgR8AfuAKgAZAABAAAAAAAAAukAAAKaAAAnzgAAAAABAgIBAkAj8AQA");
        DiscoveryPacketDecoderAdvanced discoveryPacketDecoderAdvanced = new DiscoveryPacketDecoderAdvanced(byArray);
        ZbiState zbiState = discoveryPacketDecoderAdvanced.getZbiState();
        System.out.println((Object)zbiState);
    }

    private HashMap<String, String> getDiscoveryDataMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = this.getAdvancedDiscoveryVer();
        hashMap.put("DISCOVERY_VER", String.valueOf(this.getDiscoveryVersion()));
        hashMap.put("ADVANCED_DISCOVERY_VER", String.valueOf(n));
        hashMap.put("COMPANY_ABBREVIATION", this.getCompanyAbbreviation());
        hashMap.put("SYSTEM_NAME", this.getSystemName());
        hashMap.put("PRODUCT_NAME", this.getProductName());
        hashMap.put("FIRMWARE_VER", this.getFirmwareVersion());
        hashMap.put("LOCATION", this.getLocation());
        hashMap.put("ERRORS", this.iterateSetAndStringConcatValues(this.getErrors()));
        hashMap.put("WARNINGS", this.iterateSetAndStringConcatValues(this.getWarnings()));
        hashMap.put("ACTIVE_NETWORK_INTERFACE", this.getCurrentlyActiveNetworkInterface().toString());
        String string = this.getDeviceUniqueId();
        hashMap.put("SERIAL_NUMBER", string);
        hashMap.put("DEVICE_UNIQUE_ID", string);
        hashMap.put("DNS_DOMAIN", this.getDnsDomain());
        hashMap.put("HARDWARE_ADDRESS", this.getMacAddress());
        hashMap.put("USING_NET_PROTOCOL", this.getUsingNetProtocol() ? "true" : "false");
        hashMap.put("DNS_NAME", this.getSystemName());
        hashMap.put("IP_ACQUISITION_PROTOCOL", this.getIpAcquisitionProtocol().toString());
        if (this.ipv6Address != null) {
            hashMap.put("ADDRESS", this.ipv6Address);
        } else {
            hashMap.put("ADDRESS", this.getIpAddress());
        }
        hashMap.put("SUBNET_MASK", this.getSubnetMask());
        hashMap.put("GATEWAY", this.getGateway());
        hashMap.put("PORT_NUMBER", String.valueOf(this.getPort()));
        hashMap.put("AVAILABLE_NETWORK_PROTOCOLS", this.iterateSetAndStringConcatValues(this.getAvailableNetworkProtocols()));
        hashMap.put("AVAILABLE_INTERFACES", this.iterateSetAndStringConcatValues(this.getAvailableInterfaces()));
        hashMap.put("PRIMARY_LANGUAGE", this.getPrimaryLanguage().toString());
        hashMap.put("AVAILABLE_LANGUAGES", this.iterateSetAndStringConcatValues(this.getAvailableLanguages()));
        hashMap.put("SECONDARY_PRINTER_LANGUAGE", this.iterateSetAndStringConcatValues(this.getAvailableSecondaryLanguages()));
        hashMap.put("DOTS_PER_MM", String.valueOf(this.getDotsPerMM()));
        hashMap.put("DOTS_PER_ROW", String.valueOf(this.getDotsPerDotRow()));
        hashMap.put("LABEL_LENGTH", String.valueOf(this.getLabelLength()));
        hashMap.put("LABEL_WIDTH", String.valueOf(this.getLabelWidth()));
        hashMap.put("DARKNESS", String.valueOf(this.getDarkness()));
        hashMap.put("PRINTER_MEDIA_TYPE", this.getMediaType().toString());
        hashMap.put("PRINT_METHOD", this.getPrintMethod().toString());
        hashMap.put("PRINT_MODE", this.getPrintMode().toString());
        hashMap.put("ODOMETER_TOTAL_LABEL_COUNT", String.valueOf(this.getOdometerTotalLabelCount()));
        hashMap.put("ODOMETER_MEDIAMARKER_COUNT_ONE", String.valueOf(this.getOdometerMarkerCountOne()));
        hashMap.put("ODOMETER_MEDIAMARKER_COUNT_TWO", String.valueOf(this.getOdometerMarkerCountTwo()));
        hashMap.put("NUMBER_LABELS_REMAIN_IN_BATCH", String.valueOf(this.getNumberOfLabelsRemainingInBatch()));
        hashMap.put("NUMBER_LABELS_QUEUED", String.valueOf(this.getNumberOfLabelsQueued()));
        hashMap.put("ZBI_ENABLED", this.getZbiEnabled() ? "true" : "false");
        hashMap.put("ZBI_STATE", this.getZbiState().toString());
        hashMap.put("ZBI_MAJOR_VER", String.valueOf(this.getZbiMajorVersion()));
        hashMap.put("ZBI_MINOR_VER", String.valueOf(this.getZbiMinorVersion()));
        if (n >= 1) {
            hashMap.put("PRINT_HEAD_WIDTH", String.valueOf(this.getPrintHeadWidth()));
        }
        if (n >= 2) {
            hashMap.put("JSON_PORT_NUMBER", String.valueOf(this.getJsonPort()));
            hashMap.put("LINK_OS_MAJOR_VER", String.valueOf(this.getLinkOsMajorVer()));
            hashMap.put("LINK_OS_MINOR_VER", String.valueOf(this.getLinkOsMinorVer()));
        }
        if (n >= 3) {
            hashMap.put("AVS_INI_VER", this.getAvsIniVersion());
        }
        if (n >= 4) {
            hashMap.put("PROCESSOR_ID", this.getProcessorId());
            hashMap.put("TLS_RAW_PORT_NUMBER", String.valueOf(this.getTlsRawPortNumber()));
            hashMap.put("TLS_JSON_PORT_NUMBER", String.valueOf(this.getTlsJsonPortNumber()));
            hashMap.put("WIRED_8021X_SECURITY_SETTING", this.getWired8021xSecuritySetting().toString());
        }
        if (n >= 5) {
            hashMap.put("PROTECT_ENABLED", this.getProtectEnabled() ? "true" : "false");
            hashMap.put("FIRMWARE_DOWNLOAD_ENABLED", this.getAllowFirmwareDownload() ? "true" : "false");
        }
        if (n >= 6) {
            hashMap.put("SUPPORTED_NETWORK_PROTOCOLS", this.iterateSetAndStringConcatValues(this.getSupportedNetworkProtocols()));
            hashMap.put("SUPPORTED_FEATURES", this.iterateSetAndStringConcatValues(this.getSupportedFeatures()));
            hashMap.put("LINK_OS_BASIC_MAJOR_VER", String.valueOf(this.getLinkOsBasicMajorVer()));
            hashMap.put("LINK_OS_BASIC_MINOR_VER", String.valueOf(this.getLinkOsBasicMinorVer()));
        }
        if (n >= 8) {
            hashMap.put("LINK_OS_MICRO_VER", String.valueOf(this.getLinkOsMicroVer()));
        }
        hashMap.put("PORT_STATUS", this.getPortStatus().toString());
        hashMap.put("PRODUCT_NUMBER", "");
        hashMap.put("PORT_NAME", "");
        hashMap.put("DATE_CODE", "");
        return hashMap;
    }

    private boolean getUsingNetProtocol() {
        return this.getIpAcquisitionProtocol() != IPAquisitionProtocol.STATIC;
    }

    private String iterateSetAndStringConcatValues(Set<?> set) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    private Set<PrinterError> getErrors() {
        int n = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 160, 4);
        int n2 = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 164, 4);
        int n3 = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 168, 4);
        Set<PrinterError> set = PrinterError.getEnumSetFromBitmask(0, n);
        set.addAll(PrinterError.getEnumSetFromBitmask(1, n2));
        set.addAll(PrinterError.getEnumSetFromBitmask(2, n3));
        return set;
    }

    private Set<PrinterWarning> getWarnings() {
        int n = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 172, 4);
        int n2 = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 176, 4);
        int n3 = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 180, 4);
        Set<PrinterWarning> set = PrinterWarning.getEnumSetFromBitmask(0, n);
        set.addAll(PrinterWarning.getEnumSetFromBitmask(1, n2));
        set.addAll(PrinterWarning.getEnumSetFromBitmask(2, n3));
        return set;
    }

    private PrinterPortStatus getPortStatus() {
        Set<PrinterError> set = this.getErrors();
        if (set.contains((Object)PrinterError.HEAD_OPEN)) {
            return PrinterPortStatus.DOOR_OPEN;
        }
        if (set.contains((Object)PrinterError.MEDIA_OUT)) {
            return PrinterPortStatus.PAPER_OUT;
        }
        if (set.contains((Object)PrinterError.PAPER_FEED_ERROR)) {
            return PrinterPortStatus.PAPER_JAMMED;
        }
        if (set.size() == 0) {
            return PrinterPortStatus.ONLINE;
        }
        return PrinterPortStatus.PRINTER_ERROR;
    }

    private ZbiState getZbiState() {
        int n = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 393, 1);
        return ZbiState.intToEnum(n);
    }

    private int getZbiMinorVersion() {
        return this.rawDiscoveryPacket[395];
    }

    private int getZbiMajorVersion() {
        return this.rawDiscoveryPacket[394];
    }

    private boolean getZbiEnabled() {
        return PacketParsingUtil.parseBoolean(this.rawDiscoveryPacket, 392, 1);
    }

    private int getNumberOfLabelsQueued() {
        return PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 390, 2);
    }

    private int getNumberOfLabelsRemainingInBatch() {
        return PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 388, 2);
    }

    private int getOdometerMarkerCountTwo() {
        return PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 384, 4);
    }

    private int getOdometerMarkerCountOne() {
        return PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 380, 4);
    }

    private int getOdometerTotalLabelCount() {
        return PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 376, 4);
    }

    private PrintMode getPrintMode() {
        int n = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 374, 2);
        return PrintMode.intToEnum(n);
    }

    private PrintMethod getPrintMethod() {
        int n = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 372, 2);
        return PrintMethod.intToEnum(n);
    }

    private PrinterMediaType getMediaType() {
        int n = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 370, 2);
        return PrinterMediaType.intToEnum(n);
    }

    private short getDarkness() {
        return (short)PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 368, 2);
    }

    private short getLabelWidth() {
        return (short)PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 366, 2);
    }

    private short getLabelLength() {
        return (short)PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 364, 2);
    }

    private short getDotsPerDotRow() {
        return (short)PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 362, 2);
    }

    private short getDotsPerMM() {
        return (short)PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 360, 2);
    }

    private Set<SecondaryPrinterLanguage> getAvailableSecondaryLanguages() {
        int n = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 356, 4);
        return SecondaryPrinterLanguage.getEnumSetFromBitmask(n);
    }

    private Set<NetworkProtocol> getAvailableNetworkProtocols() {
        int n = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 346, 2);
        return NetworkProtocol.getEnumSetFromBitmask(n);
    }

    private Set<DiscoveredPrinterLanguage> getAvailableLanguages() {
        int n = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 352, 4);
        return DiscoveredPrinterLanguage.getEnumSetFromBitmask(n);
    }

    private DiscoveredPrinterLanguage getPrimaryLanguage() {
        int n = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 348, 4);
        return DiscoveredPrinterLanguage.intToEnum(n);
    }

    private int getPort() {
        return PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 344, 2);
    }

    private String getIpAddress() {
        return PacketParsingUtil.parseAddress(this.rawDiscoveryPacket, 332, 4);
    }

    private IPAquisitionProtocol getIpAcquisitionProtocol() {
        int n = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 330, 2);
        return IPAquisitionProtocol.intToEnum(n);
    }

    private String getMacAddress() {
        return PacketParsingUtil.parseGeneralByte(this.rawDiscoveryPacket, 324, 6);
    }

    private PrinterInterface getCurrentlyActiveNetworkInterface() {
        return this.parseNetworkInterface(this.rawDiscoveryPacket, 320, 4);
    }

    private String getDnsDomain() {
        return PacketParsingUtil.parseGeneralString(this.rawDiscoveryPacket, 220, 100);
    }

    private String getDeviceUniqueId() {
        return PacketParsingUtil.parseGeneralString(this.rawDiscoveryPacket, 188, 32);
    }

    private Set<PrinterInterface> getAvailableInterfaces() {
        int n = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 184, 4);
        return PrinterInterface.getEnumSetFromBitmask(n);
    }

    private String getLocation() {
        return PacketParsingUtil.parseGeneralString(this.rawDiscoveryPacket, 124, 36);
    }

    private String getFirmwareVersion() {
        return PacketParsingUtil.parseGeneralString(this.rawDiscoveryPacket, 108, 16);
    }

    private String getProductName() {
        return PacketParsingUtil.parseGeneralString(this.rawDiscoveryPacket, 76, 32);
    }

    private String getSystemName() {
        return PacketParsingUtil.parseGeneralString(this.rawDiscoveryPacket, 13, 63);
    }

    private String getCompanyAbbreviation() {
        return PacketParsingUtil.parseGeneralString(this.rawDiscoveryPacket, 8, 5);
    }

    private String getSubnetMask() {
        return PacketParsingUtil.parseAddress(this.rawDiscoveryPacket, 336, 4);
    }

    private String getGateway() {
        return PacketParsingUtil.parseAddress(this.rawDiscoveryPacket, 340, 4);
    }

    private int getDiscoveryVersion() {
        return PacketParsingUtil.byte2int(this.rawDiscoveryPacket[3]);
    }

    private int getPrintHeadWidth() {
        return PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 396, 2);
    }

    private int getJsonPort() {
        return PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 398, 2);
    }

    private int getLinkOsMajorVer() {
        return PacketParsingUtil.byte2int(this.rawDiscoveryPacket[400]);
    }

    private int getLinkOsMinorVer() {
        return PacketParsingUtil.byte2int(this.rawDiscoveryPacket[401]);
    }

    private String getAvsIniVersion() {
        return PacketParsingUtil.parseGeneralString(this.rawDiscoveryPacket, 402, 6);
    }

    private String getProcessorId() {
        return PacketParsingUtil.parseGeneralByte(this.rawDiscoveryPacket, 408, 8);
    }

    private int getTlsRawPortNumber() {
        return PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 416, 2);
    }

    private int getTlsJsonPortNumber() {
        return PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 418, 2);
    }

    private Wired8021xSecuritySetting getWired8021xSecuritySetting() {
        int n = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 420, 1);
        return Wired8021xSecuritySetting.intToEnum(n);
    }

    private int getAdvancedDiscoveryVer() {
        return PacketParsingUtil.byte2int(this.rawDiscoveryPacket[4]);
    }

    private PrinterInterface parseNetworkInterface(byte[] byArray, int n, int n2) {
        int n3 = PacketParsingUtil.parseInteger(byArray, n, n2);
        return PrinterInterface.intToEnum(n3);
    }

    private boolean getProtectEnabled() {
        return (this.rawDiscoveryPacket[421] >>> 0 & 1) != 0;
    }

    private boolean getAllowFirmwareDownload() {
        return (this.rawDiscoveryPacket[421] >>> 1 & 1) == 0;
    }

    private Set<NetworkProtocol> getSupportedNetworkProtocols() {
        int n = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 422, 2);
        return NetworkProtocol.getEnumSetFromBitmask(n);
    }

    private Set<SupportedFeatures> getSupportedFeatures() {
        int n = PacketParsingUtil.parseInteger(this.rawDiscoveryPacket, 424, 2);
        return SupportedFeatures.getEnumSetFromBitmask(n);
    }

    private int getLinkOsBasicMajorVer() {
        return PacketParsingUtil.byte2int(this.rawDiscoveryPacket[426]);
    }

    private int getLinkOsBasicMinorVer() {
        return PacketParsingUtil.byte2int(this.rawDiscoveryPacket[427]);
    }

    private int getLinkOsMicroVer() {
        return PacketParsingUtil.byte2int(this.rawDiscoveryPacket[428]);
    }
}

