/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.comm.internal.PrinterCommandImpl;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.DriveType;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.PrinterObjectProperties;
import com.zebra.sdk.printer.StorageInfo;
import com.zebra.sdk.printer.internal.FileUtilA;
import com.zebra.sdk.printer.internal.PrinterFilePropertiesList;
import com.zebra.sdk.printer.internal.PrinterFilePropertiesZpl;
import com.zebra.sdk.settings.internal.JsonHelper;
import com.zebra.sdk.util.internal.JacksonObjectMapperFactory;
import com.zebra.sdk.util.internal.ZPLUtilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileUtilZpl
extends FileUtilA {
    private static final String READ_ONLY = "READ ONLY";
    private static final String ONBOARD_FLASH = "ONBOARD FLASH";
    private static final String RAM = "RAM";

    public FileUtilZpl(Connection connection) {
        super(connection);
    }

    @Override
    public String[] retrieveFileNames() throws ConnectionException, ZebraIllegalArgumentException {
        PrinterFilePropertiesList printerFilePropertiesList = this.retrieveFilePropertiesFromPrinter();
        String[] stringArray = printerFilePropertiesList.getFileNamesFromProperties();
        return stringArray;
    }

    @Override
    public PrinterFilePropertiesList extractFilePropertiesFromDirResult(String string) throws ZebraIllegalArgumentException {
        PrinterFilePropertiesList printerFilePropertiesList = null;
        printerFilePropertiesList = string.trim().startsWith("<?xml version='1.0'?>\r\n<ZEBRA-ELTRON-PERSONALITY>") ? this.extractFilePropertiesFromHZLResponse(string) : (JsonHelper.isValidJson(string.getBytes()) ? this.extractFilePropertiesFromJsonFileDriveListingResponse(string) : super.extractFilePropertiesFromDirResult(string));
        return printerFilePropertiesList;
    }

    private PrinterFilePropertiesList extractFilePropertiesFromJsonFileDriveListingResponse(String string) {
        PrinterFilePropertiesList printerFilePropertiesList = new PrinterFilePropertiesList();
        ObjectMapper objectMapper = JacksonObjectMapperFactory.getInstance();
        MapType mapType = objectMapper.getTypeFactory().constructMapType(LinkedHashMap.class, String.class, FileObjectWithCrc32Data.class);
        MapType mapType2 = objectMapper.getTypeFactory().constructMapType(LinkedHashMap.class, objectMapper.getTypeFactory().constructType(String.class), (JavaType)mapType);
        MapType mapType3 = objectMapper.getTypeFactory().constructMapType(LinkedHashMap.class, objectMapper.getTypeFactory().constructType(String.class), (JavaType)mapType2);
        try {
            Map map = (Map)objectMapper.readValue(string, (JavaType)mapType3);
            Map map2 = (Map)map.get("file.drive_listing");
            for (Map.Entry entry : map2.entrySet()) {
                String string2 = (String)entry.getKey();
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    long l = ((FileObjectWithCrc32Data)entry2.getValue()).size;
                    long l2 = ((FileObjectWithCrc32Data)entry2.getValue()).crc32;
                    String string3 = (String)entry2.getKey();
                    if (string3.matches("^[A-Za-z]:[^\\\\/].*")) {
                        string3 = string3.substring(0, 2) + "\\" + string3.substring(2);
                    }
                    String string4 = FilenameUtils.removeExtension((String)string3);
                    String string5 = FilenameUtils.getExtension((String)string3);
                    PrinterFilePropertiesZpl printerFilePropertiesZpl = new PrinterFilePropertiesZpl(string2 + ":", string4, string5, l, l2);
                    printerFilePropertiesList.add(printerFilePropertiesZpl);
                }
            }
        }
        catch (IOException iOException) {
            new ConnectionException(iOException.getLocalizedMessage());
        }
        return printerFilePropertiesList;
    }

    private PrinterFilePropertiesList extractFilePropertiesFromHZLResponse(String string) throws ZebraIllegalArgumentException {
        PrinterFilePropertiesList printerFilePropertiesList = new PrinterFilePropertiesList();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.trim().getBytes());
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(byteArrayInputStream);
            NodeList nodeList = document.getElementsByTagName("OBJECT");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                NamedNodeMap namedNodeMap = node.getAttributes();
                String string2 = node.getFirstChild().getNodeValue();
                int n = 0;
                try {
                    n = Integer.parseInt(namedNodeMap.getNamedItem("SIZE").getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                printerFilePropertiesList.add(new PrinterFilePropertiesZpl(namedNodeMap.getNamedItem("MEMORY-LOCATION").getNodeValue(), string2, namedNodeMap.getNamedItem("TYPE").getNodeValue(), n));
            }
        }
        catch (SAXException sAXException) {
            throw new ZebraIllegalArgumentException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new ZebraIllegalArgumentException(iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ZebraIllegalArgumentException(parserConfigurationException.getMessage());
        }
        return printerFilePropertiesList;
    }

    @Override
    public String[] retrieveFileNames(String[] stringArray) throws ConnectionException, ZebraIllegalArgumentException {
        PrinterFilePropertiesList printerFilePropertiesList = this.retrieveFilePropertiesFromPrinter();
        PrinterFilePropertiesList printerFilePropertiesList2 = printerFilePropertiesList.filterByExtension(stringArray);
        String[] stringArray2 = printerFilePropertiesList2.getFileNamesFromProperties();
        return stringArray2;
    }

    @Override
    public List<PrinterObjectProperties> retrieveObjectsProperties() throws ConnectionException, ZebraIllegalArgumentException {
        PrinterFilePropertiesList printerFilePropertiesList = this.retrieveFilePropertiesFromPrinter();
        return printerFilePropertiesList.getObjectsProperties();
    }

    public List<PrinterObjectProperties> retrieveObjectsProperties(List<StorageInfo> list, Set<DriveType> set) throws ConnectionException, ZebraIllegalArgumentException {
        PrinterFilePropertiesList printerFilePropertiesList = this.retrieveFilePropertiesFromPrinter();
        if (set != null && !set.isEmpty()) {
            HashMap<String, DriveType> hashMap = new HashMap<String, DriveType>();
            for (StorageInfo object : list) {
                hashMap.put(String.valueOf(object.driveLetter), object.driveType);
            }
            Iterator<Object> iterator = printerFilePropertiesList.getObjectsProperties().iterator();
            while (iterator.hasNext()) {
                PrinterObjectProperties printerObjectProperties = (PrinterObjectProperties)iterator.next();
                String string = printerObjectProperties.getDrivePrefix().replaceAll(":", "");
                DriveType driveType = string.equalsIgnoreCase("Z") ? DriveType.READ_ONLY : (DriveType)((Object)hashMap.get(string));
                if (set.contains((Object)(driveType != null ? driveType : DriveType.UNKNOWN))) continue;
                iterator.remove();
            }
        }
        return printerFilePropertiesList.getObjectsProperties();
    }

    public List<PrinterObjectProperties> retrieveObjectsPropertiesWithCrc32(List<StorageInfo> list, Set<DriveType> set, PrinterLanguage printerLanguage) throws ConnectionException, ZebraIllegalArgumentException {
        PrinterFilePropertiesList printerFilePropertiesList = set == null || set.isEmpty() ? this.getObjectsListFromAllDrives(printerLanguage) : this.getObjectsListForDriveTypes(list, set, printerLanguage);
        return printerFilePropertiesList.getObjectsProperties();
    }

    public List<StorageInfo> getStorageInfo() throws ConnectionException {
        PrinterCommandImpl printerCommandImpl = new PrinterCommandImpl(ZPLUtilities.PRINTER_GET_STORAGE_INFO_COMMAND);
        String string = new String(printerCommandImpl.sendAndWaitForResponse(this.printerConnection, this.printerConnection.getMaxTimeoutForRead(), this.printerConnection.getTimeToWaitForMoreData()));
        return ZPLUtilities.parseHWCommand(string);
    }

    public List<StorageInfo> getStorageInfoViaJsonChannel() throws ConnectionException {
        try {
            PrinterCommandImpl printerCommandImpl = new PrinterCommandImpl("{}{\"file.drive_info\":null}");
            String string = new String(printerCommandImpl.sendAndWaitForValidJsonResponse(this.printerConnection));
            return ZPLUtilities.parseFileDriveInfoJson(string);
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
    }

    public List<StorageInfo> getStorageInfoViaSgd() throws ConnectionException {
        try {
            PrinterCommandImpl printerCommandImpl = new PrinterCommandImpl("! U1 getvar \"file.drive_info\"\r\n");
            String string = new String(printerCommandImpl.sendAndWaitForValidJsonResponse(this.printerConnection)).replaceAll("^\"|\"$", "");
            string = String.format("{ \"file.drive_info\" : %s }", string);
            return ZPLUtilities.parseFileDriveInfoJson(string);
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
    }

    private PrinterFilePropertiesList getObjectsListForDriveTypes(List<StorageInfo> list, Set<DriveType> set, PrinterLanguage printerLanguage) throws ConnectionException, ZebraIllegalArgumentException {
        PrinterFilePropertiesList printerFilePropertiesList = new PrinterFilePropertiesList();
        for (StorageInfo storageInfo : list) {
            if (!set.contains((Object)storageInfo.driveType)) continue;
            printerFilePropertiesList.addAll(this.getObjectsListFromDrive(String.valueOf(storageInfo.driveLetter), printerLanguage).getObjectsProperties());
        }
        return printerFilePropertiesList;
    }

    private PrinterFilePropertiesList getObjectsListFromAllDrives(PrinterLanguage printerLanguage) throws ConnectionException {
        return this.getObjectsListFromDrive("", printerLanguage);
    }

    private PrinterFilePropertiesList getObjectsListFromDrive(String string, PrinterLanguage printerLanguage) throws ConnectionException {
        PrinterCommandImpl printerCommandImpl;
        if (printerLanguage == PrinterLanguage.LINE_PRINT && !(this.printerConnection instanceof StatusConnection)) {
            this.printerConnection.write(("! U1 setvar \"file.drive_listing\" \"" + string + "\"" + "\r\n").getBytes());
            printerCommandImpl = new PrinterCommandImpl("! U1 getvar \"file.drive_listing\"\r\n");
        } else {
            printerCommandImpl = new PrinterCommandImpl("{}{\"file.drive_listing\":\"" + string + "\"}");
        }
        String string2 = new String(printerCommandImpl.sendAndWaitForValidJsonResponse(this.printerConnection));
        if (printerLanguage == PrinterLanguage.LINE_PRINT && !(this.printerConnection instanceof StatusConnection)) {
            string2 = string2.replaceAll("^\"|\"$", "");
            string2 = "{\"file.drive_listing\":" + string2 + "}";
        }
        return this.extractFilePropertiesFromJsonFileDriveListingResponse(string2);
    }

    private static class FileObjectWithCrc32Data {
        public String access;
        public long size;
        public long crc32;
        public String date;
        public String flags;
    }
}

