/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.fileConversion.internal;

import com.zebra.sdk.util.fileConversion.internal.PrinterFileType;
import com.zebra.sdk.util.fileConversion.internal.PrinterWrappingType;
import com.zebra.sdk.util.fileConversion.internal.StreamDecoratorBase;
import com.zebra.sdk.util.internal.PrinterFileMetadata;
import com.zebra.sdk.util.internal.ZCRC16;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public abstract class ZplUnwrapperStreamBase
extends StreamDecoratorBase {
    InputStream dataUnwrapperStream;
    String fileNameOnPrinter;
    long unmimedFileSize = 0L;
    char crc16 = '\u0000';
    char sum = '\u0000';
    PrinterFileType unwrappedType;

    protected abstract PrinterWrappingType getTypeToUnwrap();

    @Override
    public int read() throws IOException {
        int n = this.dataUnwrapperStream.read();
        if (n != -1) {
            ++this.unmimedFileSize;
            this.sum = (char)(this.sum + n);
            this.crc16 = ZCRC16.addCrc16Byte_cpcl(this.crc16, n);
        }
        return n;
    }

    @Override
    public PrinterFileMetadata getPrinterFileMetadata() {
        String string = String.format("%04X", this.crc16);
        String string2 = String.format("%04X", (this.sum ^ 0xFFFF) + 1);
        PrinterFileMetadata printerFileMetadata = new PrinterFileMetadata(this.unmimedFileSize, string, string2, this.fileNameOnPrinter);
        printerFileMetadata.setPrinterFileType(this.unwrappedType);
        printerFileMetadata.setPrinterWrappingType(this.getTypeToUnwrap());
        return printerFileMetadata;
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((InputStream)this.dataUnwrapperStream);
        super.close();
    }
}

