/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPv6Util {
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    public static List<String> getAddressAndPort(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "\\[(.*?)\\]:(\\d+)(?:$|[^:\\d])";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            arrayList.add(matcher.group(1));
            arrayList.add(matcher.group(2));
            if (matcher.groupCount() >= 3 && matcher.group(3) != null) {
                arrayList.add(matcher.group(3));
            }
            if (matcher.groupCount() >= 4 && matcher.group(4) != null) {
                arrayList.add(matcher.group(4));
            }
        }
        return arrayList;
    }

    public static List<String> getAddressAndPorts(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "\\[(.*?)\\]:(\\d+)(:(\\d+))?";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            arrayList.add(matcher.group(1));
            arrayList.add(matcher.group(2));
            if (matcher.groupCount() >= 3 && matcher.group(3) != null) {
                arrayList.add(matcher.group(3));
            }
            if (matcher.groupCount() >= 4 && matcher.group(4) != null) {
                arrayList.add(matcher.group(4));
            }
        }
        return arrayList;
    }

    public static String getZoneId(String string) {
        Pattern pattern = Pattern.compile("%\\d+");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    public static boolean isIPv6Address(String string) {
        return IPv6Util.isIPv6StdAddress(string) || IPv6Util.isIPv6HexCompressedAddress(string);
    }

    public static boolean isIPv6StdAddress(String string) {
        return IPV6_STD_PATTERN.matcher(string).matches();
    }

    public static boolean isIPv6HexCompressedAddress(String string) {
        return IPV6_HEX_COMPRESSED_PATTERN.matcher(string).matches();
    }
}

