/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import com.zebra.sdk.util.internal.PrinterFileMetadata;
import java.io.InputStream;

public class PrinterFileDescriptor {
    private String name;
    private InputStream sourceStream;
    private PrinterFileMetadata metaData;

    public PrinterFileDescriptor(InputStream inputStream, String string, PrinterFileMetadata printerFileMetadata) {
        if (string == null || 2 >= string.length()) {
            throw new IllegalArgumentException("File name not provided");
        }
        if (string.charAt(1) != ':' && !string.startsWith("\\")) {
            throw new IllegalArgumentException("Drive letter not specified");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Source stream is null");
        }
        this.name = string;
        this.sourceStream = inputStream;
        this.metaData = printerFileMetadata;
    }

    public String getName() {
        return this.name;
    }

    public InputStream getSourceStream() {
        return this.sourceStream;
    }

    public long getFileSize() {
        return this.metaData.getFileSize();
    }

    public String getCrc16() {
        return this.metaData.getCrc16();
    }

    public String getCheckSum() {
        return this.metaData.getCheckSum();
    }
}

