@ECHO OFF
if not "%1" == "max" start /MAX cmd /c %0 max & exit/b
SET JRE_HOME=%CD%\jre
REM echo %JRE_HOME%
REM "%JRE_HOME%"\bin\java -version
REM pause 

:: ******************************
:: user defaults
SET _defaultAddress=192.168.1.94
SET _defaultPort=9143
SET _defaultAction=receive
:: ******************************
:MAIN
CLS
SETLOCAL ENABLEDELAYEDEXPANSION
ECHO ******************************************************************************************************************************************
ECHO *   Zebra Technologies TLS Connection Demo : Date: 28 NOV 2025                                                                           *
ECHO *                                                                                                                                        *
ECHO *   Protect your data with TLS encryption using certificates deployed to a Zebra printer running Link-OS v5.2 or later.                  *
ECHO *   This demo uses a sample Java application to demonstrate sending label data over a TLS connection.                                    *
ECHO *   Use Wireshark to observe the encrypted and un-encrypted data.                                                                        *
ECHO *   HINT: You can change the default printer IP address at the top of the batch file.                                                    *
ECHO *                                                                                                                                        *
ECHO *   References:                                                                                                                          *
ECHO *   https://docs.oracle.com/javase/10/security/sample-code-illustrating-secure-socket-connection-client-and-server.htm                   *
ECHO *   Link-OS SDK Version: 2.15.5543                                                                                                       *
ECHO *                                                                                                                                        *
ECHO *   This software utility is strictly for demonstration purposes only.                                                                   *
ECHO *   The certificate it uses or generates contain Zebra specific attributes.                                                              *
ECHO *   Customers should generate and deploy certificates with their specific attributes and other desired parameters such as                *
ECHO *   validity period, key type and size. See Zebra's PrintSecure Administration Guide for further details and instructions.               *
ECHO *                                                                                                                                        *
ECHO ******************************************************************************************************************************************
ECHO.
ECHO  USAGE INFORMATION:
ECHO  Printers running Link-OS version 7.4.2 or later contain a self-signed certificate for TLS and therfore it's not necessary to use option 3.
ECHO  If your printer is running a Link-OS version prior to 7.4.2 you must use option 3 once to deploy a certificate to use this demo.
ECHO.
ECHO  MAIN MENU (Default IP address: !_defaultAddress!)
ECHO.
ECHO  1. Use TLS connection.
ECHO     Use this option to communicate over a TLS connection.
ECHO.
ECHO  2. Use STANDARD connection.
ECHO     Use this option to communicate over a standard TCP connection (no encryption).
ECHO.
ECHO  3. Deploy the certificate to your printer.
ECHO     Use this option to deploy a certificate to your printer.
ECHO.
ECHO  4. Remove the certificate from your printer.
ECHO     Use this option to remove the certificate from your printer.
ECHO.
ECHO  5. Visit the PrintSecure homepage.
ECHO     Access more PrintSecure information ^& resources.
ECHO.
ECHO  6. View sample network captures.
ECHO     View an image of network captures showing the label data encrypted ^& un-encrypted.
ECHO.
ECHO  7. Get printer information.
ECHO     Use this option to retrieve printer settings related to this demo.
ECHO.
ECHO  Q. Quit.
ECHO.

:: MAIN MENU
SET /P "_menu=Choose menu option. Type [1-7 or Q] and press <Enter>: " || SET _menu=""
IF "%_menu%"=="1" GOTO GETINFOADVANCED
IF "%_menu%"=="2" GOTO DEMO-NOTLS
IF "%_menu%"=="3" GOTO DEPLOYCERTS
IF "%_menu%"=="4" GOTO REMOVECERTS
IF "%_menu%"=="5" GOTO LAUNCHPSHOMEPAGE
IF "%_menu%"=="6" GOTO SHOWCAPTUREIMAGES
IF "%_menu%"=="7" GOTO GETPRINTERINFO
IF /I "%_menu%"=="r" GOTO RESTARTPRINTER
IF /I "%_menu%"=="h" GOTO SDKHELP
IF /I "%_menu%"=="q" GOTO QUIT

ECHO.
ECHO =============INVALID INPUT=============
ECHO. 
ECHO      Please select a valid option
ECHO          from the Main Menu   
ECHO. 
ECHO =======PRESS ANY KEY TO CONTINUE=======

PAUSE > NUL
GOTO MAIN

:GETINFOADVANCED
CLS
ECHO.
ECHO Use TLS connection:
SET /P "_address=Enter the ip address of the printer and press <Enter> (default !_defaultAddress!): " || SET _address=!_defaultAddress!
SET /P "_port=Enter the port to use and press <Enter> (default !_defaultPort!): " || SET _port=!_defaultPort!
SET /P "_action=Enter the action to perform [send or receive] and press <Enter> (default !_defaultAction!): " || SET _action=!_defaultAction!
GOTO DEMO-TLS
	
:GETINFOSIMPLE
SET /P "_address=Enter the ip address of the printer and press <Enter> (default !_defaultAddress!): " || SET _address=!_defaultAddress!
GOTO DEMO-NOTLS


:DEMO-TLS
CLS
ECHO.
ECHO Running demo using secure connection ...
REM ECHO (NOTE: check the certificate is stored on the printer if you see: Connection refused: connect)
ECHO.
"%JRE_HOME%"\bin\java -jar resources\SSLSocketClient.jar !_address! !_port! !_action!
ECHO.
PAUSE
GOTO MAIN

:DEMO-NOTLS
CLS
ECHO.
ECHO Running demo using standard TCP connection ...
SET /P "_address=Enter the ip address of the printer and press <Enter> (default !_defaultAddress!): " || SET _address=!_defaultAddress!
ECHO.
ECHO Sending file to !_address!
ECHO -------------------------------------------------
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar send !_address! resources\tls-label.zpl --tcp
ECHO.
PAUSE
GOTO MAIN

:DEPLOYCERTS
CLS
ECHO.
ECHO Deploy certificate to printer:
SET /P "_address=Enter the ip address of the printer and press <Enter> (default !_defaultAddress!): " || SET _address=!_defaultAddress!
ECHO.
ECHO Checking for Protected Mode ...
	:: check for protected mode
	FOR /F tokens^=4^ delims^=^" %%S in ('%JRE_HOME%\bin\java -jar zsdk\ZSDK_API.jar sendJSON %_address% {}{\"device.protected_mode\":null} --tcp') DO (
	SET _protectedmode=%%S)
	
	 :: display message about protected mode
     IF %_protectedmode% ==off (
     	:: Not in protected mode
		ECHO Protected Mode is %_protectedmode% so continuing ...
  		ECHO ----------------------------------------------------
     ) ELSE (
		:: Protected mode is on
		ECHO Protected Mode is %_protectedmode% so can't continue.
		ECHO Returning to the main menu.
    	ECHO --------------------------------------------------------
		PAUSE
		GOTO MAIN
    )

ECHO Checking Link-OS version ...
	:: check the Link-OS version
	FOR /F tokens^=4^ delims^=^" %%S in ('%JRE_HOME%\bin\java -jar zsdk\ZSDK_API.jar sendJSON %_address% {}{\"appl.link_os_version\":null} --tcp') DO (
	SET _LinkOSversion=%%S
	SET _versionInteger=!_LinkOSversion:~0,1!!_LinkOSversion:~2,1!)
	
	 :: display message about compatible version
     IF %_versionInteger% GEQ 52 (
     	:: version is >= 5.2
		ECHO Link-OS version !_LinkOSversion! is supported.
  		ECHO ----------------------------------------------------
     ) ELSE (
		:: version < 5.2
		ECHO Link-OS version !_LinkOSversion! is not supported.
		ECHO Returning to the main menu.
    	ECHO --------------------------------------------------------
		PAUSE
		GOTO MAIN
    )

ECHO.
ECHO Enabling TLS on the printer ...
ECHO -------------------------------------------------
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar sendJSON !_address! {}{\"ip.tls.enable\":\"on\"} --tcp
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar sendJSON !_address! {}{\"ip.tls.port\":\"9143\"} --tcp
ECHO -------------------------------------------------
ECHO.
ECHO Configuring certificate files on printer IP address !_address! ...
ECHO.
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar store !_address! resources\ZebraPrinter.crt --name E:TLSRAW_CERT.NRD --tcp
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar store !_address! resources\ZebraPrinter.key --name E:TLSRAW_KEY.NRD --tcp
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar sendJSON !_address! {}{\"file.delete\":\"E:TLSRAW_CA.NRD\"} --tcp
ECHO -------------------------------------------------
ECHO.
ECHO Configuring certificate files complete.
ECHO TLSRAW_CERT.NRD and TLSRAW_KEY.NRD should be in the list of NRD files.
ECHO Listing .NRD files on the printer ...
ECHO -------------------------------------------------
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar ls !_address! E:*.NRD --tcp
ECHO -------------------------------------------------
ECHO.
ECHO The printer must be restarted for the certificates to take effect.
SET /P "_reboot=Press Y and press <Enter> to restart the printer now or any other key and <Enter>."
IF /I "!_reboot!"=="Y" (
	:: restart the printer
	ECHO Restarting the printer ...
	"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar reset !_address! --printer --tcp -v
	) ELSE (
	:: do not restart the printer
	ECHO The printer has not been restarted.
	)
ECHO.
PAUSE
GOTO MAIN

:REMOVECERTS
CLS
ECHO.
ECHO Remove certificate files from printer:
SET /P "_address=Enter the ip address of the printer and press <Enter> (default !_defaultAddress!): " || SET _address=!_defaultAddress!
ECHO.
ECHO Removing certificate files from printer IP address !_address! ...
ECHO -------------------------------------------------
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar sendJSON !_address! {}{\"file.delete\":\"E:TLSRAW_CERT.NRD\"} --tcp
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar sendJSON !_address! {}{\"file.delete\":\"E:TLSRAW_KEY.NRD\"} --tcp
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar sendJSON !_address! {}{\"file.delete\":\"E:TLSRAW_CA.NRD\"} --tcp
ECHO -------------------------------------------------
ECHO.
ECHO Removing certificate files complete.
ECHO Listing .NRD files on the printer ...
ECHO -------------------------------------------------
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar ls !_address! E:*.NRD --tcp
ECHO -------------------------------------------------
ECHO.
:: restart the printer
ECHO Restarting the printer ...
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar reset !_address! --printer --tcp -v
PAUSE
GOTO MAIN

:RESTARTPRINTER
CLS
ECHO.
ECHO Restart printer:
SET /P "_address=Enter the ip address of the printer and press <Enter> (default !_defaultAddress!): " || SET _address=!_defaultAddress!
ECHO.
ECHO Restarting the printer ...
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar reset !_address! --printer --tcp -v
PAUSE
GOTO MAIN

:GETPRINTERINFO
CLS
ECHO.
ECHO Get printer info:
SET /P "_address=Enter the ip address of the printer and press <Enter> (default !_defaultAddress!): " || SET _address=!_defaultAddress!
ECHO.
ECHO Getting Protected Mode state ...
ECHO -------------------------------------------------
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar sendJSON %_address% {}{\"device.protected_mode\":null} --tcp
ECHO -------------------------------------------------
ECHO.
ECHO Getting Link-OS version ...
ECHO -------------------------------------------------
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar sendJSON %_address% {}{\"appl.link_os_version\":null} --tcp
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar sendJSON %_address% {}{\"appl.link_os_version_full\":null} --tcp
ECHO -------------------------------------------------
ECHO.
ECHO Getting TLS settings ...
ECHO -------------------------------------------------
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar sendJSON !_address! {}{\"ip.tls.enable\":\"on\"} --tcp
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar sendJSON !_address! {}{\"ip.tls.port\":\"9143\"} --tcp
ECHO -------------------------------------------------
ECHO.
ECHO Listing .NRD files on the printer ...
ECHO -------------------------------------------------
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar ls !_address! E:*.NRD --tcp
ECHO -------------------------------------------------
PAUSE
GOTO MAIN

:LAUNCHPSHOMEPAGE
START https://www.zebra.com/printsecure
GOTO MAIN

:SHOWCAPTUREIMAGES
START resources\sample-wireshark-captures.jpg
GOTO MAIN

:SDKHELP
CLS
"%JRE_HOME%"\bin\java -jar zsdk\ZSDK_API.jar
PAUSE
GOTO MAIN

:QUIT
EXIT

